/*
 * Decompiled with CFR 0.152.
 */
package org.igniterealtime.jbosh;

import java.security.NoSuchAlgorithmException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.apache.http.HttpHost;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.igniterealtime.jbosh.AbstractBody;
import org.igniterealtime.jbosh.ApacheHTTPResponse;
import org.igniterealtime.jbosh.BOSHClientConfig;
import org.igniterealtime.jbosh.CMSessionParams;
import org.igniterealtime.jbosh.HTTPResponse;
import org.igniterealtime.jbosh.HTTPSender;

final class ApacheHTTPSender
implements HTTPSender {
    private final Lock lock = new ReentrantLock();
    private BOSHClientConfig cfg;
    private HttpClient httpClient;

    ApacheHTTPSender() {
        HttpClient.class.getName();
    }

    private static synchronized HttpClient initHttpClient(BOSHClientConfig config) {
        SSLConnectionSocketFactory sslFactory = new SSLConnectionSocketFactory(ApacheHTTPSender.getSslSocketFactory(config), SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        PlainConnectionSocketFactory csf = PlainConnectionSocketFactory.getSocketFactory();
        Registry r = RegistryBuilder.create().register("http", (Object)csf).register("https", (Object)sslFactory).build();
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager(r);
        cm.setMaxTotal(100);
        RequestConfig rc = RequestConfig.custom().setExpectContinueEnabled(false).setContentCompressionEnabled(config.isCompressionEnabled()).build();
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).setDefaultRequestConfig(rc);
        if (config != null && config.getProxyHost() != null && config.getProxyPort() != 0) {
            HttpHost proxy = new HttpHost(config.getProxyHost(), config.getProxyPort());
            httpClientBuilder.setProxy(proxy);
        }
        return httpClientBuilder.build();
    }

    private static SSLSocketFactory getSslSocketFactory(BOSHClientConfig config) {
        if (config.getSSLContext() != null) {
            return config.getSSLContext().getSocketFactory();
        }
        try {
            return SSLContext.getDefault().getSocketFactory();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void init(BOSHClientConfig session) {
        this.lock.lock();
        try {
            this.cfg = session;
            this.httpClient = ApacheHTTPSender.initHttpClient(session);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void destroy() {
        this.lock.lock();
        try {
            if (this.httpClient != null) {
                this.httpClient.getConnectionManager().shutdown();
            }
        }
        finally {
            this.cfg = null;
            this.httpClient = null;
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HTTPResponse send(CMSessionParams params, AbstractBody body) {
        BOSHClientConfig mCfg;
        HttpClient mClient;
        this.lock.lock();
        try {
            if (this.httpClient == null) {
                this.httpClient = ApacheHTTPSender.initHttpClient(this.cfg);
            }
            mClient = this.httpClient;
            mCfg = this.cfg;
        }
        finally {
            this.lock.unlock();
        }
        return new ApacheHTTPResponse(mClient, mCfg, params, body);
    }
}

