/*
 * Decompiled with CFR 0.152.
 */
package org.igniterealtime.jbosh;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.igniterealtime.jbosh.AbstractBody;
import org.igniterealtime.jbosh.HTTPResponse;

final class HTTPExchange {
    private static final Logger LOG = Logger.getLogger(HTTPExchange.class.getName());
    private final AbstractBody request;
    private final Lock lock = new ReentrantLock();
    private final Condition ready = this.lock.newCondition();
    private HTTPResponse response;

    HTTPExchange(AbstractBody req) {
        if (req == null) {
            throw new IllegalArgumentException("Request body cannot be null");
        }
        this.request = req;
    }

    AbstractBody getRequest() {
        return this.request;
    }

    HTTPResponse getHTTPResponse() {
        this.lock.lock();
        try {
            while (this.response == null) {
                try {
                    this.ready.await();
                }
                catch (InterruptedException intx) {
                    LOG.log(Level.FINEST, "Interrupted", intx);
                }
            }
            HTTPResponse hTTPResponse = this.response;
            return hTTPResponse;
        }
        finally {
            this.lock.unlock();
        }
    }

    void setHTTPResponse(HTTPResponse resp) {
        this.lock.lock();
        try {
            if (this.response != null) {
                throw new IllegalStateException("HTTPResponse was already set");
            }
            this.response = resp;
            this.ready.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }
}

