/*
 * Decompiled with CFR 0.152.
 */
package org.igniterealtime.jbosh;

import org.igniterealtime.jbosh.AbstractAttr;
import org.igniterealtime.jbosh.BOSHException;

abstract class AbstractIntegerAttr
extends AbstractAttr<Integer> {
    protected AbstractIntegerAttr(int val) throws BOSHException {
        super(val);
    }

    protected AbstractIntegerAttr(String val) throws BOSHException {
        super(AbstractIntegerAttr.parseInt(val));
    }

    private static int parseInt(String str) throws BOSHException {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException nfx) {
            throw new BOSHException("Could not parse an integer from the value provided: " + str, nfx);
        }
    }

    protected final void checkMinValue(int minVal) throws BOSHException {
        int intVal = (Integer)this.getValue();
        if (intVal < minVal) {
            throw new BOSHException("Illegal attribute value '" + intVal + "' provided.  Must be >= " + minVal);
        }
    }

    public int intValue() {
        return (Integer)this.getValue();
    }
}

