/*
 * Decompiled with CFR 0.152.
 */
package mehdi.sakout.fancybuttons;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.Outline;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.RippleDrawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.support.annotation.FontRes;
import android.support.v4.content.res.ResourcesCompat;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewOutlineProvider;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.util.ArrayList;
import mehdi.sakout.fancybuttons.R;
import mehdi.sakout.fancybuttons.Utils;

public class FancyButton
extends LinearLayout {
    public static final String TAG = FancyButton.class.getSimpleName();
    private Context mContext;
    private int mDefaultBackgroundColor = -16777216;
    private int mFocusBackgroundColor = 0;
    private int mDisabledBackgroundColor = Color.parseColor((String)"#f6f7f9");
    private int mDisabledTextColor = Color.parseColor((String)"#bec2c9");
    private int mDisabledBorderColor = Color.parseColor((String)"#dddfe2");
    private int mDefaultTextColor = -1;
    private int mDefaultIconColor = -1;
    private int mTextPosition = 1;
    private int mDefaultTextSize = Utils.spToPx(this.getContext(), 15.0f);
    private int mDefaultTextGravity = 17;
    private String mText = null;
    private Drawable mIconResource = null;
    private int mFontIconSize = Utils.spToPx(this.getContext(), 15.0f);
    private String mFontIcon = null;
    private int mIconPosition = 1;
    private int mIconPaddingLeft = 10;
    private int mIconPaddingRight = 10;
    private int mIconPaddingTop = 0;
    private int mIconPaddingBottom = 0;
    private int mBorderColor = 0;
    private int mBorderWidth = 0;
    private int mRadius = 0;
    private int mRadiusTopLeft = 0;
    private int mRadiusTopRight = 0;
    private int mRadiusBottomLeft = 0;
    private int mRadiusBottomRight = 0;
    private boolean mEnabled = true;
    private boolean mTextAllCaps = false;
    private Typeface mTextTypeFace = null;
    private Typeface mIconTypeFace = null;
    private int textStyle;
    public static final int POSITION_LEFT = 1;
    public static final int POSITION_RIGHT = 2;
    public static final int POSITION_TOP = 3;
    public static final int POSITION_BOTTOM = 4;
    private String mDefaultIconFont = "fontawesome.ttf";
    private String mDefaultTextFont = "robotoregular.ttf";
    private ImageView mIconView;
    private TextView mFontIconView;
    private TextView mTextView;
    private boolean mGhost = false;
    private boolean mUseSystemFont = false;
    private boolean mUseRippleEffect = true;

    public FancyButton(Context context) {
        super(context);
        this.mContext = context;
        this.mTextTypeFace = Utils.findFont(this.mContext, this.mDefaultTextFont, null);
        this.mIconTypeFace = Utils.findFont(this.mContext, this.mDefaultIconFont, null);
        this.initializeFancyButton();
    }

    public FancyButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        TypedArray attrsArray = context.obtainStyledAttributes(attrs, R.styleable.FancyButtonsAttrs, 0, 0);
        this.initAttributesArray(attrsArray);
        attrsArray.recycle();
        this.initializeFancyButton();
    }

    private void initializeFancyButton() {
        this.initializeButtonContainer();
        this.mTextView = this.setupTextView();
        this.mIconView = this.setupIconView();
        this.mFontIconView = this.setupFontIconView();
        this.removeAllViews();
        this.setupBackground();
        ArrayList<Object> views = new ArrayList<Object>();
        if (this.mIconPosition == 1 || this.mIconPosition == 3) {
            if (this.mIconView != null) {
                views.add(this.mIconView);
            }
            if (this.mFontIconView != null) {
                views.add(this.mFontIconView);
            }
            if (this.mTextView != null) {
                views.add(this.mTextView);
            }
        } else {
            if (this.mTextView != null) {
                views.add(this.mTextView);
            }
            if (this.mIconView != null) {
                views.add(this.mIconView);
            }
            if (this.mFontIconView != null) {
                views.add(this.mFontIconView);
            }
        }
        for (View view : views) {
            this.addView(view);
        }
    }

    private TextView setupTextView() {
        if (this.mText == null) {
            this.mText = "Fancy Button";
        }
        TextView textView = new TextView(this.mContext);
        textView.setText((CharSequence)this.mText);
        textView.setGravity(this.mDefaultTextGravity);
        textView.setTextColor(this.mEnabled ? this.mDefaultTextColor : this.mDisabledTextColor);
        textView.setTextSize((float)Utils.pxToSp(this.getContext(), this.mDefaultTextSize));
        textView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        if (!this.isInEditMode() && !this.mUseSystemFont) {
            textView.setTypeface(this.mTextTypeFace, this.textStyle);
        }
        return textView;
    }

    private TextView setupFontIconView() {
        if (this.mFontIcon != null) {
            TextView fontIconView = new TextView(this.mContext);
            fontIconView.setTextColor(this.mEnabled ? this.mDefaultIconColor : this.mDisabledTextColor);
            LinearLayout.LayoutParams iconTextViewParams = new LinearLayout.LayoutParams(-2, -2);
            iconTextViewParams.rightMargin = this.mIconPaddingRight;
            iconTextViewParams.leftMargin = this.mIconPaddingLeft;
            iconTextViewParams.topMargin = this.mIconPaddingTop;
            iconTextViewParams.bottomMargin = this.mIconPaddingBottom;
            if (this.mTextView != null) {
                if (this.mIconPosition == 3 || this.mIconPosition == 4) {
                    iconTextViewParams.gravity = 17;
                    fontIconView.setGravity(17);
                } else {
                    fontIconView.setGravity(16);
                    iconTextViewParams.gravity = 16;
                }
            } else {
                iconTextViewParams.gravity = 17;
                fontIconView.setGravity(16);
            }
            fontIconView.setLayoutParams((ViewGroup.LayoutParams)iconTextViewParams);
            if (!this.isInEditMode()) {
                fontIconView.setTextSize((float)Utils.pxToSp(this.getContext(), this.mFontIconSize));
                fontIconView.setText((CharSequence)this.mFontIcon);
                fontIconView.setTypeface(this.mIconTypeFace);
            } else {
                fontIconView.setTextSize((float)Utils.pxToSp(this.getContext(), this.mFontIconSize));
                fontIconView.setText((CharSequence)"O");
            }
            return fontIconView;
        }
        return null;
    }

    private ImageView setupIconView() {
        if (this.mIconResource != null) {
            ImageView iconView = new ImageView(this.mContext);
            iconView.setImageDrawable(this.mIconResource);
            iconView.setPadding(this.mIconPaddingLeft, this.mIconPaddingTop, this.mIconPaddingRight, this.mIconPaddingBottom);
            LinearLayout.LayoutParams iconViewParams = new LinearLayout.LayoutParams(-2, -2);
            if (this.mTextView != null) {
                iconViewParams.gravity = this.mIconPosition == 3 || this.mIconPosition == 4 ? 17 : 0x800003;
                iconViewParams.rightMargin = 10;
                iconViewParams.leftMargin = 10;
            } else {
                iconViewParams.gravity = 16;
            }
            iconView.setLayoutParams((ViewGroup.LayoutParams)iconViewParams);
            return iconView;
        }
        return null;
    }

    private void initAttributesArray(TypedArray attrsArray) {
        this.mDefaultBackgroundColor = attrsArray.getColor(R.styleable.FancyButtonsAttrs_fb_defaultColor, this.mDefaultBackgroundColor);
        this.mFocusBackgroundColor = attrsArray.getColor(R.styleable.FancyButtonsAttrs_fb_focusColor, this.mFocusBackgroundColor);
        this.mDisabledBackgroundColor = attrsArray.getColor(R.styleable.FancyButtonsAttrs_fb_disabledColor, this.mDisabledBackgroundColor);
        this.mEnabled = attrsArray.getBoolean(R.styleable.FancyButtonsAttrs_android_enabled, true);
        this.mDisabledTextColor = attrsArray.getColor(R.styleable.FancyButtonsAttrs_fb_disabledTextColor, this.mDisabledTextColor);
        this.mDisabledBorderColor = attrsArray.getColor(R.styleable.FancyButtonsAttrs_fb_disabledBorderColor, this.mDisabledBorderColor);
        this.mDefaultTextColor = attrsArray.getColor(R.styleable.FancyButtonsAttrs_fb_textColor, this.mDefaultTextColor);
        this.mDefaultIconColor = attrsArray.getColor(R.styleable.FancyButtonsAttrs_fb_iconColor, this.mDefaultTextColor);
        this.mDefaultTextSize = (int)attrsArray.getDimension(R.styleable.FancyButtonsAttrs_fb_textSize, (float)this.mDefaultTextSize);
        this.mDefaultTextSize = (int)attrsArray.getDimension(R.styleable.FancyButtonsAttrs_android_textSize, (float)this.mDefaultTextSize);
        this.mDefaultTextGravity = attrsArray.getInt(R.styleable.FancyButtonsAttrs_fb_textGravity, this.mDefaultTextGravity);
        this.mBorderColor = attrsArray.getColor(R.styleable.FancyButtonsAttrs_fb_borderColor, this.mBorderColor);
        this.mBorderWidth = (int)attrsArray.getDimension(R.styleable.FancyButtonsAttrs_fb_borderWidth, (float)this.mBorderWidth);
        this.mRadius = (int)attrsArray.getDimension(R.styleable.FancyButtonsAttrs_fb_radius, (float)this.mRadius);
        this.mRadiusTopLeft = (int)attrsArray.getDimension(R.styleable.FancyButtonsAttrs_fb_radiusTopLeft, (float)this.mRadius);
        this.mRadiusTopRight = (int)attrsArray.getDimension(R.styleable.FancyButtonsAttrs_fb_radiusTopRight, (float)this.mRadius);
        this.mRadiusBottomLeft = (int)attrsArray.getDimension(R.styleable.FancyButtonsAttrs_fb_radiusBottomLeft, (float)this.mRadius);
        this.mRadiusBottomRight = (int)attrsArray.getDimension(R.styleable.FancyButtonsAttrs_fb_radiusBottomRight, (float)this.mRadius);
        this.mFontIconSize = (int)attrsArray.getDimension(R.styleable.FancyButtonsAttrs_fb_fontIconSize, (float)this.mFontIconSize);
        this.mIconPaddingLeft = (int)attrsArray.getDimension(R.styleable.FancyButtonsAttrs_fb_iconPaddingLeft, (float)this.mIconPaddingLeft);
        this.mIconPaddingRight = (int)attrsArray.getDimension(R.styleable.FancyButtonsAttrs_fb_iconPaddingRight, (float)this.mIconPaddingRight);
        this.mIconPaddingTop = (int)attrsArray.getDimension(R.styleable.FancyButtonsAttrs_fb_iconPaddingTop, (float)this.mIconPaddingTop);
        this.mIconPaddingBottom = (int)attrsArray.getDimension(R.styleable.FancyButtonsAttrs_fb_iconPaddingBottom, (float)this.mIconPaddingBottom);
        this.mTextAllCaps = attrsArray.getBoolean(R.styleable.FancyButtonsAttrs_fb_textAllCaps, false);
        this.mTextAllCaps = attrsArray.getBoolean(R.styleable.FancyButtonsAttrs_android_textAllCaps, false);
        this.mGhost = attrsArray.getBoolean(R.styleable.FancyButtonsAttrs_fb_ghost, this.mGhost);
        this.mUseSystemFont = attrsArray.getBoolean(R.styleable.FancyButtonsAttrs_fb_useSystemFont, this.mUseSystemFont);
        String text = attrsArray.getString(R.styleable.FancyButtonsAttrs_fb_text);
        if (text == null) {
            text = attrsArray.getString(R.styleable.FancyButtonsAttrs_android_text);
        }
        this.mIconPosition = attrsArray.getInt(R.styleable.FancyButtonsAttrs_fb_iconPosition, this.mIconPosition);
        this.textStyle = attrsArray.getInt(R.styleable.FancyButtonsAttrs_android_textStyle, 0);
        String fontIcon = attrsArray.getString(R.styleable.FancyButtonsAttrs_fb_fontIconResource);
        String iconFontFamily = attrsArray.getString(R.styleable.FancyButtonsAttrs_fb_iconFont);
        String textFontFamily = attrsArray.getString(R.styleable.FancyButtonsAttrs_fb_textFont);
        try {
            this.mIconResource = attrsArray.getDrawable(R.styleable.FancyButtonsAttrs_fb_iconResource);
        }
        catch (Exception e) {
            this.mIconResource = null;
        }
        if (fontIcon != null) {
            this.mFontIcon = fontIcon;
        }
        if (text != null) {
            String string = this.mText = this.mTextAllCaps ? text.toUpperCase() : text;
        }
        if (!this.isInEditMode()) {
            this.mIconTypeFace = iconFontFamily != null ? Utils.findFont(this.mContext, iconFontFamily, this.mDefaultIconFont) : Utils.findFont(this.mContext, this.mDefaultIconFont, null);
            Typeface fontResource = this.getTypeface(attrsArray);
            this.mTextTypeFace = fontResource != null ? fontResource : (textFontFamily != null ? Utils.findFont(this.mContext, textFontFamily, this.mDefaultTextFont) : Utils.findFont(this.mContext, this.mDefaultTextFont, null));
        }
    }

    private Typeface getTypeface(TypedArray ta) {
        int fontId;
        if (ta.hasValue(R.styleable.FancyButtonsAttrs_android_fontFamily) && (fontId = ta.getResourceId(R.styleable.FancyButtonsAttrs_android_fontFamily, 0)) != 0) {
            return ResourcesCompat.getFont((Context)this.getContext(), (int)fontId);
        }
        if (ta.hasValue(R.styleable.FancyButtonsAttrs_fb_textFontRes) && (fontId = ta.getResourceId(R.styleable.FancyButtonsAttrs_fb_textFontRes, 0)) != 0) {
            return ResourcesCompat.getFont((Context)this.getContext(), (int)fontId);
        }
        return null;
    }

    @TargetApi(value=21)
    private Drawable getRippleDrawable(Drawable defaultDrawable, Drawable focusDrawable, Drawable disabledDrawable) {
        if (!this.mEnabled) {
            return disabledDrawable;
        }
        return new RippleDrawable(ColorStateList.valueOf((int)this.mFocusBackgroundColor), defaultDrawable, focusDrawable);
    }

    private void applyRadius(GradientDrawable drawable) {
        if (this.mRadius > 0) {
            drawable.setCornerRadius((float)this.mRadius);
        } else {
            drawable.setCornerRadii(new float[]{this.mRadiusTopLeft, this.mRadiusTopLeft, this.mRadiusTopRight, this.mRadiusTopRight, this.mRadiusBottomRight, this.mRadiusBottomRight, this.mRadiusBottomLeft, this.mRadiusBottomLeft});
        }
    }

    @SuppressLint(value={"NewApi"})
    private void setupBackground() {
        GradientDrawable defaultDrawable = new GradientDrawable();
        this.applyRadius(defaultDrawable);
        if (this.mGhost) {
            defaultDrawable.setColor(this.getResources().getColor(17170445));
        } else {
            defaultDrawable.setColor(this.mDefaultBackgroundColor);
        }
        GradientDrawable focusDrawable = new GradientDrawable();
        this.applyRadius(focusDrawable);
        focusDrawable.setColor(this.mFocusBackgroundColor);
        GradientDrawable disabledDrawable = new GradientDrawable();
        this.applyRadius(disabledDrawable);
        disabledDrawable.setColor(this.mDisabledBackgroundColor);
        disabledDrawable.setStroke(this.mBorderWidth, this.mDisabledBorderColor);
        if (this.mBorderColor != 0) {
            defaultDrawable.setStroke(this.mBorderWidth, this.mBorderColor);
        }
        if (!this.mEnabled) {
            defaultDrawable.setStroke(this.mBorderWidth, this.mDisabledBorderColor);
            if (this.mGhost) {
                disabledDrawable.setColor(this.getResources().getColor(17170445));
            }
        }
        if (this.mUseRippleEffect && Build.VERSION.SDK_INT >= 21) {
            this.setBackground(this.getRippleDrawable((Drawable)defaultDrawable, (Drawable)focusDrawable, (Drawable)disabledDrawable));
        } else {
            StateListDrawable states = new StateListDrawable();
            GradientDrawable drawable2 = new GradientDrawable();
            this.applyRadius(drawable2);
            if (this.mGhost) {
                drawable2.setColor(this.getResources().getColor(17170445));
            } else {
                drawable2.setColor(this.mFocusBackgroundColor);
            }
            if (this.mBorderColor != 0) {
                if (this.mGhost) {
                    drawable2.setStroke(this.mBorderWidth, this.mFocusBackgroundColor);
                } else {
                    drawable2.setStroke(this.mBorderWidth, this.mBorderColor);
                }
            }
            if (!this.mEnabled) {
                if (this.mGhost) {
                    drawable2.setStroke(this.mBorderWidth, this.mDisabledBorderColor);
                } else {
                    drawable2.setStroke(this.mBorderWidth, this.mDisabledBorderColor);
                }
            }
            if (this.mFocusBackgroundColor != 0) {
                states.addState(new int[]{16842919}, (Drawable)drawable2);
                states.addState(new int[]{16842908}, (Drawable)drawable2);
                states.addState(new int[]{-16842910}, (Drawable)disabledDrawable);
            }
            states.addState(new int[0], (Drawable)defaultDrawable);
            if (Build.VERSION.SDK_INT < 16) {
                this.setBackgroundDrawable((Drawable)states);
            } else {
                this.setBackground((Drawable)states);
            }
        }
    }

    private void initializeButtonContainer() {
        if (this.mIconPosition == 3 || this.mIconPosition == 4) {
            this.setOrientation(1);
        } else {
            this.setOrientation(0);
        }
        if (this.getLayoutParams() == null) {
            LinearLayout.LayoutParams containerParams = new LinearLayout.LayoutParams(-2, -2);
            this.setLayoutParams((ViewGroup.LayoutParams)containerParams);
        }
        this.setGravity(17);
        if (this.mIconResource == null && this.mFontIcon == null && this.getPaddingLeft() == 0 && this.getPaddingRight() == 0 && this.getPaddingTop() == 0 && this.getPaddingBottom() == 0) {
            this.setPadding(20, 0, 20, 0);
        }
    }

    public void setText(String text) {
        this.mText = text = this.mTextAllCaps ? text.toUpperCase() : text;
        if (this.mTextView == null) {
            this.initializeFancyButton();
        } else {
            this.mTextView.setText((CharSequence)text);
        }
    }

    public void setTextAllCaps(boolean textAllCaps) {
        this.mTextAllCaps = textAllCaps;
        this.setText(this.mText);
    }

    public void setTextColor(int color2) {
        this.mDefaultTextColor = color2;
        if (this.mTextView == null) {
            this.initializeFancyButton();
        } else {
            this.mTextView.setTextColor(color2);
        }
    }

    public void setIconColor(int color2) {
        if (this.mFontIconView != null) {
            this.mFontIconView.setTextColor(color2);
        }
    }

    public void setBackgroundColor(int color2) {
        this.mDefaultBackgroundColor = color2;
        if (this.mIconView != null || this.mFontIconView != null || this.mTextView != null) {
            this.setupBackground();
        }
    }

    public void setFocusBackgroundColor(int color2) {
        this.mFocusBackgroundColor = color2;
        if (this.mIconView != null || this.mFontIconView != null || this.mTextView != null) {
            this.setupBackground();
        }
    }

    public void setDisableBackgroundColor(int color2) {
        this.mDisabledBackgroundColor = color2;
        if (this.mIconView != null || this.mFontIconView != null || this.mTextView != null) {
            this.setupBackground();
        }
    }

    public void setDisableTextColor(int color2) {
        this.mDisabledTextColor = color2;
        if (this.mTextView == null) {
            this.initializeFancyButton();
        } else if (!this.mEnabled) {
            this.mTextView.setTextColor(color2);
        }
    }

    public void setDisableBorderColor(int color2) {
        this.mDisabledBorderColor = color2;
        if (this.mIconView != null || this.mFontIconView != null || this.mTextView != null) {
            this.setupBackground();
        }
    }

    public void setTextSize(int textSize) {
        this.mDefaultTextSize = Utils.spToPx(this.getContext(), textSize);
        if (this.mTextView != null) {
            this.mTextView.setTextSize((float)textSize);
        }
    }

    public void setTextGravity(int gravity) {
        this.mDefaultTextGravity = gravity;
        if (this.mTextView != null) {
            this.setGravity(gravity);
        }
    }

    public void setIconPadding(int paddingLeft, int paddingTop, int paddingRight, int paddingBottom) {
        this.mIconPaddingLeft = paddingLeft;
        this.mIconPaddingTop = paddingTop;
        this.mIconPaddingRight = paddingRight;
        this.mIconPaddingBottom = paddingBottom;
        if (this.mIconView != null) {
            this.mIconView.setPadding(this.mIconPaddingLeft, this.mIconPaddingTop, this.mIconPaddingRight, this.mIconPaddingBottom);
        }
        if (this.mFontIconView != null) {
            this.mFontIconView.setPadding(this.mIconPaddingLeft, this.mIconPaddingTop, this.mIconPaddingRight, this.mIconPaddingBottom);
        }
    }

    public void setIconResource(int drawable) {
        this.mIconResource = this.mContext.getResources().getDrawable(drawable);
        if (this.mIconView == null || this.mFontIconView != null) {
            this.mFontIconView = null;
            this.initializeFancyButton();
        } else {
            this.mIconView.setImageDrawable(this.mIconResource);
        }
    }

    public void setIconResource(Drawable drawable) {
        this.mIconResource = drawable;
        if (this.mIconView == null || this.mFontIconView != null) {
            this.mFontIconView = null;
            this.initializeFancyButton();
        } else {
            this.mIconView.setImageDrawable(this.mIconResource);
        }
    }

    public void setIconResource(String icon) {
        this.mFontIcon = icon;
        if (this.mFontIconView == null) {
            this.mIconView = null;
            this.initializeFancyButton();
        } else {
            this.mFontIconView.setText((CharSequence)icon);
        }
    }

    public void setFontIconSize(int iconSize) {
        this.mFontIconSize = Utils.spToPx(this.getContext(), iconSize);
        if (this.mFontIconView != null) {
            this.mFontIconView.setTextSize((float)iconSize);
        }
    }

    public void setIconPosition(int position) {
        this.mIconPosition = position > 0 && position < 5 ? position : 1;
        this.initializeFancyButton();
    }

    public void setBorderColor(int color2) {
        this.mBorderColor = color2;
        if (this.mIconView != null || this.mFontIconView != null || this.mTextView != null) {
            this.setupBackground();
        }
    }

    public void setBorderWidth(int width) {
        this.mBorderWidth = width;
        if (this.mIconView != null || this.mFontIconView != null || this.mTextView != null) {
            this.setupBackground();
        }
    }

    public void setRadius(int radius) {
        this.mRadius = radius;
        if (this.mIconView != null || this.mFontIconView != null || this.mTextView != null) {
            this.setupBackground();
        }
    }

    public void setRadius(int[] radius) {
        this.mRadiusTopLeft = radius[0];
        this.mRadiusTopRight = radius[1];
        this.mRadiusBottomLeft = radius[2];
        this.mRadiusBottomRight = radius[3];
        if (this.mIconView != null || this.mFontIconView != null || this.mTextView != null) {
            this.setupBackground();
        }
    }

    public void setCustomTextFont(String fontName) {
        this.mTextTypeFace = Utils.findFont(this.mContext, fontName, this.mDefaultTextFont);
        if (this.mTextView == null) {
            this.initializeFancyButton();
        } else {
            this.mTextView.setTypeface(this.mTextTypeFace, this.textStyle);
        }
    }

    public void setCustomTextFont(@FontRes int fontId) {
        this.mTextTypeFace = ResourcesCompat.getFont((Context)this.getContext(), (int)fontId);
        if (this.mTextView == null) {
            this.initializeFancyButton();
        } else {
            this.mTextView.setTypeface(this.mTextTypeFace, this.textStyle);
        }
    }

    public void setCustomIconFont(String fontName) {
        this.mIconTypeFace = Utils.findFont(this.mContext, fontName, this.mDefaultIconFont);
        if (this.mFontIconView == null) {
            this.initializeFancyButton();
        } else {
            this.mFontIconView.setTypeface(this.mIconTypeFace);
        }
    }

    public void setEnabled(boolean value) {
        super.setEnabled(value);
        this.mEnabled = value;
        this.initializeFancyButton();
    }

    public void setGhost(boolean ghost) {
        this.mGhost = ghost;
        if (this.mIconView != null || this.mFontIconView != null || this.mTextView != null) {
            this.setupBackground();
        }
    }

    public void setUsingSystemFont(boolean status) {
        this.mUseSystemFont = status;
    }

    public CharSequence getText() {
        if (this.mTextView != null) {
            return this.mTextView.getText();
        }
        return "";
    }

    public TextView getTextViewObject() {
        return this.mTextView;
    }

    public TextView getIconFontObject() {
        return this.mFontIconView;
    }

    public ImageView getIconImageObject() {
        return this.mIconView;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (Build.VERSION.SDK_INT >= 21) {
            this.setOutlineProvider(new CustomOutline(w, h));
        }
    }

    @TargetApi(value=21)
    private class CustomOutline
    extends ViewOutlineProvider {
        int width;
        int height;

        CustomOutline(int width, int height) {
            this.width = width;
            this.height = height;
        }

        public void getOutline(View view, Outline outline) {
            if (FancyButton.this.mRadius == 0) {
                outline.setRect(0, 10, this.width, this.height);
            } else {
                outline.setRoundRect(0, 10, this.width, this.height, (float)FancyButton.this.mRadius);
            }
        }
    }
}

