/*
 * Decompiled with CFR 0.152.
 */
package com.labters.documentscanner.libraries;

import android.graphics.Bitmap;
import com.labters.documentscanner.helpers.ImageUtils;
import com.labters.documentscanner.helpers.MathUtils;
import com.labters.documentscanner.libraries.PerspectiveTransformation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.opencv.core.Core;
import org.opencv.core.Mat;
import org.opencv.core.MatOfInt;
import org.opencv.core.MatOfPoint;
import org.opencv.core.MatOfPoint2f;
import org.opencv.core.Point;
import org.opencv.core.Size;
import org.opencv.imgproc.Imgproc;

public class NativeClass {
    private static final int THRESHOLD_LEVEL = 2;
    private static final double AREA_LOWER_THRESHOLD = 0.2;
    private static final double AREA_UPPER_THRESHOLD = 0.98;
    private static final double DOWNSCALE_IMAGE_SIZE = 600.0;
    private static Comparator<MatOfPoint2f> AreaDescendingComparator;

    public Bitmap getScannedBitmap(Bitmap bitmap, float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4) {
        PerspectiveTransformation perspective = new PerspectiveTransformation();
        MatOfPoint2f rectangle = new MatOfPoint2f();
        rectangle.fromArray(new Point[]{new Point((double)x1, (double)y1), new Point((double)x2, (double)y2), new Point((double)x3, (double)y3), new Point((double)x4, (double)y4)});
        Mat dstMat = perspective.transform(ImageUtils.bitmapToMat(bitmap), rectangle);
        return ImageUtils.matToBitmap(dstMat);
    }

    public MatOfPoint2f getPoint(Bitmap bitmap) {
        Mat src = ImageUtils.bitmapToMat(bitmap);
        double ratio = 600.0 / (double)Math.max(src.width(), src.height());
        Size downscaledSize = new Size((double)src.width() * ratio, (double)src.height() * ratio);
        Mat downscaled = new Mat(downscaledSize, src.type());
        Imgproc.resize((Mat)src, (Mat)downscaled, (Size)downscaledSize);
        List<MatOfPoint2f> rectangles = this.getPoints(downscaled);
        if (rectangles.size() == 0) {
            return null;
        }
        Collections.sort(rectangles, AreaDescendingComparator);
        MatOfPoint2f largestRectangle = rectangles.get(0);
        MatOfPoint2f result = MathUtils.scaleRectangle(largestRectangle, 1.0 / ratio);
        return result;
    }

    public List<MatOfPoint2f> getPoints(Mat src) {
        Mat blurred = new Mat();
        Imgproc.medianBlur((Mat)src, (Mat)blurred, (int)9);
        Mat gray0 = new Mat(blurred.size(), 0);
        Mat gray = new Mat();
        ArrayList contours = new ArrayList();
        ArrayList<MatOfPoint2f> rectangles = new ArrayList<MatOfPoint2f>();
        ArrayList<Mat> sources = new ArrayList<Mat>();
        sources.add(blurred);
        ArrayList<Mat> destinations = new ArrayList<Mat>();
        destinations.add(gray0);
        int srcArea = src.rows() * src.cols();
        for (int c = 0; c < 3; ++c) {
            int[] ch = new int[]{c, 0};
            MatOfInt fromTo = new MatOfInt(ch);
            Core.mixChannels(sources, destinations, (MatOfInt)fromTo);
            for (int l = 0; l < 2; ++l) {
                if (l == 0) {
                    Imgproc.Canny((Mat)gray0, (Mat)gray, (double)10.0, (double)20.0);
                    Imgproc.dilate((Mat)gray, (Mat)gray, (Mat)Mat.ones((Size)new Size(3.0, 3.0), (int)0));
                } else {
                    int threshold = (l + 1) * 255 / 2;
                    Imgproc.threshold((Mat)gray0, (Mat)gray, (double)threshold, (double)255.0, (int)0);
                }
                Imgproc.findContours((Mat)gray, contours, (Mat)new Mat(), (int)1, (int)2);
                for (MatOfPoint contour : contours) {
                    MatOfPoint2f contourFloat = MathUtils.toMatOfPointFloat(contour);
                    double arcLen = Imgproc.arcLength((MatOfPoint2f)contourFloat, (boolean)true) * 0.02;
                    MatOfPoint2f approx = new MatOfPoint2f();
                    Imgproc.approxPolyDP((MatOfPoint2f)contourFloat, (MatOfPoint2f)approx, (double)arcLen, (boolean)true);
                    if (!this.isRectangle(approx, srcArea)) continue;
                    rectangles.add(approx);
                }
            }
        }
        return rectangles;
    }

    private boolean isRectangle(MatOfPoint2f polygon, int srcArea) {
        MatOfPoint polygonInt = MathUtils.toMatOfPointInt(polygon);
        if (polygon.rows() != 4) {
            return false;
        }
        double area = Math.abs(Imgproc.contourArea((Mat)polygon));
        if (area < (double)srcArea * 0.2 || area > (double)srcArea * 0.98) {
            return false;
        }
        if (!Imgproc.isContourConvex((MatOfPoint)polygonInt)) {
            return false;
        }
        double maxCosine = 0.0;
        Point[] approxPoints = polygon.toArray();
        for (int i = 2; i < 5; ++i) {
            double cosine = Math.abs(MathUtils.angle(approxPoints[i % 4], approxPoints[i - 2], approxPoints[i - 1]));
            maxCosine = Math.max(cosine, maxCosine);
        }
        return !(maxCosine >= 0.3);
    }

    static {
        System.loadLibrary("opencv_java3");
        AreaDescendingComparator = new Comparator<MatOfPoint2f>(){

            @Override
            public int compare(MatOfPoint2f m1, MatOfPoint2f m2) {
                double area1 = Imgproc.contourArea((Mat)m1);
                double area2 = Imgproc.contourArea((Mat)m2);
                return (int)Math.ceil(area2 - area1);
            }
        };
    }
}

