/*
 * Decompiled with CFR 0.152.
 */
package org.matomo.sdk.extra;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.matomo.sdk.Matomo;
import org.matomo.sdk.QueryParams;
import org.matomo.sdk.TrackMe;
import timber.log.Timber;

public class CustomVariables {
    private final Map<String, JSONArray> mVars = new ConcurrentHashMap<String, JSONArray>();
    private static final String TAG = Matomo.tag(CustomVariables.class);
    protected static final int MAX_LENGTH = 200;

    public CustomVariables() {
    }

    public CustomVariables(@NonNull CustomVariables variables) {
        this.mVars.putAll(variables.mVars);
    }

    public CustomVariables(@Nullable String json) {
        if (json != null) {
            try {
                JSONObject jsonObject = new JSONObject(json);
                Iterator it = jsonObject.keys();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    this.put(key, jsonObject.getJSONArray(key));
                }
            }
            catch (JSONException e) {
                Timber.tag((String)TAG).e((Throwable)e, "Failed to create CustomVariables from JSON", new Object[0]);
            }
        }
    }

    public CustomVariables putAll(CustomVariables customVariables) {
        this.mVars.putAll(customVariables.mVars);
        return this;
    }

    public CustomVariables put(int index, String name, String value) {
        if (index > 0 && name != null & value != null) {
            if (name.length() > 200) {
                Timber.tag((String)TAG).w("Name is too long %s", new Object[]{name});
                name = name.substring(0, 200);
            }
            if (value.length() > 200) {
                Timber.tag((String)TAG).w("Value is too long %s", new Object[]{value});
                value = value.substring(0, 200);
            }
            this.put(Integer.toString(index), new JSONArray(Arrays.asList(name, value)));
        } else {
            Timber.tag((String)TAG).w("Index is out of range or name/value is null", new Object[0]);
        }
        return this;
    }

    public CustomVariables put(String index, JSONArray values) {
        if (values.length() == 2 && index != null) {
            this.mVars.put(index, values);
        } else {
            Timber.tag((String)TAG).w("values.length() should be equal 2", new Object[0]);
        }
        return this;
    }

    public String toString() {
        JSONObject json = new JSONObject(this.mVars);
        return json.length() > 0 ? json.toString() : null;
    }

    public int size() {
        return this.mVars.size();
    }

    public TrackMe injectVisitVariables(@NonNull TrackMe trackMe) {
        trackMe.set(QueryParams.VISIT_SCOPE_CUSTOM_VARIABLES, this.toString());
        return trackMe;
    }

    @NonNull
    public TrackMe toVisitVariables() {
        return this.injectVisitVariables(new TrackMe());
    }
}

