/*
 * Decompiled with CFR 0.152.
 */
package org.matomo.sdk.dispatcher;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.matomo.sdk.Matomo;
import org.matomo.sdk.TrackMe;
import org.matomo.sdk.dispatcher.DispatchMode;
import org.matomo.sdk.dispatcher.Dispatcher;
import org.matomo.sdk.dispatcher.Event;
import org.matomo.sdk.dispatcher.EventCache;
import org.matomo.sdk.dispatcher.Packet;
import org.matomo.sdk.dispatcher.PacketFactory;
import org.matomo.sdk.dispatcher.PacketSender;
import org.matomo.sdk.tools.Connectivity;
import timber.log.Timber;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\u0018\u0000 <2\u00020\u0001:\u0001<B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010 \u001a\u00020\u0011H\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0011H\u0016J\u0010\u0010$\u001a\u00020\"2\u0006\u0010%\u001a\u00020\u0013H\u0016J\b\u0010&\u001a\u00020\u0013H\u0016J\u0010\u0010'\u001a\u00020\"2\u0006\u0010(\u001a\u00020\u0016H\u0016J\b\u0010)\u001a\u00020\u0016H\u0016J\u0010\u0010*\u001a\u00020\"2\u0006\u0010+\u001a\u00020\u0019H\u0016J\b\u0010,\u001a\u00020\u0019H\u0016J\b\u0010-\u001a\u00020\u0016H\u0002J\b\u0010.\u001a\u00020\u0016H\u0016J\b\u0010/\u001a\u00020\"H\u0016J\b\u00100\u001a\u00020\"H\u0016J\u0010\u00101\u001a\u00020\"2\u0006\u00102\u001a\u000203H\u0016J\u0016\u00108\u001a\u00020\"2\f\u00109\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0016J\u000e\u0010:\u001a\b\u0012\u0004\u0012\u00020\u001f0;H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u000205X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00106\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u00107\u00a8\u0006="}, d2={"Lorg/matomo/sdk/dispatcher/DefaultDispatcher;", "Lorg/matomo/sdk/dispatcher/Dispatcher;", "eventCache", "Lorg/matomo/sdk/dispatcher/EventCache;", "connectivity", "Lorg/matomo/sdk/tools/Connectivity;", "packetFactory", "Lorg/matomo/sdk/dispatcher/PacketFactory;", "packetSender", "Lorg/matomo/sdk/dispatcher/PacketSender;", "<init>", "(Lorg/matomo/sdk/dispatcher/EventCache;Lorg/matomo/sdk/tools/Connectivity;Lorg/matomo/sdk/dispatcher/PacketFactory;Lorg/matomo/sdk/dispatcher/PacketSender;)V", "threadControl", "", "sleepToken", "Ljava/util/concurrent/Semaphore;", "timeOut", "", "dispatchInterval", "", "retryCounter", "forcedBlocking", "", "dispatchGzipped", "dispatchMode", "Lorg/matomo/sdk/dispatcher/DispatchMode;", "running", "dispatchThread", "Ljava/lang/Thread;", "mDryRunTarget", "", "Lorg/matomo/sdk/dispatcher/Packet;", "getConnectionTimeOut", "setConnectionTimeOut", "", "timeOutIn", "setDispatchInterval", "dispatchIntervalIn", "getDispatchInterval", "setDispatchGzipped", "dispatchGzippedIn", "getDispatchGzipped", "setDispatchMode", "dispatchModeIn", "getDispatchMode", "launch", "forceDispatch", "forceDispatchBlocking", "clear", "submit", "trackMe", "Lorg/matomo/sdk/TrackMe;", "loop", "Ljava/lang/Runnable;", "isOnline", "()Z", "setDryRunTarget", "dryRunTarget", "getDryRunTarget", "", "Companion", "tracker_release"})
public final class DefaultDispatcher
implements Dispatcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EventCache eventCache;
    @NotNull
    private final Connectivity connectivity;
    @NotNull
    private final PacketFactory packetFactory;
    @NotNull
    private final PacketSender packetSender;
    @NotNull
    private final Object threadControl;
    @NotNull
    private final Semaphore sleepToken;
    private volatile int timeOut;
    private volatile long dispatchInterval;
    private volatile int retryCounter;
    private volatile boolean forcedBlocking;
    private boolean dispatchGzipped;
    @NotNull
    private volatile DispatchMode dispatchMode;
    private volatile boolean running;
    @Nullable
    private volatile Thread dispatchThread;
    @Nullable
    private List<Packet> mDryRunTarget;
    @NotNull
    private final Runnable loop;
    @NotNull
    private static final String TAG;

    public DefaultDispatcher(@NotNull EventCache eventCache, @NotNull Connectivity connectivity, @NotNull PacketFactory packetFactory, @NotNull PacketSender packetSender) {
        Intrinsics.checkNotNullParameter((Object)eventCache, (String)"eventCache");
        Intrinsics.checkNotNullParameter((Object)connectivity, (String)"connectivity");
        Intrinsics.checkNotNullParameter((Object)packetFactory, (String)"packetFactory");
        Intrinsics.checkNotNullParameter((Object)packetSender, (String)"packetSender");
        this.eventCache = eventCache;
        this.connectivity = connectivity;
        this.packetFactory = packetFactory;
        this.packetSender = packetSender;
        this.threadControl = new Object();
        this.sleepToken = new Semaphore(0);
        this.timeOut = 5000;
        this.dispatchInterval = 120000L;
        this.dispatchMode = DispatchMode.ALWAYS;
        this.packetSender.setGzipData(this.dispatchGzipped);
        this.packetSender.setTimeout(this.timeOut);
        this.loop = () -> DefaultDispatcher.loop$lambda$4(this);
    }

    @Override
    public int getConnectionTimeOut() {
        return this.timeOut;
    }

    @Override
    public void setConnectionTimeOut(int timeOutIn) {
        this.timeOut = timeOutIn;
        this.packetSender.setTimeout(this.timeOut);
    }

    @Override
    public void setDispatchInterval(long dispatchIntervalIn) {
        this.dispatchInterval = dispatchIntervalIn;
        if (this.dispatchInterval != -1L) {
            this.launch();
        }
    }

    @Override
    public long getDispatchInterval() {
        return this.dispatchInterval;
    }

    @Override
    public void setDispatchGzipped(boolean dispatchGzippedIn) {
        this.dispatchGzipped = dispatchGzippedIn;
        this.packetSender.setGzipData(this.dispatchGzipped);
    }

    @Override
    public boolean getDispatchGzipped() {
        return this.dispatchGzipped;
    }

    @Override
    public void setDispatchMode(@NotNull DispatchMode dispatchModeIn) {
        Intrinsics.checkNotNullParameter((Object)((Object)dispatchModeIn), (String)"dispatchModeIn");
        this.dispatchMode = dispatchModeIn;
    }

    @Override
    @NotNull
    public DispatchMode getDispatchMode() {
        return this.dispatchMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean launch() {
        Object object = this.threadControl;
        synchronized (object) {
            block4: {
                boolean bl = false;
                if (this.running) break block4;
                this.running = true;
                Thread thread = new Thread(this.loop);
                thread.setPriority(1);
                thread.setName("Matomo-default-dispatcher");
                this.dispatchThread = thread;
                thread.start();
                boolean bl2 = true;
                return bl2;
            }
            Unit unit = Unit.INSTANCE;
        }
        return false;
    }

    @Override
    public boolean forceDispatch() {
        if (!this.launch()) {
            this.retryCounter = 0;
            this.sleepToken.release();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forceDispatchBlocking() {
        Thread dispatchThreadLocal;
        Object object;
        Object object2 = this.threadControl;
        synchronized (object2) {
            boolean bl = false;
            this.forcedBlocking = true;
            object = Unit.INSTANCE;
        }
        if (this.forceDispatch()) {
            this.sleepToken.release();
        }
        if ((dispatchThreadLocal = this.dispatchThread) != null) {
            try {
                dispatchThreadLocal.join();
            }
            catch (InterruptedException e) {
                Timber.Forest.tag(TAG).d("Interrupted while waiting for dispatch thread to complete", new Object[0]);
            }
        }
        object = this.threadControl;
        synchronized (object) {
            boolean bl = false;
            this.forcedBlocking = false;
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    public void clear() {
        this.eventCache.clear();
        if (this.running) {
            this.forceDispatch();
        }
    }

    @Override
    public void submit(@NotNull TrackMe trackMe) {
        Intrinsics.checkNotNullParameter((Object)trackMe, (String)"trackMe");
        this.eventCache.add(new Event(trackMe.toMap()));
        if (this.dispatchInterval != -1L) {
            this.launch();
        }
    }

    private final boolean isOnline() {
        if (!this.connectivity.isConnected()) {
            return false;
        }
        return switch (WhenMappings.$EnumSwitchMapping$0[this.dispatchMode.ordinal()]) {
            case 1 -> false;
            case 2 -> true;
            case 3 -> {
                if (this.connectivity.getType() == Connectivity.Type.WIFI) {
                    yield true;
                }
                yield false;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Override
    public void setDryRunTarget(@NotNull List<Packet> dryRunTarget) {
        Intrinsics.checkNotNullParameter(dryRunTarget, (String)"dryRunTarget");
        this.mDryRunTarget = dryRunTarget;
    }

    @Override
    @NotNull
    public List<Packet> getDryRunTarget() {
        List<Packet> list = this.mDryRunTarget;
        Intrinsics.checkNotNull(list);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void loop$lambda$4(DefaultDispatcher this$0) {
        this$0.retryCounter = 0;
        while (this$0.running) {
            Object object;
            try {
                long sleepTime = this$0.dispatchInterval;
                if (this$0.retryCounter > 1) {
                    sleepTime += (long)Math.min((double)((long)this$0.retryCounter * this$0.dispatchInterval), (double)((long)5 * this$0.dispatchInterval));
                }
                this$0.sleepToken.tryAcquire(sleepTime, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Timber.Forest.tag(TAG).e((Throwable)e);
            }
            if (this$0.eventCache.updateState(this$0.isOnline())) {
                int count = 0;
                List drainedEvents = new ArrayList();
                this$0.eventCache.drainTo(drainedEvents);
                object = new Unit[]{Integer.valueOf(drainedEvents.size())};
                Timber.Forest.tag(TAG).d("Drained %s events.", (Object[])object);
                for (Packet packet : this$0.packetFactory.buildPackets(drainedEvents)) {
                    boolean success = false;
                    if (this$0.mDryRunTarget != null) {
                        Timber.Tree tree = Timber.Forest.tag(TAG);
                        Object[] objectArray = new Object[1];
                        List<Packet> list = this$0.mDryRunTarget;
                        Intrinsics.checkNotNull(list);
                        objectArray[0] = list.size();
                        tree.d("DryRun, stored HttpRequest, now %d.", objectArray);
                        List<Packet> list2 = this$0.mDryRunTarget;
                        Intrinsics.checkNotNull(list2);
                        Intrinsics.checkNotNull((Object)packet);
                        success = list2.add(packet);
                    } else {
                        PacketSender packetSender = this$0.packetSender;
                        Intrinsics.checkNotNull((Object)packet);
                        success = packetSender.send(packet);
                    }
                    if (success) {
                        count += packet.getEventCount();
                    } else {
                        Timber.Forest.tag(TAG).d("Failure while trying to send packet", new Object[0]);
                        int n = this$0.retryCounter;
                        this$0.retryCounter = n + 1;
                        break;
                    }
                    this$0.retryCounter = 0;
                    if (this$0.isOnline()) continue;
                    Timber.Forest.tag(TAG).d("Disconnected during dispatch loop", new Object[0]);
                    break;
                }
                object = new Object[]{count};
                Timber.Forest.tag(TAG).d("Dispatched %d events.", (Object[])object);
                if (count < drainedEvents.size()) {
                    object = new Object[]{drainedEvents.size() - count};
                    Timber.Forest.tag(TAG).d("Unable to send all events, re-queueing %d events", (Object[])object);
                    this$0.eventCache.requeue(drainedEvents.subList(count, drainedEvents.size()));
                    this$0.eventCache.updateState(this$0.isOnline());
                }
            }
            Object object2 = this$0.threadControl;
            synchronized (object2) {
                boolean bl = false;
                if (this$0.forcedBlocking || this$0.eventCache.isEmpty() || this$0.dispatchInterval < 0L) {
                    this$0.running = false;
                }
                object = Unit.INSTANCE;
            }
        }
    }

    static {
        Class[] classArray = new Class[]{DefaultDispatcher.class};
        TAG = Matomo.Companion.tag(classArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/matomo/sdk/dispatcher/DefaultDispatcher$Companion;", "", "<init>", "()V", "TAG", "", "tracker_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DispatchMode.values().length];
            try {
                nArray[DispatchMode.EXCEPTION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DispatchMode.ALWAYS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DispatchMode.WIFI_ONLY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

