/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.memoryfilesystem;

import java.io.IOException;
import java.nio.file.attribute.UserPrincipal;
import java.util.concurrent.Callable;

public final class CurrentUser {
    private static final ThreadLocal<UserPrincipal> USER = new ThreadLocal();

    private CurrentUser() {
        throw new AssertionError((Object)"not instantiable");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <V> V useDuring(UserPrincipal user, UserTask<V> task) throws IOException {
        UserPrincipal previous = USER.get();
        try {
            USER.set(user);
            V v = task.call();
            return v;
        }
        finally {
            if (previous == null) {
                USER.remove();
            } else {
                USER.set(previous);
            }
        }
    }

    public static void useDuring(UserPrincipal user, VoidUserTask task) throws IOException {
        CurrentUser.useDuring(user, () -> {
            task.call();
            return null;
        });
    }

    static UserPrincipal get() {
        return USER.get();
    }

    @FunctionalInterface
    public static interface UserTask<V>
    extends Callable<V> {
        @Override
        public V call() throws IOException;
    }

    @FunctionalInterface
    public static interface VoidUserTask {
        public void call() throws IOException;
    }
}

