/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.memoryfilesystem;

import com.github.marschall.memoryfilesystem.MemoryEntry;
import java.io.IOException;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileOwnerAttributeView;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.UserPrincipal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

final class AttributeAccessors {
    private static final int DOS_ATTRIBUTE_COUNT = 4;
    private static final int OWNER_ATTRIBUTE_COUNT = 1;
    private static final int BASIC_ATTRIBUTE_COUNT = 9;
    private static final Map<String, Map<String, AttributeAccessor>> ACCESSORS = new HashMap<String, Map<String, AttributeAccessor>>(4);

    AttributeAccessors() {
        throw new AssertionError((Object)"not instantiable");
    }

    private static Map<String, AttributeAccessor> buildOwnerAttributesMap() {
        return Collections.singletonMap("owner", new OwnerAccessor());
    }

    private static Map<String, AttributeAccessor> buildDosAttributesMap() {
        HashMap<String, AttributeAccessor> map = new HashMap<String, AttributeAccessor>(13);
        map.put("readonly", new IsReadOnlyAccessor());
        map.put("hidden", new IsHiddenAccessor());
        map.put("archive", new IsArchiveAccessor());
        map.put("system", new IsSymbolicLinkAccessor());
        return map;
    }

    private static Map<String, AttributeAccessor> buildPosixAttributesMap() {
        HashMap<String, AttributeAccessor> map = new HashMap<String, AttributeAccessor>(12);
        map.put("group", new GroupAccessor());
        map.put("permissions", new PermissionsAccessor());
        return map;
    }

    private static Map<String, AttributeAccessor> buildBasicFileAttributesMap() {
        HashMap<String, AttributeAccessor> map = new HashMap<String, AttributeAccessor>(9);
        map.put("lastModifiedTime", new LastModifiedTimeAccessor());
        map.put("lastAccessTime", new LastAccessTimeAccessor());
        map.put("creationTime", new CreationTimeAccessor());
        map.put("isRegularFile", new IsRegularFileAccessor());
        map.put("isDirectory", new IsDirectoryAccessor());
        map.put("isSymbolicLink", new IsSymbolicLinkAccessor());
        map.put("isOther", new IsOtherAccessor());
        map.put("size", new SizeAccessor());
        map.put("fileKey", new FileKeyAccessor());
        return map;
    }

    static void setAttribute(MemoryEntry entry, String attribute, Object value) throws IOException {
        AttributeAccessors.getAccessor(attribute).writeAttribute(value, entry);
    }

    static void setAttributes(MemoryEntry entry, FileAttribute<?> ... attrs) throws IOException {
        for (FileAttribute<?> attribute : attrs) {
            AttributeAccessors.getAccessor(attribute.name()).writeAttribute(attribute.value(), entry);
        }
    }

    static Map<String, Object> readAttributes(MemoryEntry entry, String viewAndAttribute) throws IOException {
        String attribute;
        String view;
        int colonIndex = viewAndAttribute.indexOf(58);
        if (colonIndex == viewAndAttribute.length() - 1) {
            throw new IllegalArgumentException("\"" + viewAndAttribute + "\" is missing attribute name");
        }
        if (colonIndex == -1) {
            view = "basic";
            attribute = viewAndAttribute;
        } else {
            view = viewAndAttribute.substring(0, colonIndex);
            attribute = viewAndAttribute.substring(colonIndex + 1);
        }
        Map<String, AttributeAccessor> viewMap = ACCESSORS.get(view);
        if (viewMap == null) {
            throw new UnsupportedOperationException("view \"" + view + "\" is not supported");
        }
        if (attribute.equals("*")) {
            return AttributeAccessors.readAllAttributes(entry, viewMap);
        }
        if (attribute.indexOf(44) != -1) {
            String[] attributes = attribute.split(",");
            return AttributeAccessors.readAttributes(entry, attributes, viewMap);
        }
        return AttributeAccessors.readSingleAttribute(entry, attribute, viewMap);
    }

    private static Map<String, Object> readSingleAttribute(MemoryEntry entry, String attribute, Map<String, AttributeAccessor> viewMap) throws IOException {
        AttributeAccessor accessor = viewMap.get(attribute);
        if (accessor == null) {
            throw new IllegalArgumentException("attribute \"" + attribute + "\" is not supported");
        }
        AttributeReadContext context = new AttributeReadContext(entry);
        Object value = accessor.readAttribute(context);
        return Collections.singletonMap(attribute, value);
    }

    private static Map<String, Object> readAttributes(MemoryEntry entry, String[] attributes, Map<String, AttributeAccessor> viewMap) throws IOException {
        HashMap<String, Object> values = new HashMap<String, Object>(attributes.length);
        AttributeReadContext context = new AttributeReadContext(entry);
        for (String each : attributes) {
            AttributeAccessor accessor = viewMap.get(each);
            if (accessor == null) {
                throw new IllegalArgumentException("attribute \"" + each + "\" is not supported");
            }
            values.put(each, accessor.readAttribute(context));
        }
        return values;
    }

    private static Map<String, Object> readAllAttributes(MemoryEntry entry, Map<String, AttributeAccessor> viewMap) throws IOException {
        HashMap<String, Object> values = new HashMap<String, Object>(viewMap.size());
        AttributeReadContext context = new AttributeReadContext(entry);
        for (Map.Entry<String, AttributeAccessor> each : viewMap.entrySet()) {
            AttributeAccessor accessor = each.getValue();
            values.put(each.getKey(), accessor.readAttribute(context));
        }
        return values;
    }

    private static AttributeAccessor getAccessor(String viewAndAttribute) {
        String attribute;
        String view;
        int colonIndex = viewAndAttribute.indexOf(58);
        if (colonIndex == viewAndAttribute.length() - 1) {
            throw new IllegalArgumentException("\"" + viewAndAttribute + "\" is missing attribute name");
        }
        if (colonIndex == -1) {
            view = "basic";
            attribute = viewAndAttribute;
        } else {
            view = viewAndAttribute.substring(0, colonIndex);
            attribute = viewAndAttribute.substring(colonIndex + 1);
        }
        Map<String, AttributeAccessor> viewMap = ACCESSORS.get(view);
        if (viewMap == null) {
            throw new UnsupportedOperationException("view \"" + view + "\" is not supported");
        }
        AttributeAccessor accessor = viewMap.get(attribute);
        if (accessor == null) {
            throw new IllegalArgumentException("attribute \"" + attribute + "\" of view \"" + view + "\" is not supported");
        }
        return accessor;
    }

    static {
        Map<String, AttributeAccessor> basicFileAttributesMap = AttributeAccessors.buildBasicFileAttributesMap();
        Map<String, AttributeAccessor> ownerAttributesMap = AttributeAccessors.buildOwnerAttributesMap();
        Map<String, AttributeAccessor> dosAttributesMap = AttributeAccessors.buildDosAttributesMap();
        Map<String, AttributeAccessor> posixAttributesMap = AttributeAccessors.buildPosixAttributesMap();
        dosAttributesMap.putAll(basicFileAttributesMap);
        posixAttributesMap.putAll(ownerAttributesMap);
        posixAttributesMap.putAll(basicFileAttributesMap);
        ACCESSORS.put("basic", basicFileAttributesMap);
        ACCESSORS.put("owner", ownerAttributesMap);
        ACCESSORS.put("dos", dosAttributesMap);
        ACCESSORS.put("posix", posixAttributesMap);
    }

    static interface AttributeAccessor {
        public Object readAttribute(AttributeReadContext var1) throws IOException;

        public void writeAttribute(Object var1, MemoryEntry var2) throws IOException;
    }

    static final class AttributeReadContext {
        private final MemoryEntry entry;
        private BasicFileAttributes basicFileAttributes;
        private DosFileAttributes dosFileAttributes;
        private PosixFileAttributes posixFileAttributes;
        private FileOwnerAttributeView fileOwnerAttributeView;

        AttributeReadContext(MemoryEntry entry) {
            this.entry = entry;
        }

        BasicFileAttributes getBasicFileAttributes() throws IOException {
            if (this.basicFileAttributes == null) {
                this.basicFileAttributes = this.entry.getFileAttributeView(BasicFileAttributeView.class).readAttributes();
            }
            return this.basicFileAttributes;
        }

        public DosFileAttributes getDosFileAttributes() throws IOException {
            if (this.dosFileAttributes == null) {
                this.dosFileAttributes = this.entry.getFileAttributeView(DosFileAttributeView.class).readAttributes();
            }
            return this.dosFileAttributes;
        }

        public PosixFileAttributes getPosixFileAttributes() throws IOException {
            if (this.posixFileAttributes == null) {
                this.posixFileAttributes = this.entry.getFileAttributeView(PosixFileAttributeView.class).readAttributes();
            }
            return this.posixFileAttributes;
        }

        public FileOwnerAttributeView getFileOwnerAttributeView() throws IOException {
            if (this.fileOwnerAttributeView == null) {
                this.fileOwnerAttributeView = this.entry.getFileAttributeView(FileOwnerAttributeView.class);
            }
            return this.fileOwnerAttributeView;
        }
    }

    static final class IsArchiveAccessor
    implements AttributeAccessor {
        IsArchiveAccessor() {
        }

        @Override
        public Object readAttribute(AttributeReadContext context) throws IOException {
            return context.getDosFileAttributes().isArchive();
        }

        @Override
        public void writeAttribute(Object value, MemoryEntry entry) throws IOException {
            entry.getFileAttributeView(DosFileAttributeView.class).setArchive((Boolean)value);
        }
    }

    static final class IsSystemAccessor
    implements AttributeAccessor {
        IsSystemAccessor() {
        }

        @Override
        public Object readAttribute(AttributeReadContext context) throws IOException {
            return context.getDosFileAttributes().isSystem();
        }

        @Override
        public void writeAttribute(Object value, MemoryEntry entry) throws IOException {
            entry.getFileAttributeView(DosFileAttributeView.class).setSystem((Boolean)value);
        }
    }

    static final class IsReadOnlyAccessor
    implements AttributeAccessor {
        IsReadOnlyAccessor() {
        }

        @Override
        public Object readAttribute(AttributeReadContext context) throws IOException {
            return context.getDosFileAttributes().isReadOnly();
        }

        @Override
        public void writeAttribute(Object value, MemoryEntry entry) throws IOException {
            entry.getFileAttributeView(DosFileAttributeView.class).setReadOnly((Boolean)value);
        }
    }

    static final class IsHiddenAccessor
    implements AttributeAccessor {
        IsHiddenAccessor() {
        }

        @Override
        public Object readAttribute(AttributeReadContext context) throws IOException {
            return context.getDosFileAttributes().isHidden();
        }

        @Override
        public void writeAttribute(Object value, MemoryEntry entry) throws IOException {
            entry.getFileAttributeView(DosFileAttributeView.class).setHidden((Boolean)value);
        }
    }

    static final class PermissionsAccessor
    implements AttributeAccessor {
        PermissionsAccessor() {
        }

        @Override
        public Object readAttribute(AttributeReadContext context) throws IOException {
            return context.getPosixFileAttributes().permissions();
        }

        @Override
        public void writeAttribute(Object value, MemoryEntry entry) throws IOException {
            entry.getFileAttributeView(PosixFileAttributeView.class).setPermissions((Set)value);
        }
    }

    static final class GroupAccessor
    implements AttributeAccessor {
        GroupAccessor() {
        }

        @Override
        public Object readAttribute(AttributeReadContext context) throws IOException {
            return context.getPosixFileAttributes().group();
        }

        @Override
        public void writeAttribute(Object value, MemoryEntry entry) throws IOException {
            entry.getFileAttributeView(PosixFileAttributeView.class).setGroup((GroupPrincipal)value);
        }
    }

    static final class OwnerAccessor
    implements AttributeAccessor {
        OwnerAccessor() {
        }

        @Override
        public Object readAttribute(AttributeReadContext context) throws IOException {
            return context.getFileOwnerAttributeView().getOwner();
        }

        @Override
        public void writeAttribute(Object value, MemoryEntry entry) throws IOException {
            entry.getFileAttributeView(FileOwnerAttributeView.class).setOwner((UserPrincipal)value);
        }
    }

    static final class FileKeyAccessor
    implements AttributeAccessor {
        FileKeyAccessor() {
        }

        @Override
        public Object readAttribute(AttributeReadContext context) throws IOException {
            return context.getBasicFileAttributes().fileKey();
        }

        @Override
        public void writeAttribute(Object value, MemoryEntry entry) {
            throw new IllegalArgumentException("\"fileKey\" can not be written");
        }
    }

    static final class SizeAccessor
    implements AttributeAccessor {
        SizeAccessor() {
        }

        @Override
        public Object readAttribute(AttributeReadContext context) throws IOException {
            return context.getBasicFileAttributes().size();
        }

        @Override
        public void writeAttribute(Object value, MemoryEntry entry) {
            throw new IllegalArgumentException("\"size\" can not be written");
        }
    }

    static final class IsSymbolicLinkAccessor
    implements AttributeAccessor {
        IsSymbolicLinkAccessor() {
        }

        @Override
        public Object readAttribute(AttributeReadContext context) throws IOException {
            return context.getBasicFileAttributes().isSymbolicLink();
        }

        @Override
        public void writeAttribute(Object value, MemoryEntry entry) {
            throw new IllegalArgumentException("\"isSymbolicLink\" can not be written");
        }
    }

    static final class IsOtherAccessor
    implements AttributeAccessor {
        IsOtherAccessor() {
        }

        @Override
        public Object readAttribute(AttributeReadContext context) throws IOException {
            return context.getBasicFileAttributes().isOther();
        }

        @Override
        public void writeAttribute(Object value, MemoryEntry entry) {
            throw new IllegalArgumentException("\"isOther\" can not be written");
        }
    }

    static final class IsDirectoryAccessor
    implements AttributeAccessor {
        IsDirectoryAccessor() {
        }

        @Override
        public Object readAttribute(AttributeReadContext context) throws IOException {
            return context.getBasicFileAttributes().isDirectory();
        }

        @Override
        public void writeAttribute(Object value, MemoryEntry entry) {
            throw new IllegalArgumentException("\"isDirectory\" can not be written");
        }
    }

    static final class IsRegularFileAccessor
    implements AttributeAccessor {
        IsRegularFileAccessor() {
        }

        @Override
        public Object readAttribute(AttributeReadContext context) throws IOException {
            return context.getBasicFileAttributes().isRegularFile();
        }

        @Override
        public void writeAttribute(Object value, MemoryEntry entry) {
            throw new IllegalArgumentException("\"isRegularFile\" can not be written");
        }
    }

    static final class CreationTimeAccessor
    implements AttributeAccessor {
        CreationTimeAccessor() {
        }

        @Override
        public Object readAttribute(AttributeReadContext context) throws IOException {
            return context.getBasicFileAttributes().creationTime();
        }

        @Override
        public void writeAttribute(Object value, MemoryEntry entry) throws IOException {
            entry.getBasicFileAttributeView().setTimes(null, null, (FileTime)value);
        }
    }

    static final class LastAccessTimeAccessor
    implements AttributeAccessor {
        LastAccessTimeAccessor() {
        }

        @Override
        public Object readAttribute(AttributeReadContext context) throws IOException {
            return context.getBasicFileAttributes().lastAccessTime();
        }

        @Override
        public void writeAttribute(Object value, MemoryEntry entry) throws IOException {
            entry.getBasicFileAttributeView().setTimes(null, (FileTime)value, null);
        }
    }

    static final class LastModifiedTimeAccessor
    implements AttributeAccessor {
        LastModifiedTimeAccessor() {
        }

        @Override
        public Object readAttribute(AttributeReadContext context) throws IOException {
            return context.getBasicFileAttributes().lastModifiedTime();
        }

        @Override
        public void writeAttribute(Object value, MemoryEntry entry) throws IOException {
            entry.getBasicFileAttributeView().setTimes((FileTime)value, null, null);
        }
    }
}

