/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.memoryfilesystem;

import com.github.marschall.memoryfilesystem.AutoRelease;
import com.github.marschall.memoryfilesystem.EntryCreationContext;
import com.github.marschall.memoryfilesystem.InitializingFileAttributeView;
import com.github.marschall.memoryfilesystem.MemoryDirectoryStream;
import com.github.marschall.memoryfilesystem.MemoryEntry;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.AccessMode;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

class MemoryDirectory
extends MemoryEntry {
    private final Map<String, MemoryEntry> entries = new HashMap<String, MemoryEntry>();
    private final MemoryDirectoryFileAttributesView basicFileAttributeView = new MemoryDirectoryFileAttributesView();
    private static final Set<PosixFilePermission> EXECUTE = EnumSet.of(PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.OTHERS_EXECUTE);

    MemoryDirectory(String originalName) {
        this(originalName, EntryCreationContext.empty());
    }

    MemoryDirectory(String originalName, EntryCreationContext context) {
        super(originalName, context);
    }

    private static Set<PosixFilePermission> addExecute(Set<PosixFilePermission> umask) {
        if (umask.isEmpty()) {
            return EXECUTE;
        }
        EnumSet<PosixFilePermission> copy = EnumSet.copyOf(umask);
        copy.addAll(EXECUTE);
        return copy;
    }

    DirectoryStream<Path> newDirectoryStream(Path basePath, DirectoryStream.Filter<? super Path> filter) throws AccessDeniedException {
        this.checkAccess(AccessMode.READ);
        ArrayList<String> elements = new ArrayList<String>(this.entries.keySet());
        return new MemoryDirectoryStream(basePath, filter, elements);
    }

    @Override
    BasicFileAttributeView getBasicFileAttributeView() {
        return this.basicFileAttributeView;
    }

    @Override
    InitializingFileAttributeView getInitializingFileAttributeView() {
        return this.basicFileAttributeView;
    }

    MemoryEntry getEntry(String name) {
        return this.entries.get(name);
    }

    MemoryEntry getEntryOrException(String name, Path path) throws IOException {
        MemoryEntry entry = this.getEntry(name);
        if (entry == null) {
            throw new NoSuchFileException(path.toString());
        }
        return entry;
    }

    boolean isEmpty() {
        return this.entries.isEmpty();
    }

    void checkEmpty(Path path) throws IOException {
        if (!this.isEmpty()) {
            throw new DirectoryNotEmptyException(path.toString());
        }
    }

    void addEntry(String name, MemoryEntry entry) throws IOException {
        MemoryEntry previous = this.entries.put(name, entry);
        if (previous != null) {
            this.entries.put(name, previous);
            throw new FileAlreadyExistsException("entry " + name + " already exists");
        }
        this.modified();
    }

    public String toString() {
        return "directory(" + this.getOriginalName() + ')';
    }

    void removeEntry(String name) throws AccessDeniedException {
        this.entries.remove(name);
        this.modified();
    }

    static final class MemoryDirectoryFileAttributes
    extends MemoryEntry.MemoryEntryFileAttributes {
        MemoryDirectoryFileAttributes(Object fileKey, FileTime lastModifiedTime, FileTime lastAccessTime, FileTime creationTime) {
            super(fileKey, lastModifiedTime, lastAccessTime, creationTime);
        }

        @Override
        public boolean isRegularFile() {
            return false;
        }

        @Override
        public boolean isDirectory() {
            return true;
        }

        @Override
        public boolean isSymbolicLink() {
            return false;
        }

        @Override
        public boolean isOther() {
            return false;
        }

        @Override
        public long size() {
            return -1L;
        }
    }

    class MemoryDirectoryFileAttributesView
    extends MemoryEntry.MemoryEntryFileAttributesView {
        MemoryDirectoryFileAttributesView() {
            super(MemoryDirectory.this);
        }

        @Override
        public BasicFileAttributes readAttributes() throws IOException {
            MemoryDirectory.this.checkAccess(AccessMode.READ);
            try (AutoRelease lock = MemoryDirectory.this.readLock();){
                FileTime creationTime = MemoryDirectory.this.creationTime();
                FileTime lastModifiedTime = MemoryDirectory.this.lastModifiedTime();
                FileTime lastAccessTime = MemoryDirectory.this.lastAccessTime();
                MemoryDirectoryFileAttributes memoryDirectoryFileAttributes = new MemoryDirectoryFileAttributes(MemoryDirectory.this, lastModifiedTime, lastAccessTime, creationTime);
                return memoryDirectoryFileAttributes;
            }
        }
    }
}

