/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.memoryfilesystem;

import com.github.marschall.memoryfilesystem.AbstractPath;
import com.github.marschall.memoryfilesystem.MemoryFileSystem;
import com.github.marschall.memoryfilesystem.PathParser;
import com.github.marschall.memoryfilesystem.Root;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

final class SingleEmptyRootPathParser
extends PathParser {
    SingleEmptyRootPathParser(String separator) {
        super(separator);
    }

    @Override
    public AbstractPath parse(Map<String, Root> roots, String first, String ... more) {
        ArrayList<String> elements = new ArrayList<String>(SingleEmptyRootPathParser.count(first, more));
        this.parseInto(first, elements);
        if (more != null && more.length > 0) {
            for (String s : more) {
                this.parseInto(s, elements);
            }
        }
        Root root = roots.values().iterator().next();
        MemoryFileSystem memoryFileSystem = root.getMemoryFileSystem();
        if (this.startWithSeparator(first, more)) {
            return AbstractPath.createAboslute(memoryFileSystem, root, elements);
        }
        return AbstractPath.createRelative(memoryFileSystem, elements);
    }

    static int count(String first, String ... more) {
        int count = SingleEmptyRootPathParser.count(first);
        if (more != null && more.length > 0) {
            for (String s : more) {
                count += SingleEmptyRootPathParser.count(s);
            }
        }
        return count;
    }

    static int count(String s) {
        if (s.isEmpty()) {
            return 0;
        }
        int count = 0;
        int fromIndex = 0;
        int slashIndex = s.indexOf(47, fromIndex);
        while (slashIndex != -1) {
            if (slashIndex > fromIndex) {
                ++count;
            }
            fromIndex = slashIndex + 1;
            slashIndex = s.indexOf(47, fromIndex);
        }
        if (fromIndex < s.length()) {
            ++count;
        }
        return count;
    }

    private void parseInto(String s, List<String> elements) {
        if (s.isEmpty()) {
            return;
        }
        int fromIndex = 0;
        int slashIndex = s.indexOf(47, fromIndex);
        while (slashIndex != -1) {
            if (slashIndex > fromIndex) {
                elements.add(s.substring(fromIndex, slashIndex));
            }
            fromIndex = slashIndex + 1;
            slashIndex = s.indexOf(47, fromIndex);
        }
        if (fromIndex < s.length()) {
            elements.add(s.substring(fromIndex));
        }
    }
}

