/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.memoryfilesystem;

import com.github.marschall.memoryfilesystem.MemoryFileSystemProvider;
import com.github.marschall.memoryfilesystem.UninstallationFailedException;
import java.lang.reflect.Field;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import java.util.List;

public final class MemoryFileSystemUninstaller {
    private MemoryFileSystemUninstaller() {
        throw new AssertionError((Object)"not instantiable");
    }

    public static boolean isInstalled() {
        ClassLoader ownClassLoader = MemoryFileSystemUninstaller.getOwnClassLoader();
        for (FileSystemProvider provider : FileSystemProvider.installedProviders()) {
            if (provider.getClass().getClassLoader() != ownClassLoader) continue;
            return true;
        }
        return false;
    }

    private static ClassLoader getOwnClassLoader() {
        return MemoryFileSystemUninstaller.class.getClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void uninstall(MemoryFileSystemProvider provider) {
        provider.close();
        Class<FileSystemProvider> providerClass = FileSystemProvider.class;
        try {
            Field installedProvidersField = providerClass.getDeclaredField("installedProviders");
            installedProvidersField.setAccessible(true);
            Field lockField = providerClass.getDeclaredField("lock");
            lockField.setAccessible(true);
            Object object = lockField.get(null);
            synchronized (object) {
                Object unmodifiableInstalledProviders = installedProvidersField.get(null);
                Field modifiableInstalledProvidersField = unmodifiableInstalledProviders.getClass().getSuperclass().getDeclaredField("list");
                modifiableInstalledProvidersField.setAccessible(true);
                List modifiableInstalledProviders = (List)modifiableInstalledProvidersField.get(unmodifiableInstalledProviders);
                modifiableInstalledProviders.remove(provider);
            }
        }
        catch (ReflectiveOperationException e) {
            throw new UninstallationFailedException("uninstallation failed", e);
        }
    }

    public static boolean uninstall() {
        ClassLoader ownClassLoader = MemoryFileSystemUninstaller.getOwnClassLoader();
        ArrayList<MemoryFileSystemProvider> toUninstall = new ArrayList<MemoryFileSystemProvider>(1);
        for (FileSystemProvider fileSystemProvider : FileSystemProvider.installedProviders()) {
            if (fileSystemProvider.getClass().getClassLoader() != ownClassLoader || !(fileSystemProvider instanceof MemoryFileSystemProvider)) continue;
            toUninstall.add((MemoryFileSystemProvider)fileSystemProvider);
        }
        for (MemoryFileSystemProvider memoryFileSystemProvider : toUninstall) {
            MemoryFileSystemUninstaller.uninstall(memoryFileSystemProvider);
        }
        return !toUninstall.isEmpty();
    }
}

