/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.portlet.server.result;

import java.util.HashMap;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.springframework.mock.web.portlet.MockActionResponse;
import org.springframework.test.web.AssertionErrors;
import org.springframework.test.web.portlet.server.PortletMvcResult;
import org.springframework.test.web.portlet.server.PortletResultMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderParametersResultMatchers {
    protected RenderParametersResultMatchers() {
    }

    public PortletResultMatcher has(final String name, final Matcher<String> matcher) {
        return new PortletResultMatcher(){

            public void match(PortletMvcResult result) throws Exception {
                MatcherAssert.assertThat((String)("Render parameter '" + name + "'"), (Object)RenderParametersResultMatchers.this.getActionResponse(result).getRenderParameter(name), (Matcher)matcher);
            }
        };
    }

    public PortletResultMatcher has(String name, String value) {
        return this.has(name, (Matcher<String>)Matchers.equalTo((Object)value));
    }

    public PortletResultMatcher exists(final String ... names) {
        return new PortletResultMatcher(){

            public void match(PortletMvcResult result) throws Exception {
                MockActionResponse mockActionResponse = RenderParametersResultMatchers.this.getActionResponse(result);
                for (String name : names) {
                    MatcherAssert.assertThat((String)("Render parameter '" + name + "'"), mockActionResponse.getRenderParameterMap().keySet(), (Matcher)Matchers.hasItem((Object)name));
                }
            }
        };
    }

    public PortletResultMatcher doesNotExist(final String ... names) {
        return new PortletResultMatcher(){

            public void match(PortletMvcResult portletMvcResult) throws Exception {
                MockActionResponse mockActionResponse = RenderParametersResultMatchers.this.getActionResponse(portletMvcResult);
                for (String name : names) {
                    MatcherAssert.assertThat((String)("Unexpected render parameter '" + name + "'"), mockActionResponse.getRenderParameterMap().keySet(), (Matcher)Matchers.not((Matcher)Matchers.hasItem((Object)name)));
                }
            }
        };
    }

    public PortletResultMatcher count(final int count) {
        return new PortletResultMatcher(){

            public void match(PortletMvcResult result) throws Exception {
                HashMap domainParameters = new HashMap(RenderParametersResultMatchers.this.getActionResponse(result).getRenderParameterMap());
                domainParameters.remove("implicitModel");
                AssertionErrors.assertEquals("Render parameter count", count, domainParameters.size());
            }
        };
    }

    private MockActionResponse getActionResponse(PortletMvcResult result) {
        AssertionErrors.assertTrue("The portlet response contained in the result is not instance of MockActionResponse", result.getResponse() instanceof MockActionResponse);
        return (MockActionResponse)result.getResponse();
    }
}

