/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.portlet.server.result;

import java.util.Map;
import javax.portlet.PortletSession;
import javax.portlet.StateAwareResponse;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.springframework.test.web.AssertionErrors;
import org.springframework.test.web.portlet.server.PortletMvcResult;
import org.springframework.test.web.portlet.server.PortletResultMatcher;
import org.springframework.ui.ExtendedModelMap;
import org.springframework.validation.BindingResult;
import org.springframework.validation.BindingResultUtils;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.mvc.annotation.AnnotationMethodHandlerAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelResultMatchers {
    protected ModelResultMatchers() {
    }

    public <T> PortletResultMatcher attribute(final String name, final Matcher<T> matcher) {
        return new PortletResultMatcher(){

            public void match(PortletMvcResult result) throws Exception {
                Map model = ModelResultMatchers.this.getModel(result);
                MatcherAssert.assertThat((String)("Model attribute '" + name + "'"), model.get(name), (Matcher)matcher);
            }
        };
    }

    public PortletResultMatcher attribute(String name, Object value) {
        return this.attribute(name, Matchers.equalTo((Object)value));
    }

    public PortletResultMatcher attributeDoesNotExist(final String ... names) {
        return new PortletResultMatcher(){

            public void match(PortletMvcResult portletMvcResult) throws Exception {
                Map model = ModelResultMatchers.this.getModel(portletMvcResult);
                for (String name : names) {
                    AssertionErrors.assertTrue("Did not expect the attribute: " + name, null == model.get(name));
                }
            }
        };
    }

    public PortletResultMatcher attributeExists(final String ... names) {
        return new PortletResultMatcher(){

            public void match(PortletMvcResult result) throws Exception {
                for (String name : names) {
                    ModelResultMatchers.this.attribute(name, Matchers.notNullValue()).match(result);
                }
            }
        };
    }

    public PortletResultMatcher attributeHasErrors(final String ... names) {
        return new PortletResultMatcher(){

            public void match(PortletMvcResult portletMvcResult) throws Exception {
                Map model = ModelResultMatchers.this.getModel(portletMvcResult);
                for (String name : names) {
                    BindingResult result = BindingResultUtils.getRequiredBindingResult((Map)model, (String)name);
                    AssertionErrors.assertTrue("No errors for attribute: " + name, result.hasErrors());
                }
            }
        };
    }

    public PortletResultMatcher attributeHasNoErrors(final String ... names) {
        return new PortletResultMatcher(){

            public void match(PortletMvcResult PortletMvcResult2) throws Exception {
                Map model = ModelResultMatchers.this.getModel(PortletMvcResult2);
                for (String name : names) {
                    BindingResult result = BindingResultUtils.getRequiredBindingResult((Map)model, (String)name);
                    AssertionErrors.assertTrue("No errors for attribute: " + name, !result.hasErrors());
                }
            }
        };
    }

    public PortletResultMatcher attributeHasFieldErrors(final String name, final String ... fieldNames) {
        return new PortletResultMatcher(){

            public void match(PortletMvcResult PortletMvcResult2) throws Exception {
                Map model = ModelResultMatchers.this.getModel(PortletMvcResult2);
                BindingResult result = BindingResultUtils.getRequiredBindingResult((Map)model, (String)name);
                AssertionErrors.assertTrue("No errors for attribute: '" + name + "'", result.hasErrors());
                for (String fieldName : fieldNames) {
                    AssertionErrors.assertTrue("No errors for field: '" + fieldName + "' of attribute: " + name, result.hasFieldErrors(fieldName));
                }
            }
        };
    }

    public <T> PortletResultMatcher hasNoErrors() {
        return new PortletResultMatcher(){

            public void match(PortletMvcResult result) throws Exception {
                Map model = ModelResultMatchers.this.getModel(result);
                for (Object value : model.values()) {
                    if (!(value instanceof BindingResult)) continue;
                    AssertionErrors.assertTrue("Unexpected binding error(s): " + value, !((BindingResult)value).hasErrors());
                }
            }
        };
    }

    public <T> PortletResultMatcher size(final int size) {
        return new PortletResultMatcher(){

            public void match(PortletMvcResult result) throws Exception {
                Map model = ModelResultMatchers.this.getModel(result);
                int actual = 0;
                for (String key : model.keySet()) {
                    if (key.startsWith(BindingResult.MODEL_KEY_PREFIX)) continue;
                    ++actual;
                }
                AssertionErrors.assertEquals("Model size", size, actual);
            }
        };
    }

    private Map<String, Object> getModel(PortletMvcResult portletMvcResult) {
        ModelAndView mav = portletMvcResult.getModelAndView();
        Map model = null;
        if (mav != null) {
            model = mav.getModel();
        } else if (portletMvcResult.getResponse() instanceof StateAwareResponse) {
            ExtendedModelMap implicitModel;
            StateAwareResponse response = (StateAwareResponse)portletMvcResult.getResponse();
            AssertionErrors.assertTrue("No actionExceptions expected, but got: " + StringUtils.join((Object[])((Object[])response.getRenderParameterMap().get("actionException"))), !response.getRenderParameterMap().containsKey("actionException"));
            PortletSession session = portletMvcResult.getRequest().getPortletSession(false);
            if (session != null && (implicitModel = (ExtendedModelMap)session.getAttribute(AnnotationMethodHandlerAdapter.IMPLICIT_MODEL_SESSION_ATTRIBUTE)) != null) {
                model = implicitModel.asMap();
            }
        }
        AssertionErrors.assertTrue("No Model found", model != null);
        return model;
    }
}

