/*
 * Decompiled with CFR 0.152.
 */
package com.marchinram.rxgallery;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.marchinram.rxgallery.RxGalleryActivity;
import io.reactivex.Maybe;
import io.reactivex.MaybeEmitter;
import io.reactivex.MaybeOnSubscribe;
import io.reactivex.android.MainThreadDisposable;
import io.reactivex.annotations.NonNull;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Function;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class RxGallery {
    public static Maybe<List<Uri>> gallery(@android.support.annotation.NonNull Activity activity) {
        return RxGallery.gallery(activity, false);
    }

    public static Maybe<List<Uri>> gallery(@android.support.annotation.NonNull Activity activity, boolean multiSelectEnabled) {
        return RxGallery.gallery(activity, multiSelectEnabled, MimeType.IMAGE);
    }

    public static Maybe<List<Uri>> gallery(@android.support.annotation.NonNull Activity activity, boolean multiSelectEnabled, MimeType ... mimeTypes) {
        Request request = new Request.Builder().setSource(Source.GALLERY).setMultiSelectEnabled(multiSelectEnabled).setMimeTypes(mimeTypes).build();
        return RxGallery.request((Context)activity, request);
    }

    public static Maybe<Uri> photoCapture(@android.support.annotation.NonNull Activity activity) {
        return RxGallery.photoCapture(activity, null);
    }

    public static Maybe<Uri> photoCapture(@android.support.annotation.NonNull Activity activity, @Nullable Uri outputUri) {
        Request request = new Request.Builder().setSource(Source.PHOTO_CAPTURE).setOutputUri(outputUri).build();
        return RxGallery.request((Context)activity, request).map((Function)new Function<List<Uri>, Uri>(){

            public Uri apply(@NonNull List<Uri> uris) throws Exception {
                return uris.get(0);
            }
        });
    }

    public static Maybe<Uri> videoCapture(@android.support.annotation.NonNull Activity activity) {
        Request request = new Request.Builder().setSource(Source.VIDEO_CAPTURE).build();
        return RxGallery.request((Context)activity, request).map((Function)new Function<List<Uri>, Uri>(){

            public Uri apply(@NonNull List<Uri> uris) throws Exception {
                return uris.get(0);
            }
        });
    }

    public static Maybe<List<Uri>> request(final @android.support.annotation.NonNull Context context, final @android.support.annotation.NonNull Request request) {
        final Context appContext = context.getApplicationContext();
        return Maybe.create((MaybeOnSubscribe)new MaybeOnSubscribe<List<Uri>>(){

            public void subscribe(final @NonNull MaybeEmitter<List<Uri>> e) throws Exception {
                final BroadcastReceiver receiver = new BroadcastReceiver(){

                    public void onReceive(Context context, Intent intent) {
                        if (!e.isDisposed()) {
                            if (intent.hasExtra("extraErrorNoActivity")) {
                                e.onError((Throwable)new ActivityNotFoundException("No activity found to handle request"));
                            } else if (intent.hasExtra("extraErrorSecurity")) {
                                e.onError((Throwable)intent.getSerializableExtra("extraErrorSecurity"));
                            } else if (intent.hasExtra("extraUris")) {
                                ArrayList uris = intent.getParcelableArrayListExtra("extraUris");
                                if (uris != null && uris.size() > 0) {
                                    e.onSuccess((Object)uris);
                                } else {
                                    e.onComplete();
                                }
                            }
                        }
                    }
                };
                IntentFilter intentFilter = new IntentFilter("com.marchinram.rxgallery.FINISHED_ACTION");
                appContext.registerReceiver(receiver, intentFilter);
                e.setDisposable((Disposable)new MainThreadDisposable(){

                    protected void onDispose() {
                        appContext.unregisterReceiver(receiver);
                        appContext.sendBroadcast(new Intent("com.marchinram.rxgallery.DISPOSED_ACTION"));
                    }
                });
                Intent intent = new Intent(appContext, RxGalleryActivity.class);
                intent.putExtra("extraRequest", (Parcelable)request);
                context.startActivity(intent);
            }
        });
    }

    public static final class Request
    implements Parcelable {
        private final Source source;
        private final List<MimeType> mimeTypes;
        private final boolean multiSelectEnabled;
        private final Uri outputUri;
        public static final Parcelable.Creator<Request> CREATOR = new Parcelable.Creator<Request>(){

            public Request createFromParcel(Parcel in) {
                return new Request(in);
            }

            public Request[] newArray(int size) {
                return new Request[size];
            }
        };

        private Request(Source source, List<MimeType> mimeTypes, boolean multiSelectEnabled, Uri outputUri) {
            this.source = source;
            this.mimeTypes = mimeTypes;
            this.multiSelectEnabled = multiSelectEnabled;
            this.outputUri = outputUri;
        }

        private Request(Parcel in) {
            this.source = Source.values()[in.readInt()];
            this.mimeTypes = new ArrayList<MimeType>();
            int mimeTypesSize = in.readInt();
            for (int i = 0; i < mimeTypesSize; ++i) {
                this.mimeTypes.add(MimeType.values()[in.readInt()]);
            }
            this.multiSelectEnabled = in.readInt() == 1;
            String uriString = in.readString();
            this.outputUri = uriString != null ? Uri.parse((String)uriString) : null;
        }

        Source getSource() {
            return this.source;
        }

        List<MimeType> getMimeTypes() {
            return this.mimeTypes;
        }

        boolean isMultiSelectEnabled() {
            return this.multiSelectEnabled;
        }

        Uri getOutputUri() {
            return this.outputUri;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.source.ordinal());
            dest.writeInt(this.mimeTypes.size());
            for (MimeType mimeType : this.mimeTypes) {
                dest.writeInt(mimeType.ordinal());
            }
            dest.writeInt(this.multiSelectEnabled ? 1 : 0);
            dest.writeString(this.outputUri != null ? this.outputUri.toString() : null);
        }

        public int describeContents() {
            return 0;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Request) {
                Request that = (Request)o;
                return this.getSource().equals((Object)that.getSource()) && this.getMimeTypes().equals(that.getMimeTypes()) && this.isMultiSelectEnabled() == that.isMultiSelectEnabled() && (this.getOutputUri() == null ? that.getOutputUri() == null : this.getOutputUri().equals((Object)that.getOutputUri()));
            }
            return false;
        }

        public int hashCode() {
            int h = 1;
            h *= 1000003;
            h ^= this.getSource().hashCode();
            h *= 1000003;
            h ^= this.getMimeTypes().hashCode();
            h *= 1000003;
            h ^= this.isMultiSelectEnabled() ? 1 : 0;
            h *= 1000003;
            return h ^= this.getOutputUri() == null ? 0 : this.getOutputUri().hashCode();
        }

        public static final class Builder {
            private Source source = Source.GALLERY;
            private List<MimeType> mimeTypes = new ArrayList<MimeType>();
            private boolean multiSelectEnabled;
            private Uri outputUri;

            public Builder() {
                this.mimeTypes.add(MimeType.IMAGE);
            }

            public Builder setSource(@android.support.annotation.NonNull Source source) {
                this.source = source;
                return this;
            }

            public Builder setMimeTypes(MimeType ... mimeTypes) {
                if (mimeTypes == null || mimeTypes.length == 0) {
                    return this;
                }
                if (Build.VERSION.SDK_INT >= 19) {
                    this.mimeTypes = new ArrayList<MimeType>();
                    for (MimeType mimeType : mimeTypes) {
                        if (this.mimeTypes.contains((Object)mimeType)) continue;
                        this.mimeTypes.add(mimeType);
                    }
                } else {
                    this.mimeTypes = Collections.singletonList(mimeTypes[0]);
                }
                return this;
            }

            public Builder setMultiSelectEnabled(boolean multiSelectEnabled) {
                this.multiSelectEnabled = multiSelectEnabled;
                return this;
            }

            public Builder setOutputUri(Uri outputUri) {
                this.outputUri = outputUri;
                return this;
            }

            public Request build() {
                return new Request(this.source, this.mimeTypes, this.multiSelectEnabled, this.outputUri);
            }
        }
    }

    public static enum MimeType {
        IMAGE("image/*"),
        VIDEO("video/*"),
        AUDIO("audio/*");

        private final String mimeTypeString;

        private MimeType(String mimeTypeString) {
            this.mimeTypeString = mimeTypeString;
        }

        public String toString() {
            return this.mimeTypeString;
        }
    }

    public static enum Source {
        GALLERY,
        PHOTO_CAPTURE,
        VIDEO_CAPTURE;

    }
}

