/*
 * Decompiled with CFR 0.152.
 */
package com.github.barteksc.pdfviewer;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.DrawFilter;
import android.graphics.Paint;
import android.graphics.PaintFlagsDrawFilter;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.HandlerThread;
import android.util.AttributeSet;
import android.util.Log;
import android.widget.RelativeLayout;
import com.github.barteksc.pdfviewer.AnimationManager;
import com.github.barteksc.pdfviewer.CacheManager;
import com.github.barteksc.pdfviewer.DecodingAsyncTask;
import com.github.barteksc.pdfviewer.DragPinchManager;
import com.github.barteksc.pdfviewer.PagesLoader;
import com.github.barteksc.pdfviewer.PdfFile;
import com.github.barteksc.pdfviewer.RenderingHandler;
import com.github.barteksc.pdfviewer.exception.PageRenderingException;
import com.github.barteksc.pdfviewer.link.DefaultLinkHandler;
import com.github.barteksc.pdfviewer.link.LinkHandler;
import com.github.barteksc.pdfviewer.listener.Callbacks;
import com.github.barteksc.pdfviewer.listener.OnDrawListener;
import com.github.barteksc.pdfviewer.listener.OnErrorListener;
import com.github.barteksc.pdfviewer.listener.OnLoadCompleteListener;
import com.github.barteksc.pdfviewer.listener.OnLongPressListener;
import com.github.barteksc.pdfviewer.listener.OnPageChangeListener;
import com.github.barteksc.pdfviewer.listener.OnPageErrorListener;
import com.github.barteksc.pdfviewer.listener.OnPageScrollListener;
import com.github.barteksc.pdfviewer.listener.OnRenderListener;
import com.github.barteksc.pdfviewer.listener.OnTapListener;
import com.github.barteksc.pdfviewer.model.PagePart;
import com.github.barteksc.pdfviewer.scroll.ScrollHandle;
import com.github.barteksc.pdfviewer.source.AssetSource;
import com.github.barteksc.pdfviewer.source.ByteArraySource;
import com.github.barteksc.pdfviewer.source.DocumentSource;
import com.github.barteksc.pdfviewer.source.FileSource;
import com.github.barteksc.pdfviewer.source.InputStreamSource;
import com.github.barteksc.pdfviewer.source.UriSource;
import com.github.barteksc.pdfviewer.util.Constants;
import com.github.barteksc.pdfviewer.util.FitPolicy;
import com.github.barteksc.pdfviewer.util.MathUtils;
import com.github.barteksc.pdfviewer.util.SnapEdge;
import com.github.barteksc.pdfviewer.util.Util;
import com.shockwave.pdfium.PdfDocument;
import com.shockwave.pdfium.PdfiumCore;
import com.shockwave.pdfium.util.Size;
import com.shockwave.pdfium.util.SizeF;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PDFView
extends RelativeLayout {
    private static final String TAG = PDFView.class.getSimpleName();
    public static final float DEFAULT_MAX_SCALE = 3.0f;
    public static final float DEFAULT_MID_SCALE = 1.75f;
    public static final float DEFAULT_MIN_SCALE = 1.0f;
    private float minZoom = 1.0f;
    private float midZoom = 1.75f;
    private float maxZoom = 3.0f;
    private ScrollDir scrollDir = ScrollDir.NONE;
    CacheManager cacheManager;
    private AnimationManager animationManager;
    private DragPinchManager dragPinchManager;
    PdfFile pdfFile;
    private int currentPage;
    private float currentXOffset = 0.0f;
    private float currentYOffset = 0.0f;
    private float zoom = 1.0f;
    private boolean recycled = true;
    private State state = State.DEFAULT;
    private DecodingAsyncTask decodingAsyncTask;
    private HandlerThread renderingHandlerThread;
    RenderingHandler renderingHandler;
    private PagesLoader pagesLoader;
    Callbacks callbacks = new Callbacks();
    private Paint paint;
    private Paint debugPaint;
    private FitPolicy pageFitPolicy = FitPolicy.WIDTH;
    private boolean fitEachPage = false;
    private int defaultPage = 0;
    private boolean swipeVertical = true;
    private boolean enableSwipe = true;
    private boolean doubletapEnabled = true;
    private boolean nightMode = false;
    private boolean pageSnap = true;
    private PdfiumCore pdfiumCore;
    private ScrollHandle scrollHandle;
    private boolean isScrollHandleInit = false;
    private boolean bestQuality = false;
    private boolean annotationRendering = false;
    private boolean renderDuringScale = false;
    private boolean enableAntialiasing = true;
    private PaintFlagsDrawFilter antialiasFilter = new PaintFlagsDrawFilter(0, 3);
    private int spacingPx = 0;
    private boolean autoSpacing = false;
    private boolean pageFling = true;
    private List<Integer> onDrawPagesNums = new ArrayList<Integer>(10);
    private boolean hasSize = false;
    private Configurator waitingDocumentConfigurator;

    ScrollHandle getScrollHandle() {
        return this.scrollHandle;
    }

    public PDFView(Context context, AttributeSet set) {
        super(context, set);
        this.renderingHandlerThread = new HandlerThread("PDF renderer");
        if (this.isInEditMode()) {
            return;
        }
        this.cacheManager = new CacheManager();
        this.animationManager = new AnimationManager(this);
        this.dragPinchManager = new DragPinchManager(this, this.animationManager);
        this.pagesLoader = new PagesLoader(this);
        this.paint = new Paint();
        this.debugPaint = new Paint();
        this.debugPaint.setStyle(Paint.Style.STROKE);
        this.pdfiumCore = new PdfiumCore(context);
        this.setWillNotDraw(false);
    }

    private void load(DocumentSource docSource, String password) {
        this.load(docSource, password, null);
    }

    private void load(DocumentSource docSource, String password, int[] userPages) {
        if (!this.recycled) {
            throw new IllegalStateException("Don't call load on a PDF View without recycling it first.");
        }
        this.recycled = false;
        this.decodingAsyncTask = new DecodingAsyncTask(docSource, password, userPages, this, this.pdfiumCore);
        this.decodingAsyncTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
    }

    public void jumpTo(int page, boolean withAnimation) {
        float offset;
        if (this.pdfFile == null) {
            return;
        }
        float f = offset = (page = this.pdfFile.determineValidPageNumberFrom(page)) == 0 ? 0.0f : -this.pdfFile.getPageOffset(page, this.zoom);
        if (this.swipeVertical) {
            if (withAnimation) {
                this.animationManager.startYAnimation(this.currentYOffset, offset);
            } else {
                this.moveTo(this.currentXOffset, offset);
            }
        } else if (withAnimation) {
            this.animationManager.startXAnimation(this.currentXOffset, offset);
        } else {
            this.moveTo(offset, this.currentYOffset);
        }
        this.showPage(page);
    }

    public void jumpTo(int page) {
        this.jumpTo(page, false);
    }

    void showPage(int pageNb) {
        if (this.recycled) {
            return;
        }
        this.currentPage = pageNb = this.pdfFile.determineValidPageNumberFrom(pageNb);
        this.loadPages();
        if (this.scrollHandle != null && !this.documentFitsView()) {
            this.scrollHandle.setPageNum(this.currentPage + 1);
        }
        this.callbacks.callOnPageChange(this.currentPage, this.pdfFile.getPagesCount());
    }

    public float getPositionOffset() {
        float offset = this.swipeVertical ? -this.currentYOffset / (this.pdfFile.getDocLen(this.zoom) - (float)this.getHeight()) : -this.currentXOffset / (this.pdfFile.getDocLen(this.zoom) - (float)this.getWidth());
        return MathUtils.limit(offset, 0.0f, 1.0f);
    }

    public void setPositionOffset(float progress, boolean moveHandle) {
        if (this.swipeVertical) {
            this.moveTo(this.currentXOffset, (-this.pdfFile.getDocLen(this.zoom) + (float)this.getHeight()) * progress, moveHandle);
        } else {
            this.moveTo((-this.pdfFile.getDocLen(this.zoom) + (float)this.getWidth()) * progress, this.currentYOffset, moveHandle);
        }
        this.loadPageByOffset();
    }

    public void setPositionOffset(float progress) {
        this.setPositionOffset(progress, true);
    }

    public void stopFling() {
        this.animationManager.stopFling();
    }

    public int getPageCount() {
        if (this.pdfFile == null) {
            return 0;
        }
        return this.pdfFile.getPagesCount();
    }

    public void setSwipeEnabled(boolean enableSwipe) {
        this.enableSwipe = enableSwipe;
    }

    public void setNightMode(boolean nightMode) {
        this.nightMode = nightMode;
        if (nightMode) {
            ColorMatrix colorMatrixInverted = new ColorMatrix(new float[]{-1.0f, 0.0f, 0.0f, 0.0f, 255.0f, 0.0f, -1.0f, 0.0f, 0.0f, 255.0f, 0.0f, 0.0f, -1.0f, 0.0f, 255.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f});
            ColorMatrixColorFilter filter = new ColorMatrixColorFilter(colorMatrixInverted);
            this.paint.setColorFilter((ColorFilter)filter);
        } else {
            this.paint.setColorFilter(null);
        }
    }

    void enableDoubletap(boolean enableDoubletap) {
        this.doubletapEnabled = enableDoubletap;
    }

    boolean isDoubletapEnabled() {
        return this.doubletapEnabled;
    }

    void onPageError(PageRenderingException ex) {
        if (!this.callbacks.callOnPageError(ex.getPage(), ex.getCause())) {
            Log.e((String)TAG, (String)("Cannot open page " + ex.getPage()), (Throwable)ex.getCause());
        }
    }

    public void recycle() {
        this.waitingDocumentConfigurator = null;
        this.animationManager.stopAll();
        this.dragPinchManager.disable();
        if (this.renderingHandler != null) {
            this.renderingHandler.stop();
            this.renderingHandler.removeMessages(1);
        }
        if (this.decodingAsyncTask != null) {
            this.decodingAsyncTask.cancel(true);
        }
        this.cacheManager.recycle();
        if (this.scrollHandle != null && this.isScrollHandleInit) {
            this.scrollHandle.destroyLayout();
        }
        if (this.pdfFile != null) {
            this.pdfFile.dispose();
            this.pdfFile = null;
        }
        this.renderingHandler = null;
        this.scrollHandle = null;
        this.isScrollHandleInit = false;
        this.currentYOffset = 0.0f;
        this.currentXOffset = 0.0f;
        this.zoom = 1.0f;
        this.recycled = true;
        this.callbacks = new Callbacks();
        this.state = State.DEFAULT;
    }

    public boolean isRecycled() {
        return this.recycled;
    }

    public void computeScroll() {
        super.computeScroll();
        if (this.isInEditMode()) {
            return;
        }
        this.animationManager.computeFling();
    }

    protected void onDetachedFromWindow() {
        this.recycle();
        if (this.renderingHandlerThread != null) {
            if (Build.VERSION.SDK_INT >= 18) {
                this.renderingHandlerThread.quitSafely();
            } else {
                this.renderingHandlerThread.quit();
            }
            this.renderingHandlerThread = null;
        }
        super.onDetachedFromWindow();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        float relativeCenterPointInStripYOffset;
        float relativeCenterPointInStripXOffset;
        this.hasSize = true;
        if (this.waitingDocumentConfigurator != null) {
            this.waitingDocumentConfigurator.load();
        }
        if (this.isInEditMode() || this.state != State.SHOWN) {
            return;
        }
        float centerPointInStripXOffset = -this.currentXOffset + (float)oldw * 0.5f;
        float centerPointInStripYOffset = -this.currentYOffset + (float)oldh * 0.5f;
        if (this.swipeVertical) {
            relativeCenterPointInStripXOffset = centerPointInStripXOffset / this.pdfFile.getMaxPageWidth();
            relativeCenterPointInStripYOffset = centerPointInStripYOffset / this.pdfFile.getDocLen(this.zoom);
        } else {
            relativeCenterPointInStripXOffset = centerPointInStripXOffset / this.pdfFile.getDocLen(this.zoom);
            relativeCenterPointInStripYOffset = centerPointInStripYOffset / this.pdfFile.getMaxPageHeight();
        }
        this.animationManager.stopAll();
        this.pdfFile.recalculatePageSizes(new Size(w, h));
        if (this.swipeVertical) {
            this.currentXOffset = -relativeCenterPointInStripXOffset * this.pdfFile.getMaxPageWidth() + (float)w * 0.5f;
            this.currentYOffset = -relativeCenterPointInStripYOffset * this.pdfFile.getDocLen(this.zoom) + (float)h * 0.5f;
        } else {
            this.currentXOffset = -relativeCenterPointInStripXOffset * this.pdfFile.getDocLen(this.zoom) + (float)w * 0.5f;
            this.currentYOffset = -relativeCenterPointInStripYOffset * this.pdfFile.getMaxPageHeight() + (float)h * 0.5f;
        }
        this.moveTo(this.currentXOffset, this.currentYOffset);
        this.loadPageByOffset();
    }

    public boolean canScrollHorizontally(int direction) {
        if (this.pdfFile == null) {
            return true;
        }
        if (this.swipeVertical) {
            if (direction < 0 && this.currentXOffset < 0.0f) {
                return true;
            }
            if (direction > 0 && this.currentXOffset + this.toCurrentScale(this.pdfFile.getMaxPageWidth()) > (float)this.getWidth()) {
                return true;
            }
        } else {
            if (direction < 0 && this.currentXOffset < 0.0f) {
                return true;
            }
            if (direction > 0 && this.currentXOffset + this.pdfFile.getDocLen(this.zoom) > (float)this.getWidth()) {
                return true;
            }
        }
        return false;
    }

    public boolean canScrollVertically(int direction) {
        if (this.pdfFile == null) {
            return true;
        }
        if (this.swipeVertical) {
            if (direction < 0 && this.currentYOffset < 0.0f) {
                return true;
            }
            if (direction > 0 && this.currentYOffset + this.pdfFile.getDocLen(this.zoom) > (float)this.getHeight()) {
                return true;
            }
        } else {
            if (direction < 0 && this.currentYOffset < 0.0f) {
                return true;
            }
            if (direction > 0 && this.currentYOffset + this.toCurrentScale(this.pdfFile.getMaxPageHeight()) > (float)this.getHeight()) {
                return true;
            }
        }
        return false;
    }

    protected void onDraw(Canvas canvas) {
        Drawable bg;
        if (this.isInEditMode()) {
            return;
        }
        if (this.enableAntialiasing) {
            canvas.setDrawFilter((DrawFilter)this.antialiasFilter);
        }
        if ((bg = this.getBackground()) == null) {
            canvas.drawColor(this.nightMode ? -16777216 : -1);
        } else {
            bg.draw(canvas);
        }
        if (this.recycled) {
            return;
        }
        if (this.state != State.SHOWN) {
            return;
        }
        float currentXOffset = this.currentXOffset;
        float currentYOffset = this.currentYOffset;
        canvas.translate(currentXOffset, currentYOffset);
        for (PagePart part : this.cacheManager.getThumbnails()) {
            this.drawPart(canvas, part);
        }
        for (PagePart part : this.cacheManager.getPageParts()) {
            this.drawPart(canvas, part);
            if (this.callbacks.getOnDrawAll() == null || this.onDrawPagesNums.contains(part.getPage())) continue;
            this.onDrawPagesNums.add(part.getPage());
        }
        for (Integer page : this.onDrawPagesNums) {
            this.drawWithListener(canvas, page, this.callbacks.getOnDrawAll());
        }
        this.onDrawPagesNums.clear();
        this.drawWithListener(canvas, this.currentPage, this.callbacks.getOnDraw());
        canvas.translate(-currentXOffset, -currentYOffset);
    }

    private void drawWithListener(Canvas canvas, int page, OnDrawListener listener) {
        if (listener != null) {
            float translateY;
            float translateX;
            if (this.swipeVertical) {
                translateX = 0.0f;
                translateY = this.pdfFile.getPageOffset(page, this.zoom);
            } else {
                translateY = 0.0f;
                translateX = this.pdfFile.getPageOffset(page, this.zoom);
            }
            canvas.translate(translateX, translateY);
            SizeF size = this.pdfFile.getPageSize(page);
            listener.onLayerDrawn(canvas, this.toCurrentScale(size.getWidth()), this.toCurrentScale(size.getHeight()), page);
            canvas.translate(-translateX, -translateY);
        }
    }

    private void drawPart(Canvas canvas, PagePart part) {
        RectF pageRelativeBounds = part.getPageRelativeBounds();
        Bitmap renderedBitmap = part.getRenderedBitmap();
        if (renderedBitmap.isRecycled()) {
            return;
        }
        float localTranslationX = 0.0f;
        float localTranslationY = 0.0f;
        SizeF size = this.pdfFile.getPageSize(part.getPage());
        if (this.swipeVertical) {
            localTranslationY = this.pdfFile.getPageOffset(part.getPage(), this.zoom);
            float maxWidth = this.pdfFile.getMaxPageWidth();
            localTranslationX = this.toCurrentScale(maxWidth - size.getWidth()) / 2.0f;
        } else {
            localTranslationX = this.pdfFile.getPageOffset(part.getPage(), this.zoom);
            float maxHeight = this.pdfFile.getMaxPageHeight();
            localTranslationY = this.toCurrentScale(maxHeight - size.getHeight()) / 2.0f;
        }
        canvas.translate(localTranslationX, localTranslationY);
        Rect srcRect = new Rect(0, 0, renderedBitmap.getWidth(), renderedBitmap.getHeight());
        float offsetX = this.toCurrentScale(pageRelativeBounds.left * size.getWidth());
        float offsetY = this.toCurrentScale(pageRelativeBounds.top * size.getHeight());
        float width = this.toCurrentScale(pageRelativeBounds.width() * size.getWidth());
        float height = this.toCurrentScale(pageRelativeBounds.height() * size.getHeight());
        RectF dstRect = new RectF((float)((int)offsetX), (float)((int)offsetY), (float)((int)(offsetX + width)), (float)((int)(offsetY + height)));
        float translationX = this.currentXOffset + localTranslationX;
        float translationY = this.currentYOffset + localTranslationY;
        if (translationX + dstRect.left >= (float)this.getWidth() || translationX + dstRect.right <= 0.0f || translationY + dstRect.top >= (float)this.getHeight() || translationY + dstRect.bottom <= 0.0f) {
            canvas.translate(-localTranslationX, -localTranslationY);
            return;
        }
        canvas.drawBitmap(renderedBitmap, srcRect, dstRect, this.paint);
        if (Constants.DEBUG_MODE) {
            this.debugPaint.setColor(part.getPage() % 2 == 0 ? -65536 : -16776961);
            canvas.drawRect(dstRect, this.debugPaint);
        }
        canvas.translate(-localTranslationX, -localTranslationY);
    }

    public void loadPages() {
        if (this.pdfFile == null || this.renderingHandler == null) {
            return;
        }
        this.renderingHandler.removeMessages(1);
        this.cacheManager.makeANewSet();
        this.pagesLoader.loadPages();
        this.redraw();
    }

    void loadComplete(PdfFile pdfFile) {
        this.state = State.LOADED;
        this.pdfFile = pdfFile;
        if (!this.renderingHandlerThread.isAlive()) {
            this.renderingHandlerThread.start();
        }
        this.renderingHandler = new RenderingHandler(this.renderingHandlerThread.getLooper(), this);
        this.renderingHandler.start();
        if (this.scrollHandle != null) {
            this.scrollHandle.setupLayout(this);
            this.isScrollHandleInit = true;
        }
        this.dragPinchManager.enable();
        this.callbacks.callOnLoadComplete(pdfFile.getPagesCount());
        this.jumpTo(this.defaultPage, false);
    }

    void loadError(Throwable t) {
        this.state = State.ERROR;
        OnErrorListener onErrorListener = this.callbacks.getOnError();
        this.recycle();
        this.invalidate();
        if (onErrorListener != null) {
            onErrorListener.onError(t);
        } else {
            Log.e((String)"PDFView", (String)"load pdf error", (Throwable)t);
        }
    }

    void redraw() {
        this.invalidate();
    }

    public void onBitmapRendered(PagePart part) {
        if (this.state == State.LOADED) {
            this.state = State.SHOWN;
            this.callbacks.callOnRender(this.pdfFile.getPagesCount());
        }
        if (part.isThumbnail()) {
            this.cacheManager.cacheThumbnail(part);
        } else {
            this.cacheManager.cachePart(part);
        }
        this.redraw();
    }

    public void moveTo(float offsetX, float offsetY) {
        this.moveTo(offsetX, offsetY, true);
    }

    public void moveTo(float offsetX, float offsetY, boolean moveHandle) {
        if (this.swipeVertical) {
            float scaledPageWidth = this.toCurrentScale(this.pdfFile.getMaxPageWidth());
            if (scaledPageWidth < (float)this.getWidth()) {
                offsetX = (float)(this.getWidth() / 2) - scaledPageWidth / 2.0f;
            } else if (offsetX > 0.0f) {
                offsetX = 0.0f;
            } else if (offsetX + scaledPageWidth < (float)this.getWidth()) {
                offsetX = (float)this.getWidth() - scaledPageWidth;
            }
            float contentHeight = this.pdfFile.getDocLen(this.zoom);
            if (contentHeight < (float)this.getHeight()) {
                offsetY = ((float)this.getHeight() - contentHeight) / 2.0f;
            } else if (offsetY > 0.0f) {
                offsetY = 0.0f;
            } else if (offsetY + contentHeight < (float)this.getHeight()) {
                offsetY = -contentHeight + (float)this.getHeight();
            }
            this.scrollDir = offsetY < this.currentYOffset ? ScrollDir.END : (offsetY > this.currentYOffset ? ScrollDir.START : ScrollDir.NONE);
        } else {
            float scaledPageHeight = this.toCurrentScale(this.pdfFile.getMaxPageHeight());
            if (scaledPageHeight < (float)this.getHeight()) {
                offsetY = (float)(this.getHeight() / 2) - scaledPageHeight / 2.0f;
            } else if (offsetY > 0.0f) {
                offsetY = 0.0f;
            } else if (offsetY + scaledPageHeight < (float)this.getHeight()) {
                offsetY = (float)this.getHeight() - scaledPageHeight;
            }
            float contentWidth = this.pdfFile.getDocLen(this.zoom);
            if (contentWidth < (float)this.getWidth()) {
                offsetX = ((float)this.getWidth() - contentWidth) / 2.0f;
            } else if (offsetX > 0.0f) {
                offsetX = 0.0f;
            } else if (offsetX + contentWidth < (float)this.getWidth()) {
                offsetX = -contentWidth + (float)this.getWidth();
            }
            this.scrollDir = offsetX < this.currentXOffset ? ScrollDir.END : (offsetX > this.currentXOffset ? ScrollDir.START : ScrollDir.NONE);
        }
        this.currentXOffset = offsetX;
        this.currentYOffset = offsetY;
        float positionOffset = this.getPositionOffset();
        if (moveHandle && this.scrollHandle != null && !this.documentFitsView()) {
            this.scrollHandle.setScroll(positionOffset);
        }
        this.callbacks.callOnPageScroll(this.getCurrentPage(), positionOffset);
        this.redraw();
    }

    void loadPageByOffset() {
        float screenCenter;
        float offset;
        if (0 == this.pdfFile.getPagesCount()) {
            return;
        }
        if (this.swipeVertical) {
            offset = this.currentYOffset;
            screenCenter = (float)this.getHeight() / 2.0f;
        } else {
            offset = this.currentXOffset;
            screenCenter = (float)this.getWidth() / 2.0f;
        }
        int page = this.pdfFile.getPageAtOffset(-(offset - screenCenter), this.zoom);
        if (page >= 0 && page <= this.pdfFile.getPagesCount() - 1 && page != this.getCurrentPage()) {
            this.showPage(page);
        } else {
            this.loadPages();
        }
    }

    public void performPageSnap() {
        if (!this.pageSnap || this.pdfFile == null || this.pdfFile.getPagesCount() == 0) {
            return;
        }
        int centerPage = this.findFocusPage(this.currentXOffset, this.currentYOffset);
        SnapEdge edge = this.findSnapEdge(centerPage);
        if (edge == SnapEdge.NONE) {
            return;
        }
        float offset = this.snapOffsetForPage(centerPage, edge);
        if (this.swipeVertical) {
            this.animationManager.startYAnimation(this.currentYOffset, -offset);
        } else {
            this.animationManager.startXAnimation(this.currentXOffset, -offset);
        }
    }

    SnapEdge findSnapEdge(int page) {
        float pageLength;
        if (!this.pageSnap || page < 0) {
            return SnapEdge.NONE;
        }
        float currentOffset = this.swipeVertical ? this.currentYOffset : this.currentXOffset;
        float offset = -this.pdfFile.getPageOffset(page, this.zoom);
        int length = this.swipeVertical ? this.getHeight() : this.getWidth();
        if ((float)length >= (pageLength = this.pdfFile.getPageLength(page, this.zoom))) {
            return SnapEdge.CENTER;
        }
        if (currentOffset >= offset) {
            return SnapEdge.START;
        }
        if (offset - pageLength > currentOffset - (float)length) {
            return SnapEdge.END;
        }
        return SnapEdge.NONE;
    }

    float snapOffsetForPage(int pageIndex, SnapEdge edge) {
        float offset = this.pdfFile.getPageOffset(pageIndex, this.zoom);
        float length = this.swipeVertical ? (float)this.getHeight() : (float)this.getWidth();
        float pageLength = this.pdfFile.getPageLength(pageIndex, this.zoom);
        if (edge == SnapEdge.CENTER) {
            offset = offset - length / 2.0f + pageLength / 2.0f;
        } else if (edge == SnapEdge.END) {
            offset = offset - length + pageLength;
        }
        return offset;
    }

    int findFocusPage(float xOffset, float yOffset) {
        float length;
        float currOffset = this.swipeVertical ? yOffset : xOffset;
        float f = length = this.swipeVertical ? (float)this.getHeight() : (float)this.getWidth();
        if (currOffset > -1.0f) {
            return 0;
        }
        if (currOffset < -this.pdfFile.getDocLen(this.zoom) + length + 1.0f) {
            return this.pdfFile.getPagesCount() - 1;
        }
        float center = currOffset - length / 2.0f;
        return this.pdfFile.getPageAtOffset(-center, this.zoom);
    }

    public boolean pageFillsScreen() {
        float start = -this.pdfFile.getPageOffset(this.currentPage, this.zoom);
        float end = start - this.pdfFile.getPageLength(this.currentPage, this.zoom);
        if (this.isSwipeVertical()) {
            return start > this.currentYOffset && end < this.currentYOffset - (float)this.getHeight();
        }
        return start > this.currentXOffset && end < this.currentXOffset - (float)this.getWidth();
    }

    public void moveRelativeTo(float dx, float dy) {
        this.moveTo(this.currentXOffset + dx, this.currentYOffset + dy);
    }

    public void zoomTo(float zoom) {
        this.zoom = zoom;
    }

    public void zoomCenteredTo(float zoom, PointF pivot) {
        float dzoom = zoom / this.zoom;
        this.zoomTo(zoom);
        float baseX = this.currentXOffset * dzoom;
        float baseY = this.currentYOffset * dzoom;
        this.moveTo(baseX += pivot.x - pivot.x * dzoom, baseY += pivot.y - pivot.y * dzoom);
    }

    public void zoomCenteredRelativeTo(float dzoom, PointF pivot) {
        this.zoomCenteredTo(this.zoom * dzoom, pivot);
    }

    public boolean documentFitsView() {
        float len = this.pdfFile.getDocLen(1.0f);
        if (this.swipeVertical) {
            return len < (float)this.getHeight();
        }
        return len < (float)this.getWidth();
    }

    public void fitToWidth(int page) {
        if (this.state != State.SHOWN) {
            Log.e((String)TAG, (String)"Cannot fit, document not rendered yet");
            return;
        }
        this.zoomTo((float)this.getWidth() / this.pdfFile.getPageSize(page).getWidth());
        this.jumpTo(page);
    }

    public SizeF getPageSize(int pageIndex) {
        if (this.pdfFile == null) {
            return new SizeF(0.0f, 0.0f);
        }
        return this.pdfFile.getPageSize(pageIndex);
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public float getCurrentXOffset() {
        return this.currentXOffset;
    }

    public float getCurrentYOffset() {
        return this.currentYOffset;
    }

    public float toRealScale(float size) {
        return size / this.zoom;
    }

    public float toCurrentScale(float size) {
        return size * this.zoom;
    }

    public float getZoom() {
        return this.zoom;
    }

    public boolean isZooming() {
        return this.zoom != this.minZoom;
    }

    private void setDefaultPage(int defaultPage) {
        this.defaultPage = defaultPage;
    }

    public void resetZoom() {
        this.zoomTo(this.minZoom);
    }

    public void resetZoomWithAnimation() {
        this.zoomWithAnimation(this.minZoom);
    }

    public void zoomWithAnimation(float centerX, float centerY, float scale) {
        this.animationManager.startZoomAnimation(centerX, centerY, this.zoom, scale);
    }

    public void zoomWithAnimation(float scale) {
        this.animationManager.startZoomAnimation(this.getWidth() / 2, this.getHeight() / 2, this.zoom, scale);
    }

    private void setScrollHandle(ScrollHandle scrollHandle) {
        this.scrollHandle = scrollHandle;
    }

    public int getPageAtPositionOffset(float positionOffset) {
        return this.pdfFile.getPageAtOffset(this.pdfFile.getDocLen(this.zoom) * positionOffset, this.zoom);
    }

    public float getMinZoom() {
        return this.minZoom;
    }

    public void setMinZoom(float minZoom) {
        this.minZoom = minZoom;
    }

    public float getMidZoom() {
        return this.midZoom;
    }

    public void setMidZoom(float midZoom) {
        this.midZoom = midZoom;
    }

    public float getMaxZoom() {
        return this.maxZoom;
    }

    public void setMaxZoom(float maxZoom) {
        this.maxZoom = maxZoom;
    }

    public void useBestQuality(boolean bestQuality) {
        this.bestQuality = bestQuality;
    }

    public boolean isBestQuality() {
        return this.bestQuality;
    }

    public boolean isSwipeVertical() {
        return this.swipeVertical;
    }

    public boolean isSwipeEnabled() {
        return this.enableSwipe;
    }

    private void setSwipeVertical(boolean swipeVertical) {
        this.swipeVertical = swipeVertical;
    }

    public void enableAnnotationRendering(boolean annotationRendering) {
        this.annotationRendering = annotationRendering;
    }

    public boolean isAnnotationRendering() {
        return this.annotationRendering;
    }

    public void enableRenderDuringScale(boolean renderDuringScale) {
        this.renderDuringScale = renderDuringScale;
    }

    public boolean isAntialiasing() {
        return this.enableAntialiasing;
    }

    public void enableAntialiasing(boolean enableAntialiasing) {
        this.enableAntialiasing = enableAntialiasing;
    }

    public int getSpacingPx() {
        return this.spacingPx;
    }

    public boolean isAutoSpacingEnabled() {
        return this.autoSpacing;
    }

    public void setPageFling(boolean pageFling) {
        this.pageFling = pageFling;
    }

    public boolean isPageFlingEnabled() {
        return this.pageFling;
    }

    private void setSpacing(int spacingDp) {
        this.spacingPx = Util.getDP(this.getContext(), spacingDp);
    }

    private void setAutoSpacing(boolean autoSpacing) {
        this.autoSpacing = autoSpacing;
    }

    private void setPageFitPolicy(FitPolicy pageFitPolicy) {
        this.pageFitPolicy = pageFitPolicy;
    }

    public FitPolicy getPageFitPolicy() {
        return this.pageFitPolicy;
    }

    private void setFitEachPage(boolean fitEachPage) {
        this.fitEachPage = fitEachPage;
    }

    public boolean isFitEachPage() {
        return this.fitEachPage;
    }

    public boolean isPageSnap() {
        return this.pageSnap;
    }

    public void setPageSnap(boolean pageSnap) {
        this.pageSnap = pageSnap;
    }

    public boolean doRenderDuringScale() {
        return this.renderDuringScale;
    }

    public PdfDocument.Meta getDocumentMeta() {
        if (this.pdfFile == null) {
            return null;
        }
        return this.pdfFile.getMetaData();
    }

    public List<PdfDocument.Bookmark> getTableOfContents() {
        if (this.pdfFile == null) {
            return Collections.emptyList();
        }
        return this.pdfFile.getBookmarks();
    }

    public List<PdfDocument.Link> getLinks(int page) {
        if (this.pdfFile == null) {
            return Collections.emptyList();
        }
        return this.pdfFile.getPageLinks(page);
    }

    public Configurator fromAsset(String assetName) {
        return new Configurator(new AssetSource(assetName));
    }

    public Configurator fromFile(File file) {
        return new Configurator(new FileSource(file));
    }

    public Configurator fromUri(Uri uri) {
        return new Configurator(new UriSource(uri));
    }

    public Configurator fromBytes(byte[] bytes) {
        return new Configurator(new ByteArraySource(bytes));
    }

    public Configurator fromStream(InputStream stream) {
        return new Configurator(new InputStreamSource(stream));
    }

    public Configurator fromSource(DocumentSource docSource) {
        return new Configurator(docSource);
    }

    static enum ScrollDir {
        NONE,
        START,
        END;

    }

    private static enum State {
        DEFAULT,
        LOADED,
        SHOWN,
        ERROR;

    }

    public class Configurator {
        private final DocumentSource documentSource;
        private int[] pageNumbers = null;
        private boolean enableSwipe = true;
        private boolean enableDoubletap = true;
        private OnDrawListener onDrawListener;
        private OnDrawListener onDrawAllListener;
        private OnLoadCompleteListener onLoadCompleteListener;
        private OnErrorListener onErrorListener;
        private OnPageChangeListener onPageChangeListener;
        private OnPageScrollListener onPageScrollListener;
        private OnRenderListener onRenderListener;
        private OnTapListener onTapListener;
        private OnLongPressListener onLongPressListener;
        private OnPageErrorListener onPageErrorListener;
        private LinkHandler linkHandler = new DefaultLinkHandler(PDFView.this);
        private int defaultPage = 0;
        private boolean swipeHorizontal = false;
        private boolean annotationRendering = false;
        private String password = null;
        private ScrollHandle scrollHandle = null;
        private boolean antialiasing = true;
        private int spacing = 0;
        private boolean autoSpacing = false;
        private FitPolicy pageFitPolicy = FitPolicy.WIDTH;
        private boolean fitEachPage = false;
        private boolean pageFling = false;
        private boolean pageSnap = false;
        private boolean nightMode = false;

        private Configurator(DocumentSource documentSource) {
            this.documentSource = documentSource;
        }

        public Configurator pages(int ... pageNumbers) {
            this.pageNumbers = pageNumbers;
            return this;
        }

        public Configurator enableSwipe(boolean enableSwipe) {
            this.enableSwipe = enableSwipe;
            return this;
        }

        public Configurator enableDoubletap(boolean enableDoubletap) {
            this.enableDoubletap = enableDoubletap;
            return this;
        }

        public Configurator enableAnnotationRendering(boolean annotationRendering) {
            this.annotationRendering = annotationRendering;
            return this;
        }

        public Configurator onDraw(OnDrawListener onDrawListener) {
            this.onDrawListener = onDrawListener;
            return this;
        }

        public Configurator onDrawAll(OnDrawListener onDrawAllListener) {
            this.onDrawAllListener = onDrawAllListener;
            return this;
        }

        public Configurator onLoad(OnLoadCompleteListener onLoadCompleteListener) {
            this.onLoadCompleteListener = onLoadCompleteListener;
            return this;
        }

        public Configurator onPageScroll(OnPageScrollListener onPageScrollListener) {
            this.onPageScrollListener = onPageScrollListener;
            return this;
        }

        public Configurator onError(OnErrorListener onErrorListener) {
            this.onErrorListener = onErrorListener;
            return this;
        }

        public Configurator onPageError(OnPageErrorListener onPageErrorListener) {
            this.onPageErrorListener = onPageErrorListener;
            return this;
        }

        public Configurator onPageChange(OnPageChangeListener onPageChangeListener) {
            this.onPageChangeListener = onPageChangeListener;
            return this;
        }

        public Configurator onRender(OnRenderListener onRenderListener) {
            this.onRenderListener = onRenderListener;
            return this;
        }

        public Configurator onTap(OnTapListener onTapListener) {
            this.onTapListener = onTapListener;
            return this;
        }

        public Configurator onLongPress(OnLongPressListener onLongPressListener) {
            this.onLongPressListener = onLongPressListener;
            return this;
        }

        public Configurator linkHandler(LinkHandler linkHandler) {
            this.linkHandler = linkHandler;
            return this;
        }

        public Configurator defaultPage(int defaultPage) {
            this.defaultPage = defaultPage;
            return this;
        }

        public Configurator swipeHorizontal(boolean swipeHorizontal) {
            this.swipeHorizontal = swipeHorizontal;
            return this;
        }

        public Configurator password(String password) {
            this.password = password;
            return this;
        }

        public Configurator scrollHandle(ScrollHandle scrollHandle) {
            this.scrollHandle = scrollHandle;
            return this;
        }

        public Configurator enableAntialiasing(boolean antialiasing) {
            this.antialiasing = antialiasing;
            return this;
        }

        public Configurator spacing(int spacing) {
            this.spacing = spacing;
            return this;
        }

        public Configurator autoSpacing(boolean autoSpacing) {
            this.autoSpacing = autoSpacing;
            return this;
        }

        public Configurator pageFitPolicy(FitPolicy pageFitPolicy) {
            this.pageFitPolicy = pageFitPolicy;
            return this;
        }

        public Configurator fitEachPage(boolean fitEachPage) {
            this.fitEachPage = fitEachPage;
            return this;
        }

        public Configurator pageSnap(boolean pageSnap) {
            this.pageSnap = pageSnap;
            return this;
        }

        public Configurator pageFling(boolean pageFling) {
            this.pageFling = pageFling;
            return this;
        }

        public Configurator nightMode(boolean nightMode) {
            this.nightMode = nightMode;
            return this;
        }

        public Configurator disableLongpress() {
            PDFView.this.dragPinchManager.disableLongpress();
            return this;
        }

        public void load() {
            if (!PDFView.this.hasSize) {
                PDFView.this.waitingDocumentConfigurator = this;
                return;
            }
            PDFView.this.recycle();
            PDFView.this.callbacks.setOnLoadComplete(this.onLoadCompleteListener);
            PDFView.this.callbacks.setOnError(this.onErrorListener);
            PDFView.this.callbacks.setOnDraw(this.onDrawListener);
            PDFView.this.callbacks.setOnDrawAll(this.onDrawAllListener);
            PDFView.this.callbacks.setOnPageChange(this.onPageChangeListener);
            PDFView.this.callbacks.setOnPageScroll(this.onPageScrollListener);
            PDFView.this.callbacks.setOnRender(this.onRenderListener);
            PDFView.this.callbacks.setOnTap(this.onTapListener);
            PDFView.this.callbacks.setOnLongPress(this.onLongPressListener);
            PDFView.this.callbacks.setOnPageError(this.onPageErrorListener);
            PDFView.this.callbacks.setLinkHandler(this.linkHandler);
            PDFView.this.setSwipeEnabled(this.enableSwipe);
            PDFView.this.setNightMode(this.nightMode);
            PDFView.this.enableDoubletap(this.enableDoubletap);
            PDFView.this.setDefaultPage(this.defaultPage);
            PDFView.this.setSwipeVertical(!this.swipeHorizontal);
            PDFView.this.enableAnnotationRendering(this.annotationRendering);
            PDFView.this.setScrollHandle(this.scrollHandle);
            PDFView.this.enableAntialiasing(this.antialiasing);
            PDFView.this.setSpacing(this.spacing);
            PDFView.this.setAutoSpacing(this.autoSpacing);
            PDFView.this.setPageFitPolicy(this.pageFitPolicy);
            PDFView.this.setFitEachPage(this.fitEachPage);
            PDFView.this.setPageSnap(this.pageSnap);
            PDFView.this.setPageFling(this.pageFling);
            if (this.pageNumbers != null) {
                PDFView.this.load(this.documentSource, this.password, this.pageNumbers);
            } else {
                PDFView.this.load(this.documentSource, this.password);
            }
        }
    }
}

