/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.wrapper;

import org.mapfish.print.wrapper.PArray;
import org.mapfish.print.wrapper.PObject;

public final class PJoinedArray
implements PArray {
    private final PArray[] arrays;
    private final int combinedSize;

    public PJoinedArray(PArray[] arrays) {
        this.arrays = arrays;
        int size = 0;
        for (PArray array : arrays) {
            size += array.size();
        }
        this.combinedSize = size;
    }

    @Override
    public int size() {
        return this.combinedSize;
    }

    @Override
    public PObject getObject(int i) {
        int index = i;
        for (PArray array : this.arrays) {
            if (index < array.size()) {
                return array.getObject(index);
            }
            index -= array.size();
        }
        return null;
    }

    @Override
    public PArray getArray(int i) {
        int index = i;
        for (PArray array : this.arrays) {
            if (index < array.size()) {
                return array.getArray(index);
            }
            index -= array.size();
        }
        return null;
    }

    @Override
    public int getInt(int i) {
        Object o = this.getObjectAt(i);
        return (Integer)o;
    }

    @Override
    public long getLong(int i) {
        Object o = this.getObjectAt(i);
        return (Long)o;
    }

    @Override
    public float getFloat(int i) {
        Object o = this.getObjectAt(i);
        return ((Float)o).floatValue();
    }

    @Override
    public double getDouble(int i) {
        Object o = this.getObjectAt(i);
        return (Double)o;
    }

    @Override
    public String getString(int i) {
        return this.getObjectAt(i).toString();
    }

    @Override
    public boolean getBool(int i) {
        Object o = this.getObjectAt(i);
        return (Boolean)o;
    }

    private Object getObjectAt(int index) throws IndexOutOfBoundsException {
        Object o = this.get(index);
        if (o == null) {
            throw new IndexOutOfBoundsException("No value found at index:" + index);
        }
        return o;
    }

    @Override
    public String getPath(String key) {
        StringBuilder builder = new StringBuilder();
        for (PArray array : this.arrays) {
            if (builder.length() == 0) {
                builder.append(" + ");
            }
            builder.append(array.getPath(key));
        }
        return "Merged: " + builder;
    }

    @Override
    public String getCurrentPath() {
        StringBuilder builder = new StringBuilder();
        for (PArray array : this.arrays) {
            if (builder.length() == 0) {
                builder.append(" + ");
            }
            builder.append(array.getCurrentPath());
        }
        return "Merged: " + builder;
    }

    @Override
    public Object get(int i) {
        int index = i;
        for (PArray array : this.arrays) {
            if (index < array.size()) {
                return array.get(index);
            }
            index -= array.size();
        }
        return null;
    }
}

