/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.metrics;

import com.codahale.metrics.health.HealthCheck;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import org.mapfish.print.servlet.job.JobQueue;
import org.mapfish.print.servlet.job.impl.ThreadPoolJobManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class JobQueueHealthCheck
extends HealthCheck {
    @Value(value="${healthStatus.expectedMaxTime.sinceLastPrint.InSeconds}")
    private int secondsInFloatingWindow;
    @Value(value="${healthStatus.unhealthyThreshold.maxNbrPrintJobQueued}")
    private int maxNbrPrintJobQueued;
    @Autowired
    private JobQueue jobQueue;
    @Autowired
    private ThreadPoolJobManager jobManager;

    protected HealthCheck.Result check() throws Exception {
        long waitingJobsCount = this.jobQueue.getWaitingJobsCount();
        if (waitingJobsCount == 0L) {
            return HealthCheck.Result.healthy((String)"No print job is waiting in the queue.");
        }
        String health = ". Number of print jobs waiting is " + waitingJobsCount;
        if (this.jobManager.getLastExecutedJobTimestamp() == null) {
            return HealthCheck.Result.unhealthy((String)("This server never processed a print job" + health));
        }
        if (this.hasThisServerPrintedRecently()) {
            if (waitingJobsCount > (long)this.maxNbrPrintJobQueued) {
                return HealthCheck.Result.unhealthy((String)("WIP: Number of print jobs queued is above threshold: " + this.maxNbrPrintJobQueued + health));
            }
            return HealthCheck.Result.healthy((String)("This server instance is printing" + health));
        }
        throw this.notificationForBrokenServer();
    }

    private RuntimeException notificationForBrokenServer() {
        return new RuntimeException("None of the print job queued was processed by this server, in the last (seconds): " + this.secondsInFloatingWindow);
    }

    private boolean hasThisServerPrintedRecently() {
        Instant lastExecutedJobTime = this.jobManager.getLastExecutedJobTimestamp().toInstant();
        Instant beginningOfTimeWindow = this.getBeginningOfTimeWindow();
        return lastExecutedJobTime.isAfter(beginningOfTimeWindow);
    }

    private Instant getBeginningOfTimeWindow() {
        return new Date().toInstant().minus(Duration.ofSeconds(this.secondsInFloatingWindow));
    }
}

