/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.tiled.wms;

import java.awt.Dimension;
import java.net.URISyntaxException;
import org.locationtech.jts.util.Assert;
import org.mapfish.print.map.image.wms.WmsLayerParam;
import org.mapfish.print.parser.HasDefaultValue;

public final class TiledWmsLayerParam
extends WmsLayerParam {
    public int[] tileSize;
    @HasDefaultValue
    public int[] tileBufferSize = new int[]{0, 0};

    public TiledWmsLayerParam() {
    }

    public TiledWmsLayerParam(WmsLayerParam params, Dimension tileSize, int tileBufferWidth, int tileBufferHeight) {
        super(params);
        this.tileSize = new int[]{tileSize.width, tileSize.height};
        this.tileBufferSize = new int[]{tileBufferWidth, tileBufferHeight};
    }

    @Override
    public void postConstruct() throws URISyntaxException {
        super.postConstruct();
        Assert.isTrue((this.tileSize.length == 2 ? 1 : 0) != 0, (String)("The tileSize parameter must have exactly two elements, x,y tile size.  Actual number of elements was: " + this.tileSize.length));
    }

    public Dimension getTileSize() {
        return new Dimension(this.tileSize[0], this.tileSize[1]);
    }

    public int getTileBufferWidth() {
        return this.tileBufferSize[0];
    }

    public int getTileBufferHeight() {
        return this.tileBufferSize[1];
    }
}

