/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.tiled;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.mapfish.print.FloatingPointUtil;
import org.mapfish.print.PrintException;
import org.mapfish.print.attribute.map.MapBounds;
import org.mapfish.print.attribute.map.MapfishMapContext;
import org.mapfish.print.http.HttpRequestFetcher;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.mapfish.print.map.tiled.TileCacheInformation;
import org.mapfish.print.map.tiled.TilePreparationInfo;
import org.mapfish.print.processor.Processor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.client.ClientHttpRequest;

public final class TilePreparationTask
implements Callable<TilePreparationInfo> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TilePreparationTask.class);
    private final MapBounds bounds;
    private final Rectangle paintArea;
    private final MapfishMapContext transformer;
    private final TileCacheInformation tiledLayer;
    private final Processor.ExecutionContext context;
    private final MfClientHttpRequestFactory httpRequestFactory;
    private final HttpRequestFetcher requestCache;
    private Optional<Geometry> cachedRotatedMapBounds = Optional.empty();

    public TilePreparationTask(@Nonnull MfClientHttpRequestFactory httpRequestFactory, @Nonnull MapfishMapContext transformer, @Nonnull TileCacheInformation tileCacheInfo, HttpRequestFetcher requestCache, @Nonnull Processor.ExecutionContext context) {
        this.requestCache = requestCache;
        this.bounds = transformer.getBounds();
        this.paintArea = new Rectangle(transformer.getMapSize());
        this.httpRequestFactory = httpRequestFactory;
        this.transformer = transformer;
        this.tiledLayer = tileCacheInfo;
        this.context = context;
    }

    @Override
    public TilePreparationInfo call() {
        return this.context.mdcContext(() -> {
            try {
                ReferencedEnvelope mapGeoBounds = this.bounds.toReferencedEnvelope(this.paintArea);
                CoordinateReferenceSystem mapProjection = mapGeoBounds.getCoordinateReferenceSystem();
                Dimension tileSizeOnScreen = this.tiledLayer.getTileSize();
                int tileBufferWidth = this.tiledLayer.getTileBufferWidth();
                int tileBufferHeight = this.tiledLayer.getTileBufferHeight();
                Dimension tileSizeOnScreenWithBuffer = new Dimension(tileSizeOnScreen.width + 2 * tileBufferWidth, tileSizeOnScreen.height + 2 * tileBufferHeight);
                double resolution = this.tiledLayer.getResolution();
                Coordinate tileSizeInWorld = new Coordinate((double)tileSizeOnScreen.width * resolution, (double)tileSizeOnScreen.height * resolution);
                Coordinate bufferSizeInWorld = new Coordinate((double)tileBufferWidth * resolution, (double)tileBufferHeight * resolution);
                Coordinate gridCoverageOrigin = this.tiledLayer.getMinGeoCoordinate(mapGeoBounds, tileSizeInWorld);
                String commonUrl = this.tiledLayer.createCommonUrl();
                ReferencedEnvelope tileCacheBounds = this.tiledLayer.getTileCacheBounds();
                double rowFactor = 1.0 / (resolution * (double)tileSizeOnScreen.height);
                double columnFactor = 1.0 / (resolution * (double)tileSizeOnScreen.width);
                int imageWidth = 0;
                int imageHeight = 0;
                int yIndex = (int)Math.floor((mapGeoBounds.getMaxY() - gridCoverageOrigin.y) / tileSizeInWorld.y) + 1;
                double gridCoverageMaxX = gridCoverageOrigin.x;
                double gridCoverageMaxY = gridCoverageOrigin.y;
                ArrayList<TilePreparationInfo.SingleTilePreparationInfo> tiles = new ArrayList<TilePreparationInfo.SingleTilePreparationInfo>();
                for (double geoY = gridCoverageOrigin.y; geoY < mapGeoBounds.getMaxY(); geoY += tileSizeInWorld.y) {
                    --yIndex;
                    imageHeight += tileSizeOnScreen.height;
                    imageWidth = 0;
                    int xIndex = -1;
                    gridCoverageMaxY = geoY + tileSizeInWorld.y;
                    for (double geoX = gridCoverageOrigin.x; geoX < mapGeoBounds.getMaxX(); geoX += tileSizeInWorld.x) {
                        ++xIndex;
                        imageWidth += tileSizeOnScreen.width;
                        gridCoverageMaxX = geoX + tileSizeInWorld.x;
                        ReferencedEnvelope tileBounds = new ReferencedEnvelope(geoX, gridCoverageMaxX, geoY, gridCoverageMaxY, mapProjection);
                        ReferencedEnvelope tileBoundsWithBuffer = new ReferencedEnvelope(geoX - bufferSizeInWorld.x, gridCoverageMaxX + bufferSizeInWorld.x, geoY - bufferSizeInWorld.y, gridCoverageMaxY + bufferSizeInWorld.y, mapProjection);
                        int row = (int)Math.round((tileCacheBounds.getMaxY() - tileBounds.getMaxY()) * rowFactor);
                        int column = (int)Math.round((tileBounds.getMinX() - tileCacheBounds.getMinX()) * columnFactor);
                        ClientHttpRequest tileRequest = this.tiledLayer.getTileRequest(this.httpRequestFactory, commonUrl, tileBoundsWithBuffer, tileSizeOnScreenWithBuffer, column, row);
                        if (this.isInTileCacheBounds(tileCacheBounds, tileBounds)) {
                            if (!this.isTileVisible(tileBounds)) continue;
                            tileRequest = this.requestCache.register(tileRequest);
                            tiles.add(new TilePreparationInfo.SingleTilePreparationInfo(xIndex, yIndex, tileRequest));
                            continue;
                        }
                        if (!LOGGER.isDebugEnabled()) continue;
                        LOGGER.debug("Tile '{}' bounds [{}, {}, {}, {}]  out of tile cache bounds [{}, {}, {}, {}]", new Object[]{tileRequest.getURI(), tileBounds.getMinX(), tileBounds.getMinY(), tileBounds.getMaxX(), tileBounds.getMaxY(), tileCacheBounds.getMinX(), tileCacheBounds.getMinY(), tileCacheBounds.getMaxX(), tileCacheBounds.getMaxY()});
                    }
                }
                return new TilePreparationInfo(tiles, imageWidth, imageHeight, gridCoverageOrigin, gridCoverageMaxX, gridCoverageMaxY, mapProjection);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PrintException("Failed to call Tile preparation task", e);
            }
        });
    }

    private boolean isInTileCacheBounds(ReferencedEnvelope tileCacheBounds, ReferencedEnvelope tilesBounds) {
        double boundsMinX = tilesBounds.getMinX();
        double boundsMinY = tilesBounds.getMinY();
        return boundsMinX >= tileCacheBounds.getMinX() && boundsMinX <= tileCacheBounds.getMaxX() && boundsMinY >= tileCacheBounds.getMinY() && boundsMinY <= tileCacheBounds.getMaxY();
    }

    private boolean isTileVisible(ReferencedEnvelope tileBounds) {
        if (FloatingPointUtil.equals(this.transformer.getRotation(), 0.0)) {
            return true;
        }
        GeometryFactory gfac = new GeometryFactory();
        Optional<Geometry> rotatedMapBounds = this.getRotatedMapBounds(gfac);
        if (rotatedMapBounds.isPresent()) {
            return rotatedMapBounds.get().intersects(gfac.toGeometry((Envelope)tileBounds));
        }
        return true;
    }

    private Optional<Geometry> getRotatedMapBounds(GeometryFactory gfac) {
        if (this.cachedRotatedMapBounds.isPresent()) {
            return this.cachedRotatedMapBounds;
        }
        ReferencedEnvelope mapBounds = this.transformer.getBounds().toReferencedEnvelope(new Rectangle(this.transformer.getMapSize()));
        Coordinate center = mapBounds.centre();
        AffineTransform affineTransform = AffineTransform.getRotateInstance(this.transformer.getRotation(), center.x, center.y);
        AffineTransform2D mathTransform = new AffineTransform2D(affineTransform);
        try {
            Geometry rotatedBounds = JTS.transform((Geometry)gfac.toGeometry((Envelope)mapBounds), (MathTransform)mathTransform);
            this.cachedRotatedMapBounds = Optional.of(rotatedBounds);
        }
        catch (TransformException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Failed to rotate map bounds: {}", (Object)mapBounds.toString(), (Object)e);
            }
            this.cachedRotatedMapBounds = Optional.empty();
        }
        return this.cachedRotatedMapBounds;
    }
}

