/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.geotools.grid;

import java.awt.geom.AffineTransform;
import javax.annotation.Nonnull;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.style.Style;
import org.geotools.data.collection.CollectionFeatureSource;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.mapfish.print.attribute.map.MapfishMapContext;
import org.mapfish.print.config.Template;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.mapfish.print.map.geotools.FeatureSourceSupplier;
import org.mapfish.print.map.geotools.grid.GridParam;
import org.mapfish.print.map.geotools.grid.GridType;
import org.mapfish.print.map.geotools.grid.GridUtils;
import org.mapfish.print.map.geotools.grid.LabelPositionCollector;
import org.mapfish.print.map.geotools.grid.PointGridStyle;

class PointGridStrategy
implements GridType.GridTypeStrategy {
    PointGridStrategy() {
    }

    @Override
    public Style defaultStyle(Template template, GridParam layerData) {
        return PointGridStyle.get(layerData);
    }

    @Override
    public FeatureSourceSupplier createFeatureSource(Template template, final GridParam layerData, final LabelPositionCollector labels) {
        return new FeatureSourceSupplier(){

            @Override
            @Nonnull
            public FeatureSource load(@Nonnull MfClientHttpRequestFactory requestFactory, @Nonnull MapfishMapContext mapContext) {
                SimpleFeatureType featureType = GridUtils.createGridFeatureType(mapContext, Point.class);
                SimpleFeatureBuilder featureBuilder = new SimpleFeatureBuilder(featureType);
                DefaultFeatureCollection features = layerData.numberOfLines != null ? PointGridStrategy.this.createFeaturesFromNumberOfLines(mapContext, featureBuilder, layerData, labels) : PointGridStrategy.this.createFeaturesFromSpacing(mapContext, featureBuilder, layerData, labels);
                return new CollectionFeatureSource((SimpleFeatureCollection)features);
            }
        };
    }

    private DefaultFeatureCollection createFeaturesFromSpacing(MapfishMapContext mapContext, SimpleFeatureBuilder featureBuilder, GridParam layerData, LabelPositionCollector labels) {
        GeometryFactory geometryFactory = new GeometryFactory();
        ReferencedEnvelope bounds = mapContext.toReferencedEnvelope();
        CoordinateReferenceSystem mapCrs = bounds.getCoordinateReferenceSystem();
        String unit = layerData.calculateLabelUnit(mapCrs);
        MathTransform labelTransform = layerData.calculateLabelTransform(mapCrs);
        double incrementX = layerData.spacing[0];
        double incrementY = layerData.spacing[1];
        double minX = GridUtils.calculateFirstLine(bounds, layerData, 0);
        double minY = GridUtils.calculateFirstLine(bounds, layerData, 1);
        MapfishMapContext rootContext = mapContext.getRootContext();
        Polygon rotatedBounds = GridUtils.calculateBounds(rootContext);
        AffineTransform worldToScreenTransform = GridUtils.getWorldToScreenTransform(mapContext);
        DefaultFeatureCollection features = new DefaultFeatureCollection();
        int i = 0;
        boolean addBorderFeatures = true;
        for (double x = minX; x < bounds.getMaxX(); x += incrementX) {
            ++i;
            int j = 0;
            if (!this.onRightBorder(bounds, x)) {
                Geometry intersectionsBB = GridUtils.computeBottomBorderIntersections(rotatedBounds, geometryFactory, x);
                GridUtils.bottomBorderLabel(labels, unit, worldToScreenTransform, labelTransform, layerData.getGridLabelFormat(), intersectionsBB);
                Geometry intersectionsTB = GridUtils.computeTopBorderIntersections(rotatedBounds, geometryFactory, x);
                GridUtils.topBorderLabel(labels, unit, worldToScreenTransform, labelTransform, layerData.getGridLabelFormat(), intersectionsTB);
            }
            for (double y = minY; y < bounds.getMaxY(); y += incrementY) {
                ++j;
                if (addBorderFeatures && !this.onRightBorder(bounds, x) && !this.onTopBorder(bounds, y)) {
                    Geometry intersectionsLB = GridUtils.computeLeftBorderIntersections(rotatedBounds, geometryFactory, y);
                    GridUtils.leftBorderLabel(labels, unit, worldToScreenTransform, labelTransform, layerData.getGridLabelFormat(), intersectionsLB);
                    Geometry intersectionsRB = GridUtils.computeRightBorderIntersections(rotatedBounds, geometryFactory, y);
                    GridUtils.rightBorderLabel(labels, unit, worldToScreenTransform, labelTransform, layerData.getGridLabelFormat(), intersectionsRB);
                }
                if (this.onTopBorder(bounds, y) || this.onBottomBorder(bounds, y) || this.onLeftBorder(bounds, x) || this.onRightBorder(bounds, x)) continue;
                featureBuilder.reset();
                Point geom = geometryFactory.createPoint(new Coordinate(x, y));
                featureBuilder.set("geom", (Object)geom);
                features.add(featureBuilder.buildFeature("grid." + i + "." + j));
            }
            addBorderFeatures = false;
        }
        return features;
    }

    private boolean onRightBorder(ReferencedEnvelope bounds, double x) {
        return x >= bounds.getMaxX();
    }

    private boolean onLeftBorder(ReferencedEnvelope bounds, double x) {
        return x <= bounds.getMinX();
    }

    private boolean onBottomBorder(ReferencedEnvelope bounds, double y) {
        return y <= bounds.getMinY();
    }

    private boolean onTopBorder(ReferencedEnvelope bounds, double y) {
        return y >= bounds.getMaxY();
    }

    private DefaultFeatureCollection createFeaturesFromNumberOfLines(MapfishMapContext mapContext, SimpleFeatureBuilder featureBuilder, GridParam layerData, LabelPositionCollector labels) {
        GeometryFactory geometryFactory = new GeometryFactory();
        ReferencedEnvelope bounds = mapContext.toReferencedEnvelope();
        MapfishMapContext rootContext = mapContext.getRootContext();
        Polygon rotatedBounds = GridUtils.calculateBounds(rootContext);
        AffineTransform worldToScreenTransform = GridUtils.getWorldToScreenTransform(mapContext);
        CoordinateReferenceSystem mapCrs = bounds.getCoordinateReferenceSystem();
        String unit = layerData.calculateLabelUnit(mapCrs);
        MathTransform labelTransform = layerData.calculateLabelTransform(mapCrs);
        double incrementX = bounds.getWidth() / (double)(layerData.numberOfLines[0] + 1);
        double incrementY = bounds.getHeight() / (double)(layerData.numberOfLines[1] + 1);
        double x = bounds.getMinX();
        DefaultFeatureCollection features = new DefaultFeatureCollection();
        for (int i = 0; i < layerData.numberOfLines[0] + 2; ++i) {
            double y = bounds.getMinY();
            for (int j = 0; j < layerData.numberOfLines[1] + 2; ++j) {
                String fid = "grid." + i + "." + j;
                if (!(i == 0 && j == 0 || i == layerData.numberOfLines[0] + 1 && j == layerData.numberOfLines[1] + 1 || i == 0 && j == layerData.numberOfLines[1] + 1 || i == layerData.numberOfLines[0] + 1 && j == 0)) {
                    if (i == 0) {
                        Geometry intersectionsLB = GridUtils.computeLeftBorderIntersections(rotatedBounds, geometryFactory, y);
                        GridUtils.leftBorderLabel(labels, unit, worldToScreenTransform, labelTransform, layerData.getGridLabelFormat(), intersectionsLB);
                    } else if (i == layerData.numberOfLines[0] + 1) {
                        Geometry intersectionsRB = GridUtils.computeRightBorderIntersections(rotatedBounds, geometryFactory, y);
                        GridUtils.rightBorderLabel(labels, unit, worldToScreenTransform, labelTransform, layerData.getGridLabelFormat(), intersectionsRB);
                    } else if (j == 0) {
                        Geometry intersectionsBB = GridUtils.computeBottomBorderIntersections(rotatedBounds, geometryFactory, x);
                        GridUtils.bottomBorderLabel(labels, unit, worldToScreenTransform, labelTransform, layerData.getGridLabelFormat(), intersectionsBB);
                    } else if (j == layerData.numberOfLines[1] + 1) {
                        Geometry intersectionsTB = GridUtils.computeTopBorderIntersections(rotatedBounds, geometryFactory, x);
                        GridUtils.topBorderLabel(labels, unit, worldToScreenTransform, labelTransform, layerData.getGridLabelFormat(), intersectionsTB);
                    } else {
                        featureBuilder.reset();
                        Point geom = geometryFactory.createPoint(new Coordinate(x, y));
                        featureBuilder.set("geom", (Object)geom);
                        features.add(featureBuilder.buildFeature(fid));
                    }
                }
                y += incrementY;
            }
            x += incrementX;
        }
        return features;
    }
}

