/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.processor.map;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import org.mapfish.print.attribute.Attribute;
import org.mapfish.print.attribute.DataSourceAttribute;
import org.mapfish.print.attribute.map.AreaOfInterest;
import org.mapfish.print.attribute.map.MapAttribute;
import org.mapfish.print.attribute.map.PagingAttribute;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.map.DistanceUnit;
import org.mapfish.print.processor.AbstractProcessor;
import org.mapfish.print.processor.Processor;
import org.mapfish.print.processor.ProvideAttributes;
import org.mapfish.print.processor.RequireAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateMapPagesProcessor
extends AbstractProcessor<Input, Output>
implements ProvideAttributes,
RequireAttributes {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateMapPagesProcessor.class);
    private static final int DO_NOT_RENDER_BBOX_INDEX = -1;
    private static final String MAP_KEY = "map";
    private final GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory();
    private MapAttribute mapAttribute;

    protected CreateMapPagesProcessor() {
        super(Output.class);
    }

    @Override
    protected void extraValidation(List<Throwable> validationErrors, Configuration configuration) {
    }

    @Override
    public final Input createInputParameter() {
        return new Input();
    }

    @Override
    public final Output execute(Input values, Processor.ExecutionContext context) {
        MapAttribute.MapAttributeValues map = values.map;
        PagingAttribute.PagingProcessorValues paging = values.paging;
        CoordinateReferenceSystem projection = map.getMapBounds().getProjection();
        Rectangle paintArea = new Rectangle(map.getMapSize());
        DistanceUnit projectionUnit = DistanceUnit.fromProjection(projection);
        AreaOfInterest areaOfInterest = map.areaOfInterest;
        if (areaOfInterest == null) {
            areaOfInterest = new AreaOfInterest();
            areaOfInterest.display = AreaOfInterest.AoiDisplay.NONE;
            ReferencedEnvelope mapBBox = map.getMapBounds().toReferencedEnvelope(paintArea);
            areaOfInterest.setPolygon(this.geometryFactory.toGeometry((Envelope)mapBBox));
        }
        Envelope aoiBBox = areaOfInterest.getArea().getEnvelopeInternal();
        double paintAreaWidthIn = paintArea.getWidth() * paging.scale / 72.0;
        double paintAreaHeightIn = paintArea.getHeight() * paging.scale / 72.0;
        double paintAreaWidth = DistanceUnit.IN.convertTo(paintAreaWidthIn, projectionUnit);
        double paintAreaHeight = DistanceUnit.IN.convertTo(paintAreaHeightIn, projectionUnit);
        double overlapProj = DistanceUnit.IN.convertTo(paging.overlap * paging.scale / 72.0, projectionUnit);
        int nbWidth = (int)Math.ceil((aoiBBox.getWidth() + overlapProj) / (paintAreaWidth - overlapProj));
        int nbHeight = (int)Math.ceil((aoiBBox.getHeight() + overlapProj) / (paintAreaHeight - overlapProj));
        double marginWidth = (paintAreaWidth * (double)nbWidth - (double)(nbWidth - 1) * overlapProj - aoiBBox.getWidth()) / 2.0;
        double marginHeight = (paintAreaHeight * (double)nbHeight - (double)(nbHeight - 1) * overlapProj - aoiBBox.getHeight()) / 2.0;
        double minX = aoiBBox.getMinX() - marginWidth - overlapProj / 2.0;
        double minY = aoiBBox.getMinY() - marginHeight - overlapProj / 2.0;
        LOGGER.info("Paging generate a grid of {}x{} potential maps.", (Object)nbWidth, (Object)nbHeight);
        int[][] mapIndexes = new int[nbWidth][nbHeight];
        Envelope[][] mapsBounds = new Envelope[nbWidth][nbHeight];
        int mapIndex = 0;
        for (int j = 0; j < nbHeight; ++j) {
            for (int i = 0; i < nbWidth; ++i) {
                double x1 = minX + (double)i * (paintAreaWidth - overlapProj);
                double x2 = x1 + paintAreaWidth;
                double y1 = minY + (double)j * (paintAreaHeight - overlapProj);
                double y2 = y1 + paintAreaHeight;
                Coordinate[] coords = new Coordinate[]{new Coordinate(x1, y1), new Coordinate(x1, y2), new Coordinate(x2, y2), new Coordinate(x2, y1), new Coordinate(x1, y1)};
                LinearRing ring = this.geometryFactory.createLinearRing(coords);
                Polygon bbox = this.geometryFactory.createPolygon(ring);
                if (areaOfInterest.getArea().intersects((Geometry)bbox)) {
                    mapsBounds[i][j] = bbox.getEnvelopeInternal();
                    mapIndexes[i][j] = mapIndex++;
                    continue;
                }
                mapIndexes[i][j] = -1;
            }
        }
        ArrayList mapList = new ArrayList();
        for (int j = 0; j < nbHeight; ++j) {
            for (int i = 0; i < nbWidth; ++i) {
                if (mapIndexes[i][j] == -1) continue;
                HashMap<String, Object> mapValues = new HashMap<String, Object>();
                mapValues.put("name", mapIndexes[i][j]);
                mapValues.put("left", i != 0 ? mapIndexes[i - 1][j] : -1);
                mapValues.put("bottom", j != 0 ? mapIndexes[i][j - 1] : -1);
                mapValues.put("right", i != nbWidth - 1 ? mapIndexes[i + 1][j] : -1);
                mapValues.put("top", j != nbHeight - 1 ? mapIndexes[i][j + 1] : -1);
                Envelope mapsBound = mapsBounds[i][j];
                MapAttribute.MapAttributeValues theMap = map.copy(map.getWidth(), map.getHeight(), input -> {
                    input.center = null;
                    input.bbox = new double[]{mapsBound.getMinX(), mapsBound.getMinY(), mapsBound.getMaxX(), mapsBound.getMaxY()};
                    if (paging.aoiDisplay != null) {
                        input.areaOfInterest.display = paging.aoiDisplay;
                    }
                    if (paging.aoiStyle != null) {
                        input.areaOfInterest.style = paging.aoiStyle;
                    }
                    return null;
                });
                mapValues.put(MAP_KEY, theMap);
                mapList.add(mapValues);
            }
        }
        LOGGER.info("Paging generate {} maps definitions.", (Object)mapList.size());
        DataSourceAttribute.DataSourceAttributeValue datasourceAttributes = new DataSourceAttribute.DataSourceAttributeValue();
        datasourceAttributes.attributesValues = mapList.toArray(new Map[0]);
        return new Output(datasourceAttributes);
    }

    @Override
    public void setAttribute(String name, Attribute attribute) {
        if (name.equals(MAP_KEY)) {
            this.mapAttribute = (MapAttribute)attribute;
        }
    }

    @Override
    public Map<String, Attribute> getAttributes() {
        HashMap<String, Attribute> result = new HashMap<String, Attribute>();
        DataSourceAttribute datasourceAttribute = new DataSourceAttribute();
        HashMap<String, Attribute> dsResult = new HashMap<String, Attribute>();
        dsResult.put(MAP_KEY, this.mapAttribute);
        datasourceAttribute.setAttributes(dsResult);
        result.put("datasource", datasourceAttribute);
        return result;
    }

    public static final class Output {
        public final DataSourceAttribute.DataSourceAttributeValue datasource;

        private Output(DataSourceAttribute.DataSourceAttributeValue tableList) {
            this.datasource = tableList;
        }
    }

    public static class Input {
        public MapAttribute.MapAttributeValues map;
        public PagingAttribute.PagingProcessorValues paging;
    }
}

