/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.processor.http.matcher;

import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.processor.http.matcher.InetHostMatcher;

public class LocalHostMatcher
extends InetHostMatcher {
    @Override
    protected final List<InetHostMatcher.AddressMask> createAuthorizedIPs() throws SocketException {
        ArrayList<InetHostMatcher.AddressMask> authorizedIPs = new ArrayList<InetHostMatcher.AddressMask>();
        Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
        while (ifaces.hasMoreElements()) {
            NetworkInterface networkInterface = ifaces.nextElement();
            List<InterfaceAddress> addrs = networkInterface.getInterfaceAddresses();
            for (InterfaceAddress netAddr : addrs) {
                authorizedIPs.add(new InetHostMatcher.AddressMask(netAddr.getAddress()));
            }
        }
        return authorizedIPs;
    }

    @Override
    public final void validate(List<Throwable> validationErrors, Configuration configuration) {
    }

    @Override
    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("LocalHostMatcher");
        sb.append("{");
        if (this.port >= 0) {
            sb.append("port=").append(this.port);
        }
        if (this.pathRegex != null) {
            sb.append(", pathRegexp=").append(this.pathRegex);
        }
        sb.append(", reject=").append(this.isReject());
        sb.append('}');
        return sb.toString();
    }
}

