/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.processor;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.RecursiveTask;
import javax.annotation.Nonnull;
import org.mapfish.print.output.Values;
import org.mapfish.print.parser.ParserUtils;
import org.mapfish.print.processor.Processor;
import org.mapfish.print.processor.ProcessorExecutionContext;
import org.mapfish.print.processor.ProcessorGraphNode;
import org.mapfish.print.processor.ProcessorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProcessorDependencyGraph {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessorDependencyGraph.class);
    private final List<ProcessorGraphNode<?, ?>> roots = new ArrayList();

    ProcessorDependencyGraph() {
    }

    static void tryExecuteNodes(Collection<ProcessorGraphNode<?, ?>> dependencyNodes, ProcessorExecutionContext execContext, boolean notStartedIsOk) {
        ArrayList tasks = new ArrayList(dependencyNodes.size());
        for (ProcessorGraphNode<?, ?> depNode : dependencyNodes) {
            Optional<ProcessorGraphNode.ProcessorNodeForkJoinTask<?, ?>> task = depNode.createTask(execContext);
            if (task.isPresent()) {
                tasks.add(task.get());
                if (tasks.size() <= 1) continue;
                task.get().fork();
                continue;
            }
            if (notStartedIsOk) continue;
            LOGGER.error("Failed to start the processor {}", depNode.getProcessor());
        }
        if (!tasks.isEmpty()) {
            ((ProcessorGraphNode.ProcessorNodeForkJoinTask)tasks.get(0)).compute();
            for (ProcessorGraphNode.ProcessorNodeForkJoinTask task : tasks.subList(1, tasks.size())) {
                task.join();
            }
        }
    }

    public ProcessorGraphForkJoinTask createTask(@Nonnull Values values) {
        StringBuilder missingAttributes = new StringBuilder();
        Multimap<String, Processor> requiredAttributes = this.getAllRequiredAttributes();
        for (String attribute : requiredAttributes.keySet()) {
            if (values.containsKey(attribute)) continue;
            missingAttributes.append("\n\t* ").append(attribute).append(" <- ").append(requiredAttributes.get((Object)attribute));
        }
        if (missingAttributes.length() > 0) {
            throw new IllegalArgumentException("It has been found that one or more required attributes are missing from the values object:" + missingAttributes + "\n");
        }
        return new ProcessorGraphForkJoinTask(values);
    }

    void addRoot(ProcessorGraphNode<?, ?> node) {
        this.roots.add(node);
    }

    public Multimap<String, Processor> getAllRequiredAttributes() {
        HashMultimap requiredInputs = HashMultimap.create();
        for (ProcessorGraphNode<?, ?> root : this.roots) {
            BiMap<String, String> inputMapper = root.getInputMapper();
            for (String attr : inputMapper.keySet()) {
                requiredInputs.put((Object)attr, root.getProcessor());
            }
            Object inputParameter = root.getProcessor().createInputParameter();
            if (inputParameter instanceof Values || inputParameter == null) continue;
            Class<?> inputParameterClass = inputParameter.getClass();
            Set<String> requiredAttributesDefinedInInputParameter = ParserUtils.getAttributeNames(inputParameterClass, ParserUtils.FILTER_ONLY_REQUIRED_ATTRIBUTES);
            for (String attName : requiredAttributesDefinedInInputParameter) {
                try {
                    if (inputParameterClass.getField(attName).getType() == Values.class) {
                        continue;
                    }
                }
                catch (NoSuchFieldException e) {
                    throw new RuntimeException(e);
                }
                String mappedName = ProcessorUtils.getInputValueName(root.getProcessor().getInputPrefix(), inputMapper, attName);
                requiredInputs.put((Object)mappedName, root.getProcessor());
            }
        }
        return requiredInputs;
    }

    public List<ProcessorGraphNode<?, ?>> getRoots() {
        return this.roots;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("strict digraph g {\n  rankdir=\"LR\";\n  node [shape=\"box\"];\n");
        this.toString(builder, 0, "root");
        builder.append("}");
        return builder.toString();
    }

    public void toString(StringBuilder builder, int indent, String parent) {
        for (ProcessorGraphNode<?, ?> root : this.roots) {
            root.toString(builder, indent, parent);
        }
    }

    public Set<Processor<?, ?>> getAllProcessors() {
        IdentityHashMap all = new IdentityHashMap();
        for (ProcessorGraphNode<?, ?> root : this.roots) {
            for (Processor<?, ?> p : root.getAllProcessors()) {
                all.put(p, null);
            }
        }
        return all.keySet();
    }

    public final class ProcessorGraphForkJoinTask
    extends RecursiveTask<Values> {
        private final ProcessorExecutionContext execContext;

        private ProcessorGraphForkJoinTask(Values values) {
            this.execContext = new ProcessorExecutionContext(values);
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            this.execContext.cancel();
            return super.cancel(mayInterruptIfRunning);
        }

        @Override
        protected Values compute() {
            return this.execContext.getContext().mdcContext(() -> {
                ProcessorDependencyGraph graph = ProcessorDependencyGraph.this;
                LOGGER.debug("Starting to execute processor graph: \n{}", (Object)graph);
                try {
                    ProcessorDependencyGraph.tryExecuteNodes(graph.roots, this.execContext, false);
                }
                catch (RuntimeException ex) {
                    this.execContext.cancel();
                    throw ex;
                }
                finally {
                    LOGGER.debug("Finished executing processor graph: \n{}", (Object)graph);
                }
                return this.execContext.getValues();
            });
        }

        public Processor.ExecutionContext getExecutionContext() {
            return this.execContext.getContext();
        }
    }
}

