/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.config;

import com.google.common.collect.Sets;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import org.geotools.api.style.Style;
import org.json.JSONException;
import org.json.JSONWriter;
import org.mapfish.print.OptionalUtils;
import org.mapfish.print.attribute.Attribute;
import org.mapfish.print.attribute.InternalAttribute;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.config.ConfigurationException;
import org.mapfish.print.config.ConfigurationObject;
import org.mapfish.print.config.HasConfiguration;
import org.mapfish.print.config.PDFConfig;
import org.mapfish.print.config.access.AccessAssertion;
import org.mapfish.print.config.access.AlwaysAllowAssertion;
import org.mapfish.print.config.access.RoleAccessAssertion;
import org.mapfish.print.map.style.StyleParser;
import org.mapfish.print.processor.Processor;
import org.mapfish.print.processor.ProcessorDependencyGraph;
import org.mapfish.print.processor.ProcessorDependencyGraphFactory;
import org.mapfish.print.processor.map.CreateMapProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.client.ClientHttpRequestFactory;

public class Template
implements ConfigurationObject,
HasConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(Template.class);
    @Autowired
    private ProcessorDependencyGraphFactory processorGraphFactory;
    @Autowired
    private ClientHttpRequestFactory httpRequestFactory;
    @Autowired
    private StyleParser styleParser;
    private String reportTemplate;
    private Map<String, Attribute> attributes = new HashMap<String, Attribute>();
    private List<Processor> processors = new ArrayList<Processor>();
    private boolean mapExport;
    private boolean pdfA = false;
    private String jdbcUrl;
    private String jdbcUser;
    private String jdbcPassword;
    private Set<String> jdbcDrivers = Sets.newHashSet();
    private volatile ProcessorDependencyGraph processorGraph;
    private Map<String, String> styles = new HashMap<String, String>();
    private Configuration configuration;
    private AccessAssertion accessAssertion = AlwaysAllowAssertion.INSTANCE;
    private PDFConfig pdfConfig = new PDFConfig();
    private String tableDataKey;
    private String outputFilename;

    public final String getOutputFilename() {
        return this.outputFilename;
    }

    public final void setOutputFilename(String outputFilename) {
        this.outputFilename = outputFilename;
    }

    public PDFConfig getPdfConfig() {
        return this.pdfConfig.getMergedInstance(this.configuration.getPdfConfig());
    }

    public final void setPdfConfig(PDFConfig pdfConfig) {
        this.pdfConfig = pdfConfig;
    }

    public final void printClientConfig(JSONWriter json) throws JSONException {
        json.key("attributes");
        json.array();
        for (Map.Entry<String, Attribute> entry : this.attributes.entrySet()) {
            Attribute attribute = entry.getValue();
            if (attribute.getClass().getAnnotation(InternalAttribute.class) != null) continue;
            json.object();
            attribute.printClientConfig(json, this);
            json.endObject();
        }
        json.endArray();
    }

    public final Map<String, Attribute> getAttributes() {
        return this.attributes;
    }

    public final void setAttributes(Map<String, Attribute> attributes) {
        for (Map.Entry<String, Attribute> entry : attributes.entrySet()) {
            Attribute attribute = entry.getValue();
            if (attribute == null) {
                String msg = "Attribute: '" + entry.getKey() + "' is not a defined attribute";
                LOGGER.error("Error setting the Attributes: {}", (Object)msg);
                throw new IllegalArgumentException(msg);
            }
            attribute.setConfigName(entry.getKey());
        }
        this.attributes = attributes;
    }

    public final String getReportTemplate() {
        return this.reportTemplate;
    }

    public final void setReportTemplate(String reportTemplate) {
        this.reportTemplate = reportTemplate;
    }

    public final List<Processor> getProcessors() {
        return this.processors;
    }

    public final void setProcessors(List<Processor> processors) {
        this.assertProcessors(processors);
        this.processors = processors;
    }

    private void assertProcessors(List<Processor> processorsToCheck) {
        for (Processor entry : processorsToCheck) {
            if (entry != null) continue;
            String msg = "Processor is missing.";
            LOGGER.error("Error in the processors to check while setting the Attributes: {}", (Object)"Processor is missing.");
            throw new IllegalArgumentException("Processor is missing.");
        }
    }

    public final void setTableData(String tableData) {
        this.tableDataKey = tableData;
    }

    public final String getTableDataKey() {
        return this.tableDataKey;
    }

    public final String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public final void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public final Set<String> getJdbcDrivers() {
        return this.jdbcDrivers;
    }

    public final void setJdbcDrivers(Set<String> jdbcDrivers) {
        this.jdbcDrivers = jdbcDrivers;
    }

    public final String getJdbcUser() {
        return this.jdbcUser;
    }

    public final void setJdbcUser(String jdbcUser) {
        this.jdbcUser = jdbcUser;
    }

    public final String getJdbcPassword() {
        return this.jdbcPassword;
    }

    public final void setJdbcPassword(String jdbcPassword) {
        this.jdbcPassword = jdbcPassword;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ProcessorDependencyGraph getProcessorGraph() {
        if (this.processorGraph == null) {
            Template template = this;
            synchronized (template) {
                if (this.processorGraph == null) {
                    HashMap attcls = new HashMap();
                    for (Map.Entry<String, Attribute> attribute : this.attributes.entrySet()) {
                        attcls.put(attribute.getKey(), attribute.getValue().getValueType());
                    }
                    this.processorGraph = this.processorGraphFactory.build(this.processors, attcls);
                }
            }
        }
        return this.processorGraph;
    }

    public final void setStyles(Map<String, String> styles) {
        this.styles = styles;
    }

    @Nonnull
    public final Optional<Style> getStyle(String styleName) {
        String styleRef = this.styles.get(styleName);
        Optional<Object> style = styleRef != null ? this.styleParser.loadStyle(this.getConfiguration(), this.httpRequestFactory, styleRef) : Optional.empty();
        return OptionalUtils.or(style, this.configuration.getStyle(styleName));
    }

    public final Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public final void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void validate(List<Throwable> validationErrors, Configuration config) {
        this.accessAssertion.validate(validationErrors, config);
        int numberOfTableConfigurations = this.tableDataKey == null ? 0 : 1;
        if ((numberOfTableConfigurations += this.jdbcUrl == null ? 0 : 1) > 1) {
            validationErrors.add(new ConfigurationException("Only one of 'iterValue' or 'tableData' or 'jdbcUrl' should be defined."));
        }
        for (Attribute attribute : this.attributes.values()) {
            attribute.validate(validationErrors, config);
        }
        ProcessorDependencyGraphFactory.fillProcessorAttributes(this.processors, this.attributes);
        for (Processor processor : this.processors) {
            processor.validate(validationErrors, config);
        }
        try {
            this.getProcessorGraph();
        }
        catch (RuntimeException t) {
            validationErrors.add(t);
        }
        for (String jdbcDriver : this.getJdbcDrivers()) {
            try {
                Class.forName(jdbcDriver);
            }
            catch (ClassNotFoundException e) {
                validationErrors.add(new ConfigurationException("Unable to load JDBC driver: " + jdbcDriver + " ensure that the web application has the jar on its classpath"));
            }
        }
        if (this.getJdbcUrl() != null) {
            Connection connection = null;
            try {
                connection = this.getJdbcUser() != null ? DriverManager.getConnection(this.getJdbcUrl(), this.getJdbcUser(), this.getJdbcPassword()) : DriverManager.getConnection(this.getJdbcUrl());
            }
            catch (SQLException e) {
                validationErrors.add(e);
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException e) {
                        validationErrors.add(e);
                    }
                }
            }
        }
        if (this.mapExport) {
            int count = 0;
            for (Processor processor : this.getProcessors()) {
                if (processor instanceof CreateMapProcessor) {
                    ++count;
                }
                if (count <= 1) continue;
                break;
            }
            if (count != 1) {
                validationErrors.add(new ConfigurationException("When using MapExport, exactly one CreateMapProcessor should be defined."));
            }
        }
    }

    final void assertAccessible(String name) {
        this.accessAssertion.assertAccess("Template '" + name + "'", this);
    }

    public final void setAccess(List<String> access) {
        RoleAccessAssertion assertion = new RoleAccessAssertion();
        assertion.setRequiredRoles(access);
        this.accessAssertion = assertion;
    }

    public final AccessAssertion getAccessAssertion() {
        return this.accessAssertion;
    }

    public final boolean isMapExport() {
        return this.mapExport;
    }

    public final void setMapExport(boolean mapExport) {
        this.mapExport = mapExport;
    }

    public final boolean isPdfA() {
        return this.pdfA;
    }

    public void setPdfA(boolean pdfA) {
        this.pdfA = pdfA;
    }
}

