/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.config;

import java.util.List;
import java.util.Optional;
import org.mapfish.print.OptionalUtils;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.config.ConfigurationObject;

public class PDFConfig
implements ConfigurationObject {
    private static final String MAPFISH_PRINT = "Mapfish Print";
    private Optional<Boolean> compressed = Optional.empty();
    private Optional<String> title = Optional.empty();
    private Optional<String> author = Optional.empty();
    private Optional<String> subject = Optional.empty();
    private Optional<String> keywords = Optional.empty();
    private Optional<String> creator = Optional.empty();

    PDFConfig getMergedInstance(PDFConfig other) {
        PDFConfig merged = new PDFConfig();
        merged.compressed = OptionalUtils.or(this.compressed, other.compressed);
        merged.title = OptionalUtils.or(this.title, other.title);
        merged.author = OptionalUtils.or(this.author, other.author);
        merged.subject = OptionalUtils.or(this.subject, other.subject);
        merged.keywords = OptionalUtils.or(this.keywords, other.keywords);
        merged.creator = OptionalUtils.or(this.creator, other.creator);
        return merged;
    }

    @Override
    public void validate(List<Throwable> validationErrors, Configuration configuration) {
    }

    public boolean isCompressed() {
        return this.compressed.orElse(false);
    }

    public void setCompressed(boolean compressed) {
        this.compressed = Optional.of(compressed);
    }

    public String getTitle() {
        return this.title.orElse(MAPFISH_PRINT);
    }

    public void setTitle(String title) {
        this.title = Optional.of(title);
    }

    public String getAuthor() {
        return this.author.orElse(MAPFISH_PRINT);
    }

    public void setAuthor(String author) {
        this.author = Optional.of(author);
    }

    public String getSubject() {
        return this.subject.orElse(MAPFISH_PRINT);
    }

    public void setSubject(String subject) {
        this.subject = Optional.of(subject);
    }

    public String getKeywordsAsString() {
        return this.keywords.orElse(MAPFISH_PRINT);
    }

    public void setKeywords(List<String> keywords) {
        StringBuilder builder = new StringBuilder();
        for (String keyword : keywords) {
            if (builder.length() > 0) {
                builder.append(',');
            }
            builder.append(keyword.trim());
        }
        this.keywords = Optional.of(builder.toString());
    }

    public String getCreator() {
        return this.creator.orElse(MAPFISH_PRINT);
    }

    public void setCreator(String creator) {
        this.creator = Optional.of(creator);
    }
}

