/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.config;

import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Set;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.fonts.FontFamily;
import net.sf.jasperreports.engine.fonts.FontUtil;
import net.sf.jasperreports.extensions.ExtensionsEnvironment;
import org.mapfish.print.config.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CustomFontLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomFontLoader.class);

    public CustomFontLoader(Set<String> paths) {
        for (String path : paths) {
            try {
                LOGGER.debug("Loading font {}", (Object)path);
                this.loadFont(path);
            }
            catch (FontFormatException e) {
                throw new ConfigurationException("Font could not be created " + path, e);
            }
            catch (IOException e) {
                throw new ConfigurationException("Can not read font file " + path, e);
            }
        }
        this.registerJasperFonts();
    }

    private void registerJasperFonts() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        List families = ExtensionsEnvironment.getExtensionsRegistry().getExtensions(FontFamily.class);
        for (FontFamily family : families) {
            for (int style = 0; style <= 3; ++style) {
                LOGGER.debug("Registered font family {} style {}", (Object)family.getName(), (Object)style);
                Font font = FontUtil.getInstance((JasperReportsContext)DefaultJasperReportsContext.getInstance()).getAwtFontFromBundles(family.getName(), style, 10.0f, null, true);
                if (font == null || !ge.registerFont(font)) continue;
                LOGGER.info("Font {} from Jasper registered successfully", (Object)font);
            }
        }
    }

    private void loadFont(String path) throws FontFormatException, IOException {
        File fontFile;
        URL url = CustomFontLoader.class.getClassLoader().getResource(path);
        if (url != null) {
            fontFile = new File(url.getFile());
            if (!fontFile.canRead()) {
                throw new ConfigurationException("Can not read font file " + fontFile.getAbsolutePath());
            }
        } else {
            throw new ConfigurationException("Can not read font file " + path);
        }
        Font font = Font.createFont(0, fontFile);
        this.registerFont(font, fontFile);
    }

    private void registerFont(Font font, File fontFile) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        boolean registered = ge.registerFont(font);
        if (!registered) {
            LOGGER.warn("Font {} could not be registered. Is there already a system font with the same name?", (Object)fontFile.getAbsolutePath());
        } else {
            LOGGER.info("Font {} registered successfully", (Object)fontFile.getAbsolutePath());
        }
    }
}

