/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.scribe.property;

import biweekly.ICalDataType;
import biweekly.ICalVersion;
import biweekly.component.ICalComponent;
import biweekly.io.CannotParseException;
import biweekly.io.DataModelConversionException;
import biweekly.io.ParseContext;
import biweekly.io.ParseWarning;
import biweekly.io.TimezoneInfo;
import biweekly.io.WriteContext;
import biweekly.io.json.JCalValue;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.io.xml.XCalElement;
import biweekly.parameter.ICalParameters;
import biweekly.property.DateStart;
import biweekly.property.ICalProperty;
import biweekly.property.RawProperty;
import biweekly.property.RecurrenceProperty;
import biweekly.property.ValuedProperty;
import biweekly.util.ByDay;
import biweekly.util.DayOfWeek;
import biweekly.util.Frequency;
import biweekly.util.ICalDate;
import biweekly.util.ListMultimap;
import biweekly.util.Recurrence;
import biweekly.util.XmlUtils;
import com.github.mangstadt.vinnie.io.VObjectPropertyValues;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Element;

public abstract class RecurrencePropertyScribe<T extends RecurrenceProperty>
extends ICalPropertyScribe<T> {
    private static final String FREQ = "FREQ";
    private static final String UNTIL = "UNTIL";
    private static final String COUNT = "COUNT";
    private static final String INTERVAL = "INTERVAL";
    private static final String BYSECOND = "BYSECOND";
    private static final String BYMINUTE = "BYMINUTE";
    private static final String BYHOUR = "BYHOUR";
    private static final String BYDAY = "BYDAY";
    private static final String BYMONTHDAY = "BYMONTHDAY";
    private static final String BYYEARDAY = "BYYEARDAY";
    private static final String BYWEEKNO = "BYWEEKNO";
    private static final String BYMONTH = "BYMONTH";
    private static final String BYSETPOS = "BYSETPOS";
    private static final String WKST = "WKST";

    public RecurrencePropertyScribe(Class<T> clazz, String propertyName) {
        super(clazz, propertyName);
    }

    @Override
    protected ICalDataType _defaultDataType(ICalVersion version) {
        return ICalDataType.RECUR;
    }

    @Override
    protected String _writeText(T property, WriteContext context) {
        Recurrence recur = (Recurrence)((ValuedProperty)property).getValue();
        if (recur == null) {
            return "";
        }
        switch (context.getVersion()) {
            case V1_0: {
                return this.writeTextV1(property, context);
            }
        }
        return this.writeTextV2(property, context);
    }

    private String writeTextV1(T property, WriteContext context) {
        Recurrence recur = (Recurrence)((ValuedProperty)property).getValue();
        Frequency frequency = recur.getFrequency();
        if (frequency == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Integer interval = recur.getInterval();
        if (interval == null) {
            interval = 1;
        }
        switch (frequency) {
            case YEARLY: {
                if (!recur.getByMonth().isEmpty()) {
                    sb.append("YM").append(interval);
                    for (Integer month : recur.getByMonth()) {
                        sb.append(' ').append(month);
                    }
                } else {
                    sb.append("YD").append(interval);
                    for (Integer day : recur.getByYearDay()) {
                        sb.append(' ').append(day);
                    }
                }
                break;
            }
            case MONTHLY: {
                if (!recur.getByMonthDay().isEmpty()) {
                    sb.append("MD").append(interval);
                    for (Integer day : recur.getByMonthDay()) {
                        sb.append(' ').append(RecurrencePropertyScribe.writeVCalInt(day));
                    }
                } else {
                    sb.append("MP").append(interval);
                    for (ByDay byDay : recur.getByDay()) {
                        DayOfWeek day = byDay.getDay();
                        Integer prefix = byDay.getNum();
                        if (prefix == null) {
                            prefix = 1;
                        }
                        sb.append(' ').append(RecurrencePropertyScribe.writeVCalInt(prefix)).append(' ').append(day.getAbbr());
                    }
                }
                break;
            }
            case WEEKLY: {
                sb.append("W").append(interval);
                for (ByDay byDay : recur.getByDay()) {
                    sb.append(' ').append(byDay.getDay().getAbbr());
                }
                break;
            }
            case DAILY: {
                sb.append("D").append(interval);
                break;
            }
            case HOURLY: {
                sb.append("M").append(interval * 60);
                break;
            }
            case MINUTELY: {
                sb.append("M").append(interval);
                break;
            }
            default: {
                return "";
            }
        }
        Integer count = recur.getCount();
        ICalDate until = recur.getUntil();
        sb.append(' ');
        if (count != null) {
            sb.append('#').append(count);
        } else if (until != null) {
            String dateStr = RecurrencePropertyScribe.date(until, property, context).extended(false).write();
            sb.append(dateStr);
        } else {
            sb.append("#0");
        }
        return sb.toString();
    }

    private String writeTextV2(T property, WriteContext context) {
        ListMultimap<String, Object> components = this.buildComponents(property, context, false);
        return VObjectPropertyValues.writeMultimap(components.getMap());
    }

    @Override
    protected T _parseText(String value, ICalDataType dataType, ICalParameters parameters, ParseContext context) {
        if (value.isEmpty()) {
            return this.newInstance(new Recurrence.Builder((Frequency)null).build());
        }
        switch (context.getVersion()) {
            case V1_0: {
                this.handleVersion1Multivalued(value, dataType, parameters, context);
                return this.parseTextV1(value, dataType, parameters, context);
            }
        }
        return this.parseTextV2(value, dataType, parameters, context);
    }

    private void handleVersion1Multivalued(String value, ICalDataType dataType, ICalParameters parameters, ParseContext context) {
        List<String> rrules = this.splitRRULEValues(value);
        if (rrules.size() == 1) {
            return;
        }
        DataModelConversionException conversionException = new DataModelConversionException(null);
        for (String rrule : rrules) {
            Object property;
            ICalParameters parametersCopy = new ICalParameters(parameters);
            try {
                property = this.parseTextV1(rrule, dataType, parametersCopy, context);
            }
            catch (CannotParseException e) {
                context.getWarnings().add(new ParseWarning.Builder(context).message(e).build());
                property = new RawProperty(this.getPropertyName(context.getVersion()), dataType, rrule);
                ((ICalProperty)property).setParameters(parametersCopy);
            }
            conversionException.getProperties().add((ICalProperty)property);
        }
        throw conversionException;
    }

    private List<String> splitRRULEValues(String value) {
        ArrayList<String> values = new ArrayList<String>();
        Pattern p = Pattern.compile("#\\d+|\\d{8}T\\d{6}Z?");
        Matcher m = p.matcher(value);
        int prevIndex = 0;
        while (m.find()) {
            int end = m.end();
            String subValue = value.substring(prevIndex, end).trim();
            values.add(subValue);
            prevIndex = end;
        }
        String subValue = value.substring(prevIndex).trim();
        if (subValue.length() > 0) {
            values.add(subValue);
        }
        return values;
    }

    private T parseTextV1(String value, ICalDataType dataType, ICalParameters parameters, ParseContext context) {
        Handler<String> handler;
        Frequency frequency;
        final Recurrence.Builder builder = new Recurrence.Builder((Frequency)null);
        List<String> splitValues = Arrays.asList(value.toUpperCase().split("\\s+"));
        String firstToken = splitValues.get(0);
        Pattern p = Pattern.compile("^([A-Z]+)(\\d+)$");
        Matcher m = p.matcher(firstToken);
        if (!m.find()) {
            throw new CannotParseException(40, firstToken);
        }
        String frequencyStr = m.group(1);
        Integer interval = RecurrencePropertyScribe.integerValueOf(m.group(2));
        splitValues = splitValues.subList(1, splitValues.size());
        builder.interval(interval);
        Integer count = null;
        ICalDate until = null;
        if (splitValues.isEmpty()) {
            count = 2;
        } else {
            String lastToken = splitValues.get(splitValues.size() - 1);
            if (lastToken.startsWith("#")) {
                String countStr = lastToken.substring(1);
                count = RecurrencePropertyScribe.integerValueOf(countStr);
                if (count == 0) {
                    count = null;
                }
                splitValues = splitValues.subList(0, splitValues.size() - 1);
            } else {
                try {
                    until = RecurrencePropertyScribe.date(lastToken).parse();
                    splitValues = splitValues.subList(0, splitValues.size() - 1);
                }
                catch (IllegalArgumentException e) {
                    count = 2;
                }
            }
        }
        builder.count(count);
        builder.until(until);
        if ("YD".equals(frequencyStr)) {
            frequency = Frequency.YEARLY;
            handler = new Handler<String>(){

                @Override
                public void handle(String value) {
                    if (value == null) {
                        return;
                    }
                    Integer dayOfYear = RecurrencePropertyScribe.integerValueOf(value);
                    builder.byYearDay(dayOfYear);
                }
            };
        } else if ("YM".equals(frequencyStr)) {
            frequency = Frequency.YEARLY;
            handler = new Handler<String>(){

                @Override
                public void handle(String value) {
                    if (value == null) {
                        return;
                    }
                    Integer month = RecurrencePropertyScribe.integerValueOf(value);
                    builder.byMonth(month);
                }
            };
        } else if ("MD".equals(frequencyStr)) {
            frequency = Frequency.MONTHLY;
            handler = new Handler<String>(){

                @Override
                public void handle(String value) {
                    if (value == null) {
                        return;
                    }
                    try {
                        Integer date = "LD".equals(value) ? -1 : RecurrencePropertyScribe.parseVCalInt(value);
                        builder.byMonthDay(date);
                    }
                    catch (NumberFormatException e) {
                        throw new CannotParseException(40, value);
                    }
                }
            };
        } else if ("MP".equals(frequencyStr)) {
            frequency = Frequency.MONTHLY;
            handler = new Handler<String>(){
                private final List<Integer> nums = new ArrayList<Integer>();
                private final List<DayOfWeek> days = new ArrayList<DayOfWeek>();
                private boolean readNum = false;

                @Override
                public void handle(String value) {
                    if (value == null) {
                        for (Integer num : this.nums) {
                            for (DayOfWeek day : this.days) {
                                builder.byDay(num, day);
                            }
                        }
                        return;
                    }
                    if (value.matches("\\d{4}")) {
                        this.readNum = false;
                        Integer hour = RecurrencePropertyScribe.integerValueOf(value.substring(0, 2));
                        builder.byHour(hour);
                        Integer minute = RecurrencePropertyScribe.integerValueOf(value.substring(2, 4));
                        builder.byMinute(minute);
                        return;
                    }
                    try {
                        Integer curNum = RecurrencePropertyScribe.parseVCalInt(value);
                        if (!this.readNum) {
                            for (Integer num : this.nums) {
                                for (DayOfWeek day : this.days) {
                                    builder.byDay(num, day);
                                }
                            }
                            this.nums.clear();
                            this.days.clear();
                            this.readNum = true;
                        }
                        this.nums.add(curNum);
                    }
                    catch (NumberFormatException e) {
                        this.readNum = false;
                        DayOfWeek day = RecurrencePropertyScribe.this.parseDay(value);
                        this.days.add(day);
                    }
                }
            };
        } else if ("W".equals(frequencyStr)) {
            frequency = Frequency.WEEKLY;
            handler = new Handler<String>(){

                @Override
                public void handle(String value) {
                    if (value == null) {
                        return;
                    }
                    DayOfWeek day = RecurrencePropertyScribe.this.parseDay(value);
                    builder.byDay(day);
                }
            };
        } else if ("D".equals(frequencyStr)) {
            frequency = Frequency.DAILY;
            handler = new Handler<String>(){

                @Override
                public void handle(String value) {
                    if (value == null) {
                        return;
                    }
                    Integer hour = RecurrencePropertyScribe.integerValueOf(value.substring(0, 2));
                    builder.byHour(hour);
                    Integer minute = RecurrencePropertyScribe.integerValueOf(value.substring(2, 4));
                    builder.byMinute(minute);
                }
            };
        } else if ("M".equals(frequencyStr)) {
            frequency = Frequency.MINUTELY;
            handler = new Handler<String>(){

                @Override
                public void handle(String value) {
                }
            };
        } else {
            throw new CannotParseException(41, frequencyStr);
        }
        builder.frequency(frequency);
        for (String splitValue : splitValues) {
            if (splitValue.endsWith("$")) {
                context.addWarning(36, splitValue);
                splitValue = splitValue.substring(0, splitValue.length() - 1);
            }
            handler.handle(splitValue);
        }
        handler.handle(null);
        T property = this.newInstance(builder.build());
        if (until != null) {
            context.addDate(until, (ICalProperty)property, parameters);
        }
        return property;
    }

    private T parseTextV2(String value, ICalDataType dataType, ICalParameters parameters, ParseContext context) {
        Recurrence.Builder builder = new Recurrence.Builder((Frequency)null);
        ListMultimap<String, String> rules = new ListMultimap<String, String>(VObjectPropertyValues.parseMultimap((String)value));
        this.parseFreq(rules, builder, context);
        this.parseUntil(rules, builder, context);
        this.parseCount(rules, builder, context);
        this.parseInterval(rules, builder, context);
        this.parseBySecond(rules, builder, context);
        this.parseByMinute(rules, builder, context);
        this.parseByHour(rules, builder, context);
        this.parseByDay(rules, builder, context);
        this.parseByMonthDay(rules, builder, context);
        this.parseByYearDay(rules, builder, context);
        this.parseByWeekNo(rules, builder, context);
        this.parseByMonth(rules, builder, context);
        this.parseBySetPos(rules, builder, context);
        this.parseWkst(rules, builder, context);
        this.parseXRules(rules, builder);
        T property = this.newInstance(builder.build());
        ICalDate until = ((Recurrence)((ValuedProperty)property).getValue()).getUntil();
        if (until != null) {
            context.addDate(until, (ICalProperty)property, parameters);
        }
        return property;
    }

    private static int parseVCalInt(String value) {
        int negate = 1;
        if (value.endsWith("+")) {
            value = value.substring(0, value.length() - 1);
        } else if (value.endsWith("-")) {
            value = value.substring(0, value.length() - 1);
            negate = -1;
        }
        return Integer.parseInt(value) * negate;
    }

    private static Integer integerValueOf(String value) {
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new CannotParseException(40, value);
        }
    }

    private static String writeVCalInt(Integer value) {
        if (value > 0) {
            return value + "+";
        }
        if (value < 0) {
            return Math.abs(value) + "-";
        }
        return value.toString();
    }

    private DayOfWeek parseDay(String value) {
        DayOfWeek day = DayOfWeek.valueOfAbbr(value);
        if (day == null) {
            throw new CannotParseException(42, value);
        }
        return day;
    }

    @Override
    protected void _writeXml(T property, XCalElement element, WriteContext context) {
        XCalElement recurElement = element.append(this.dataType(property, null));
        Recurrence recur = (Recurrence)((ValuedProperty)property).getValue();
        if (recur == null) {
            return;
        }
        ListMultimap<String, Object> components = this.buildComponents(property, context, true);
        for (Map.Entry<String, List<Object>> entry : components) {
            String name = entry.getKey().toLowerCase();
            for (Object value : entry.getValue()) {
                recurElement.append(name, value.toString());
            }
        }
    }

    @Override
    protected T _parseXml(XCalElement element, ICalParameters parameters, ParseContext context) {
        ICalDataType dataType = this.defaultDataType(context.getVersion());
        XCalElement value = element.child(dataType);
        if (value == null) {
            throw RecurrencePropertyScribe.missingXmlElements(dataType);
        }
        ListMultimap<String, String> rules = new ListMultimap<String, String>();
        for (Element child : XmlUtils.toElementList(value.getElement().getChildNodes())) {
            if (!"urn:ietf:params:xml:ns:icalendar-2.0".equals(child.getNamespaceURI())) continue;
            String name = child.getLocalName().toUpperCase();
            String text = child.getTextContent();
            rules.put(name, text);
        }
        Recurrence.Builder builder = new Recurrence.Builder((Frequency)null);
        this.parseFreq(rules, builder, context);
        this.parseUntil(rules, builder, context);
        this.parseCount(rules, builder, context);
        this.parseInterval(rules, builder, context);
        this.parseBySecond(rules, builder, context);
        this.parseByMinute(rules, builder, context);
        this.parseByHour(rules, builder, context);
        this.parseByDay(rules, builder, context);
        this.parseByMonthDay(rules, builder, context);
        this.parseByYearDay(rules, builder, context);
        this.parseByWeekNo(rules, builder, context);
        this.parseByMonth(rules, builder, context);
        this.parseBySetPos(rules, builder, context);
        this.parseWkst(rules, builder, context);
        this.parseXRules(rules, builder);
        T property = this.newInstance(builder.build());
        ICalDate until = ((Recurrence)((ValuedProperty)property).getValue()).getUntil();
        if (until != null) {
            context.addDate(until, (ICalProperty)property, parameters);
        }
        return property;
    }

    @Override
    protected JCalValue _writeJson(T property, WriteContext context) {
        Recurrence recur = (Recurrence)((ValuedProperty)property).getValue();
        if (recur == null) {
            return JCalValue.object(new ListMultimap<String, Object>(0));
        }
        ListMultimap<String, Object> components = this.buildComponents(property, context, true);
        ListMultimap<String, Object> object = new ListMultimap<String, Object>(components.keySet().size());
        for (Map.Entry<String, List<Object>> entry : components) {
            String key = entry.getKey().toLowerCase();
            object.putAll(key, (Collection<Object>)entry.getValue());
        }
        return JCalValue.object(object);
    }

    @Override
    protected T _parseJson(JCalValue value, ICalDataType dataType, ICalParameters parameters, ParseContext context) {
        Recurrence.Builder builder = new Recurrence.Builder((Frequency)null);
        ListMultimap<String, String> object = value.asObject();
        ListMultimap<String, String> rules = new ListMultimap<String, String>(object.keySet().size());
        for (Map.Entry<String, List<String>> entry : object) {
            String key = entry.getKey().toUpperCase();
            rules.putAll(key, (Collection<String>)entry.getValue());
        }
        this.parseFreq(rules, builder, context);
        this.parseUntil(rules, builder, context);
        this.parseCount(rules, builder, context);
        this.parseInterval(rules, builder, context);
        this.parseBySecond(rules, builder, context);
        this.parseByMinute(rules, builder, context);
        this.parseByHour(rules, builder, context);
        this.parseByDay(rules, builder, context);
        this.parseByMonthDay(rules, builder, context);
        this.parseByYearDay(rules, builder, context);
        this.parseByWeekNo(rules, builder, context);
        this.parseByMonth(rules, builder, context);
        this.parseBySetPos(rules, builder, context);
        this.parseWkst(rules, builder, context);
        this.parseXRules(rules, builder);
        T property = this.newInstance(builder.build());
        ICalDate iCalDate = ((Recurrence)((ValuedProperty)property).getValue()).getUntil();
        if (iCalDate != null) {
            context.addDate(iCalDate, (ICalProperty)property, parameters);
        }
        return property;
    }

    protected abstract T newInstance(Recurrence var1);

    private void parseFreq(ListMultimap<String, String> rules, final Recurrence.Builder builder, final ParseContext context) {
        this.parseFirst(rules, FREQ, new Handler<String>(){

            @Override
            public void handle(String value) {
                value = value.toUpperCase();
                try {
                    builder.frequency(Frequency.valueOf(value));
                }
                catch (IllegalArgumentException e) {
                    context.addWarning(7, RecurrencePropertyScribe.FREQ, value);
                }
            }
        });
    }

    private void parseUntil(ListMultimap<String, String> rules, final Recurrence.Builder builder, final ParseContext context) {
        this.parseFirst(rules, UNTIL, new Handler<String>(){

            @Override
            public void handle(String value) {
                try {
                    builder.until(ICalPropertyScribe.date(value).parse());
                }
                catch (IllegalArgumentException e) {
                    context.addWarning(7, RecurrencePropertyScribe.UNTIL, value);
                }
            }
        });
    }

    private void parseCount(ListMultimap<String, String> rules, final Recurrence.Builder builder, final ParseContext context) {
        this.parseFirst(rules, COUNT, new Handler<String>(){

            @Override
            public void handle(String value) {
                try {
                    builder.count(Integer.valueOf(value));
                }
                catch (NumberFormatException e) {
                    context.addWarning(7, RecurrencePropertyScribe.COUNT, value);
                }
            }
        });
    }

    private void parseInterval(ListMultimap<String, String> rules, final Recurrence.Builder builder, final ParseContext context) {
        this.parseFirst(rules, INTERVAL, new Handler<String>(){

            @Override
            public void handle(String value) {
                try {
                    builder.interval(Integer.valueOf(value));
                }
                catch (NumberFormatException e) {
                    context.addWarning(7, RecurrencePropertyScribe.INTERVAL, value);
                }
            }
        });
    }

    private void parseBySecond(ListMultimap<String, String> rules, final Recurrence.Builder builder, ParseContext context) {
        this.parseIntegerList(BYSECOND, rules, context, new Handler<Integer>(){

            @Override
            public void handle(Integer value) {
                builder.bySecond(value);
            }
        });
    }

    private void parseByMinute(ListMultimap<String, String> rules, final Recurrence.Builder builder, ParseContext context) {
        this.parseIntegerList(BYMINUTE, rules, context, new Handler<Integer>(){

            @Override
            public void handle(Integer value) {
                builder.byMinute(value);
            }
        });
    }

    private void parseByHour(ListMultimap<String, String> rules, final Recurrence.Builder builder, ParseContext context) {
        this.parseIntegerList(BYHOUR, rules, context, new Handler<Integer>(){

            @Override
            public void handle(Integer value) {
                builder.byHour(value);
            }
        });
    }

    private void parseByDay(ListMultimap<String, String> rules, Recurrence.Builder builder, ParseContext context) {
        Pattern p = Pattern.compile("^([-+]?\\d+)?(.*)$");
        for (String value : rules.removeAll(BYDAY)) {
            Matcher m = p.matcher(value);
            if (!m.find()) {
                context.addWarning(7, BYDAY, value);
                continue;
            }
            String dayStr = m.group(2);
            DayOfWeek day = DayOfWeek.valueOfAbbr(dayStr);
            if (day == null) {
                context.addWarning(7, BYDAY, value);
                continue;
            }
            String prefixStr = m.group(1);
            Integer prefix = prefixStr == null ? null : Integer.valueOf(prefixStr);
            builder.byDay(prefix, day);
        }
    }

    private void parseByMonthDay(ListMultimap<String, String> rules, final Recurrence.Builder builder, ParseContext context) {
        this.parseIntegerList(BYMONTHDAY, rules, context, new Handler<Integer>(){

            @Override
            public void handle(Integer value) {
                builder.byMonthDay(value);
            }
        });
    }

    private void parseByYearDay(ListMultimap<String, String> rules, final Recurrence.Builder builder, ParseContext context) {
        this.parseIntegerList(BYYEARDAY, rules, context, new Handler<Integer>(){

            @Override
            public void handle(Integer value) {
                builder.byYearDay(value);
            }
        });
    }

    private void parseByWeekNo(ListMultimap<String, String> rules, final Recurrence.Builder builder, ParseContext context) {
        this.parseIntegerList(BYWEEKNO, rules, context, new Handler<Integer>(){

            @Override
            public void handle(Integer value) {
                builder.byWeekNo(value);
            }
        });
    }

    private void parseByMonth(ListMultimap<String, String> rules, final Recurrence.Builder builder, ParseContext context) {
        this.parseIntegerList(BYMONTH, rules, context, new Handler<Integer>(){

            @Override
            public void handle(Integer value) {
                builder.byMonth(value);
            }
        });
    }

    private void parseBySetPos(ListMultimap<String, String> rules, final Recurrence.Builder builder, ParseContext context) {
        this.parseIntegerList(BYSETPOS, rules, context, new Handler<Integer>(){

            @Override
            public void handle(Integer value) {
                builder.bySetPos(value);
            }
        });
    }

    private void parseWkst(ListMultimap<String, String> rules, final Recurrence.Builder builder, final ParseContext context) {
        this.parseFirst(rules, WKST, new Handler<String>(){

            @Override
            public void handle(String value) {
                DayOfWeek day = DayOfWeek.valueOfAbbr(value);
                if (day == null) {
                    context.addWarning(7, RecurrencePropertyScribe.WKST, value);
                    return;
                }
                builder.workweekStarts(day);
            }
        });
    }

    private void parseXRules(ListMultimap<String, String> rules, Recurrence.Builder builder) {
        for (Map.Entry<String, List<String>> entry : rules) {
            String name = entry.getKey();
            for (String value : entry.getValue()) {
                builder.xrule(name, value);
            }
        }
    }

    private ListMultimap<String, Object> buildComponents(T property, WriteContext context, boolean extended) {
        ICalDate until;
        ListMultimap<String, Object> components = new ListMultimap<String, Object>();
        Recurrence recur = (Recurrence)((ValuedProperty)property).getValue();
        if (recur.getFrequency() != null) {
            components.put(FREQ, recur.getFrequency().name());
        }
        if ((until = recur.getUntil()) != null) {
            components.put(UNTIL, this.writeUntil(until, context, extended));
        }
        if (recur.getCount() != null) {
            components.put(COUNT, recur.getCount());
        }
        if (recur.getInterval() != null) {
            components.put(INTERVAL, recur.getInterval());
        }
        components.putAll(BYSECOND, recur.getBySecond());
        components.putAll(BYMINUTE, recur.getByMinute());
        components.putAll(BYHOUR, recur.getByHour());
        for (ByDay byDay : recur.getByDay()) {
            Integer prefix = byDay.getNum();
            DayOfWeek day = byDay.getDay();
            String value = day.getAbbr();
            if (prefix != null) {
                value = prefix + value;
            }
            components.put(BYDAY, value);
        }
        components.putAll(BYMONTHDAY, recur.getByMonthDay());
        components.putAll(BYYEARDAY, recur.getByYearDay());
        components.putAll(BYWEEKNO, recur.getByWeekNo());
        components.putAll(BYMONTH, recur.getByMonth());
        components.putAll(BYSETPOS, recur.getBySetPos());
        if (recur.getWorkweekStarts() != null) {
            components.put(WKST, recur.getWorkweekStarts().getAbbr());
        }
        for (Map.Entry entry : recur.getXRules().entrySet()) {
            String name = (String)entry.getKey();
            List values = (List)entry.getValue();
            components.putAll(name, values);
        }
        return components;
    }

    private String writeUntil(ICalDate until, WriteContext context, boolean extended) {
        if (!until.hasTime()) {
            return RecurrencePropertyScribe.date(until).extended(extended).write();
        }
        if (RecurrencePropertyScribe.isInObservance(context)) {
            return RecurrencePropertyScribe.date(until).utc(true).extended(extended).write();
        }
        if (context.getVersion() == ICalVersion.V2_0_DEPRECATED) {
            return RecurrencePropertyScribe.date(until).extended(extended).utc(true).write();
        }
        ICalComponent parent = context.getParent();
        if (parent == null) {
            return RecurrencePropertyScribe.date(until).extended(extended).utc(true).write();
        }
        DateStart dtstart = parent.getProperty(DateStart.class);
        if (dtstart == null) {
            return RecurrencePropertyScribe.date(until).extended(extended).utc(true).write();
        }
        TimezoneInfo tzinfo = context.getTimezoneInfo();
        boolean dtstartFloating = tzinfo.isFloating(dtstart);
        if (dtstartFloating) {
            return RecurrencePropertyScribe.date(until).extended(extended).tz(true, null).write();
        }
        return RecurrencePropertyScribe.date(until).extended(extended).utc(true).write();
    }

    private void parseFirst(ListMultimap<String, String> rules, String name, Handler<String> handler) {
        List<String> values = rules.removeAll(name);
        if (values.isEmpty()) {
            return;
        }
        String value = values.get(0);
        handler.handle(value);
    }

    private void parseIntegerList(String name, ListMultimap<String, String> rules, ParseContext context, Handler<Integer> handler) {
        List<String> values = rules.removeAll(name);
        for (String value : values) {
            try {
                handler.handle(Integer.valueOf(value));
            }
            catch (NumberFormatException e) {
                context.addWarning(8, name, value);
            }
        }
    }

    private static interface Handler<T> {
        public void handle(T var1);
    }
}

