/*
 * Decompiled with CFR 0.152.
 */
package com.mancj.materialsearchbar.adapter;

import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Filter;
import android.widget.Filterable;
import java.util.ArrayList;
import java.util.List;

public abstract class SuggestionsAdapter<S, V extends RecyclerView.ViewHolder>
extends RecyclerView.Adapter<V>
implements Filterable {
    protected List<S> suggestions = new ArrayList<S>();
    protected List<S> suggestions_clone = new ArrayList<S>();
    private final LayoutInflater inflater;
    protected int maxSuggestionsCount = 5;

    public SuggestionsAdapter(LayoutInflater inflater) {
        this.inflater = inflater;
    }

    public void addSuggestion(S r) {
        if (this.maxSuggestionsCount <= 0) {
            return;
        }
        if (r == null) {
            return;
        }
        if (!this.suggestions.contains(r)) {
            if (this.suggestions.size() >= this.maxSuggestionsCount) {
                this.suggestions.remove(this.maxSuggestionsCount - 1);
            }
            this.suggestions.add(0, r);
        } else {
            this.suggestions.remove(r);
            this.suggestions.add(0, r);
        }
        this.suggestions_clone = this.suggestions;
        this.notifyDataSetChanged();
    }

    public void setSuggestions(List<S> suggestions) {
        this.suggestions = suggestions;
        this.suggestions_clone = suggestions;
        this.notifyDataSetChanged();
    }

    public void clearSuggestions() {
        this.suggestions.clear();
        this.suggestions_clone = this.suggestions;
        this.notifyDataSetChanged();
    }

    public void deleteSuggestion(int position, S r) {
        if (r == null) {
            return;
        }
        if (this.suggestions.contains(r)) {
            this.notifyItemRemoved(position);
            this.suggestions.remove(r);
            this.suggestions_clone = this.suggestions;
        }
    }

    public List<S> getSuggestions() {
        return this.suggestions;
    }

    public int getMaxSuggestionsCount() {
        return this.maxSuggestionsCount;
    }

    public void setMaxSuggestionsCount(int maxSuggestionsCount) {
        this.maxSuggestionsCount = maxSuggestionsCount;
    }

    protected LayoutInflater getLayoutInflater() {
        return this.inflater;
    }

    public void onBindViewHolder(V holder, int position) {
        this.onBindSuggestionHolder(this.suggestions.get(position), holder, position);
    }

    public abstract void onBindSuggestionHolder(S var1, V var2, int var3);

    public abstract int getSingleViewHeight();

    public int getListHeight() {
        return this.getItemCount() * this.getSingleViewHeight();
    }

    public int getItemCount() {
        return this.suggestions.size();
    }

    public Filter getFilter() {
        return null;
    }

    public static interface OnItemViewClickListener {
        public void OnItemClickListener(int var1, View var2);

        public void OnItemDeleteListener(int var1, View var2);
    }
}

