/*
 * Decompiled with CFR 0.152.
 */
package com.madrapps.eyedropper;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ImageView;

public class EyeDropper {
    private static final Matrix INVERT_MATRIX = new Matrix();
    private static final int NO_COLOR = 0;
    private View targetView;
    private ColorSelectionListener colorListener;
    private int xTouch;
    private int yTouch;
    private SelectionListener selectionListener;

    public EyeDropper(@NonNull View view, @NonNull ColorSelectionListener listener) {
        this.colorListener = listener;
        this.setTargetView(view);
        this.setTouchListener();
    }

    private boolean shouldDrawingCacheBeEnabled(@NonNull View targetView) {
        return !(targetView instanceof ImageView) && !targetView.isDrawingCacheEnabled();
    }

    private void setTouchListener() {
        this.targetView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                int action = event.getActionMasked();
                EyeDropper.this.xTouch = (int)event.getX();
                EyeDropper.this.yTouch = (int)event.getY();
                EyeDropper.this.handleSelectionStart(event, action);
                EyeDropper.this.notifyColorSelected(EyeDropper.this.getColorAtPoint(EyeDropper.this.xTouch, EyeDropper.this.yTouch));
                EyeDropper.this.handleSelectionEnd(event, action);
                return true;
            }
        });
    }

    private void handleSelectionEnd(MotionEvent event, int action) {
        if (this.selectionListener != null && action == 1) {
            this.selectionListener.onSelectionEnd(event);
        }
    }

    private void handleSelectionStart(MotionEvent event, int action) {
        if (this.selectionListener != null && action == 0) {
            this.selectionListener.onSelectionStart(event);
        }
    }

    private int getColorAtPoint(int x, int y) {
        if (this.targetView instanceof ImageView) {
            return this.handleIfImageView(x, y);
        }
        Bitmap drawingCache = this.targetView.getDrawingCache();
        return this.getPixelAtPoint(drawingCache, x, y);
    }

    private int handleIfImageView(int x, int y) {
        ImageView targetImageView = (ImageView)this.targetView;
        Drawable drawable = targetImageView.getDrawable();
        if (drawable instanceof BitmapDrawable) {
            targetImageView.getImageMatrix().invert(INVERT_MATRIX);
            float[] mappedPoints = new float[]{x, y};
            INVERT_MATRIX.mapPoints(mappedPoints);
            Bitmap bitmap = ((BitmapDrawable)drawable).getBitmap();
            return this.getPixelAtPoint(bitmap, (int)mappedPoints[0], (int)mappedPoints[1]);
        }
        return 0;
    }

    private int getPixelAtPoint(Bitmap bitmap, int x, int y) {
        if (this.isValidPoint(x, y, bitmap)) {
            return bitmap.getPixel(x, y);
        }
        return 0;
    }

    private boolean isValidPoint(int x, int y, Bitmap bitmap) {
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        return this.isValidCoordinate(x, width) && this.isValidCoordinate(y, height);
    }

    private boolean isValidCoordinate(int coordinate, int size) {
        return coordinate > 0 && coordinate < size;
    }

    private void notifyColorSelected(int color) {
        if (this.colorListener != null) {
            this.colorListener.onColorSelected(color);
        }
    }

    private void setTargetView(@NonNull View targetView) {
        this.targetView = targetView;
        if (this.shouldDrawingCacheBeEnabled(targetView)) {
            targetView.setDrawingCacheEnabled(true);
            targetView.setDrawingCacheQuality(524288);
        }
    }

    public void setSelectionListener(@NonNull SelectionListener listener) {
        this.selectionListener = listener;
    }

    public static interface ColorSelectionListener {
        public void onColorSelected(@ColorInt int var1);
    }

    public static interface SelectionListener {
        public void onSelectionStart(@NonNull MotionEvent var1);

        public void onSelectionEnd(@NonNull MotionEvent var1);
    }
}

