/*
 * Decompiled with CFR 0.152.
 */
package com.tools.speedlib.views.components.note;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;

public abstract class Note<N extends Note> {
    public static final int INFINITE = -1;
    private float density;
    private Paint paint = new Paint(1);
    private Paint backgroundPaint = new Paint(1);
    private float paddingLeft;
    private float paddingTop;
    private float paddingRight;
    private float paddingBottom;
    private Bitmap backgroundBitmap;
    private Position position = Position.CenterIndicator;
    private Align align = Align.Top;
    private int noteW = 0;
    private int noteH = 0;
    private int containsW = 0;
    private int containsH = 0;
    private float cornersRound = 5.0f;
    private float triangleHeight;

    protected Note(Context context) {
        this.density = context.getResources().getDisplayMetrics().density;
        this.init();
    }

    private void init() {
        this.triangleHeight = this.dpTOpx(12.0f);
        this.backgroundPaint.setColor(Color.parseColor((String)"#d6d7d7"));
        this.setPadding(this.dpTOpx(7.0f), this.dpTOpx(7.0f), this.dpTOpx(7.0f), this.dpTOpx(7.0f));
    }

    public float dpTOpx(float dp) {
        return dp * this.density;
    }

    protected abstract void drawContains(Canvas var1, float var2, float var3);

    public abstract void build(int var1);

    protected void noticeContainsSizeChange(int containsW, int containsH) {
        this.containsW = containsW;
        this.containsH = containsH;
        if (this.align == Align.Top || this.align == Align.Bottom) {
            this.noteW = (int)((float)containsW + this.paddingLeft + this.paddingRight);
            this.noteH = (int)((float)containsH + this.paddingTop + this.paddingBottom + this.triangleHeight);
        } else {
            this.noteW = (int)((float)containsW + this.paddingLeft + this.paddingRight + this.triangleHeight);
            this.noteH = (int)((float)containsH + this.paddingTop + this.paddingBottom);
        }
        this.updateBackgroundBitmap();
    }

    private void updateBackgroundBitmap() {
        this.backgroundBitmap = Bitmap.createBitmap((int)this.noteW, (int)this.noteH, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas c = new Canvas(this.backgroundBitmap);
        if (this.align == Align.Left) {
            this.bitmapLeft(c);
        } else if (this.align == Align.Top) {
            this.bitmapTop(c);
        } else if (this.align == Align.Right) {
            this.bitmapRight(c);
        } else if (this.align == Align.Bottom) {
            this.bitmapBottom(c);
        }
    }

    private void bitmapLeft(Canvas c) {
        RectF rectF = new RectF(0.0f, 0.0f, (float)this.noteW - this.triangleHeight, (float)this.noteH);
        Path p = new Path();
        p.moveTo((float)this.noteW, (float)this.noteH / 2.0f);
        p.lineTo(rectF.right - 1.0f, (float)this.noteH / 2.0f - this.dpTOpx(9.0f));
        p.lineTo(rectF.right - 1.0f, (float)this.noteH / 2.0f + this.dpTOpx(9.0f));
        c.drawPath(p, this.backgroundPaint);
        c.drawRoundRect(rectF, this.cornersRound, this.cornersRound, this.backgroundPaint);
    }

    private void bitmapTop(Canvas c) {
        RectF rectF = new RectF(0.0f, 0.0f, (float)this.noteW, (float)this.noteH - this.triangleHeight);
        Path p = new Path();
        p.moveTo((float)this.noteW / 2.0f, (float)this.noteH);
        p.lineTo((float)this.noteW / 2.0f - this.dpTOpx(9.0f), rectF.bottom - 1.0f);
        p.lineTo((float)this.noteW / 2.0f + this.dpTOpx(9.0f), rectF.bottom - 1.0f);
        c.drawPath(p, this.backgroundPaint);
        c.drawRoundRect(rectF, this.cornersRound, this.cornersRound, this.backgroundPaint);
    }

    private void bitmapRight(Canvas c) {
        RectF rectF = new RectF(0.0f + this.triangleHeight, 0.0f, (float)this.noteW, (float)this.noteH);
        Path p = new Path();
        p.moveTo(0.0f, (float)this.noteH / 2.0f);
        p.lineTo(rectF.left + 1.0f, (float)this.noteH / 2.0f - this.dpTOpx(9.0f));
        p.lineTo(rectF.left + 1.0f, (float)this.noteH / 2.0f + this.dpTOpx(9.0f));
        c.drawPath(p, this.backgroundPaint);
        c.drawRoundRect(rectF, this.cornersRound, this.cornersRound, this.backgroundPaint);
    }

    private void bitmapBottom(Canvas c) {
        RectF rectF = new RectF(0.0f, 0.0f + this.triangleHeight, (float)this.noteW, (float)this.noteH);
        Path p = new Path();
        p.moveTo((float)this.noteW / 2.0f, 0.0f);
        p.lineTo((float)this.noteW / 2.0f - this.dpTOpx(9.0f), rectF.top + 1.0f);
        p.lineTo((float)this.noteW / 2.0f + this.dpTOpx(9.0f), rectF.top + 1.0f);
        c.drawPath(p, this.backgroundPaint);
        c.drawRoundRect(rectF, this.cornersRound, this.cornersRound, this.backgroundPaint);
    }

    public void draw(Canvas canvas, float posX, float posY) {
        switch (this.align) {
            case Left: {
                canvas.drawBitmap(this.backgroundBitmap, posX - (float)this.noteW, posY - (float)this.noteH / 2.0f, this.paint);
                this.drawContains(canvas, posX - (float)this.noteW + this.paddingLeft, posY - (float)this.noteH / 2.0f + this.paddingTop);
                break;
            }
            case Top: {
                canvas.drawBitmap(this.backgroundBitmap, posX - (float)this.noteW / 2.0f, posY - (float)this.noteH, this.paint);
                this.drawContains(canvas, posX - (float)this.containsW / 2.0f, posY - (float)this.noteH + this.paddingTop);
                break;
            }
            case Right: {
                canvas.drawBitmap(this.backgroundBitmap, posX, posY - (float)this.noteH / 2.0f, this.paint);
                this.drawContains(canvas, posX + this.triangleHeight + this.paddingLeft, posY - (float)this.noteH / 2.0f + this.paddingTop);
                break;
            }
            case Bottom: {
                canvas.drawBitmap(this.backgroundBitmap, posX - (float)this.noteW / 2.0f, posY, this.paint);
                this.drawContains(canvas, posX - (float)this.containsW / 2.0f, posY + this.triangleHeight + this.paddingTop);
            }
        }
    }

    public int getBackgroundColor() {
        return this.backgroundPaint.getColor();
    }

    public N setBackgroundColor(int backgroundColor) {
        this.backgroundPaint.setColor(backgroundColor);
        return (N)this;
    }

    public float getCornersRound() {
        return this.cornersRound;
    }

    public N setCornersRound(float cornersRound) {
        if (cornersRound < 0.0f) {
            throw new IllegalArgumentException("cornersRound cannot be negative");
        }
        this.cornersRound = cornersRound;
        return (N)this;
    }

    public Align getAlign() {
        return this.align;
    }

    public N setAlign(Align align) {
        this.align = align;
        return (N)this;
    }

    public Position getPosition() {
        return this.position;
    }

    public N setPosition(Position position) {
        this.position = position;
        return (N)this;
    }

    public N setPadding(float left, float top, float right, float bottom) {
        this.paddingLeft = left;
        this.paddingTop = top;
        this.paddingRight = right;
        this.paddingBottom = bottom;
        this.noticeContainsSizeChange(this.containsW, this.containsH);
        return (N)this;
    }

    public static enum Align {
        Left,
        Top,
        Right,
        Bottom;

    }

    public static enum Position {
        TopIndicator,
        CenterIndicator,
        CenterSpeedometer;

    }
}

