/*
 * Decompiled with CFR 0.152.
 */
package com.tools.speedlib.views.components.Indicators;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.RectF;
import com.tools.speedlib.views.components.Indicators.Indicator;

public class ImageIndicator
extends Indicator<ImageIndicator> {
    private Bitmap bitmapIndicator;
    private int width;
    private int height;
    private RectF bitmapRect = new RectF();

    public ImageIndicator(Context context, int resource) {
        this(context, BitmapFactory.decodeResource((Resources)context.getResources(), (int)resource));
    }

    public ImageIndicator(Context context, int resource, int width, int height) {
        this(context, BitmapFactory.decodeResource((Resources)context.getResources(), (int)resource), width, height);
    }

    public ImageIndicator(Context context, Bitmap bitmapIndicator) {
        this(context, bitmapIndicator, bitmapIndicator.getWidth(), bitmapIndicator.getHeight());
    }

    public ImageIndicator(Context context, Bitmap bitmapIndicator, int width, int height) {
        super(context);
        this.bitmapIndicator = bitmapIndicator;
        this.width = width;
        this.height = height;
        if (width <= 0) {
            throw new IllegalArgumentException("width must be bigger than 0");
        }
        if (height <= 0) {
            throw new IllegalArgumentException("height must be bigger than 0");
        }
    }

    @Override
    protected float getDefaultIndicatorWidth() {
        return 0.0f;
    }

    @Override
    public void draw(Canvas canvas, float degree) {
        canvas.save();
        canvas.rotate(90.0f + degree, this.getCenterX(), this.getCenterY());
        this.bitmapRect.set(this.getCenterX() - (float)this.width / 2.0f, this.getCenterY() - (float)this.height / 2.0f, this.getCenterX() + (float)this.width / 2.0f, this.getCenterY() + (float)this.height / 2.0f);
        canvas.drawBitmap(this.bitmapIndicator, null, this.bitmapRect, this.indicatorPaint);
        canvas.restore();
    }

    @Override
    protected void updateIndicator() {
    }

    @Override
    protected void setWithEffects(boolean withEffects) {
    }
}

