/*
 * Decompiled with CFR 0.152.
 */
package com.tools.speedlib.views.base;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import com.tools.speedlib.R;
import com.tools.speedlib.views.base.Gauge;
import com.tools.speedlib.views.base.SpeedometerDefault;
import com.tools.speedlib.views.components.Indicators.Indicator;
import com.tools.speedlib.views.components.Indicators.NoIndicator;
import com.tools.speedlib.views.components.note.Note;
import java.util.ArrayList;

public abstract class Speedometer
extends Gauge {
    private Indicator indicator;
    private Paint circleBackPaint = new Paint(1);
    private float speedometerWidth = this.dpTOpx(30.0f);
    private int markColor = -1;
    private int lowSpeedColor = -16711936;
    private int mediumSpeedColor = -256;
    private int highSpeedColor = -65536;
    private int backgroundCircleColor = -1;
    private int startDegree = 135;
    private int endDegree = 405;
    private float degree = this.startDegree;
    private ArrayList<Note> notes = new ArrayList();
    private Mode speedometerMode = Mode.NORMAL;
    private int cutPadding = 0;

    public Speedometer(Context context) {
        this(context, null);
    }

    public Speedometer(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public Speedometer(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
        this.initAttributeSet(context, attrs);
        this.initAttributeValue();
    }

    private void init() {
        this.indicator = new NoIndicator(this.getContext());
        SpeedometerDefault speedometerDefault = this.getSpeedometerDefault();
        if (speedometerDefault != null) {
            if (speedometerDefault.speedometerMode != null) {
                this.setSpeedometerMode(speedometerDefault.speedometerMode);
            }
            if (speedometerDefault.indicator != null) {
                this.indicator = speedometerDefault.indicator;
            }
            if (speedometerDefault.speedometerWidth >= 0.0f) {
                this.speedometerWidth = speedometerDefault.speedometerWidth;
            }
            this.markColor = speedometerDefault.markColor;
            this.lowSpeedColor = speedometerDefault.lowSpeedColor;
            this.mediumSpeedColor = speedometerDefault.mediumSpeedColor;
            this.highSpeedColor = speedometerDefault.highSpeedColor;
            this.backgroundCircleColor = speedometerDefault.backgroundCircleColor;
            this.startDegree = speedometerDefault.startDegree;
            this.endDegree = speedometerDefault.endDegree;
        }
    }

    private void initAttributeSet(Context context, AttributeSet attrs) {
        if (attrs == null) {
            return;
        }
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.Speedometer, 0, 0);
        int mode = a.getInt(R.styleable.Speedometer_sv_speedometerMode, -1);
        if (mode != -1 && mode != 0) {
            this.setSpeedometerMode(Mode.values()[mode]);
        }
        this.markColor = a.getColor(R.styleable.Speedometer_sv_markColor, this.markColor);
        this.lowSpeedColor = a.getColor(R.styleable.Speedometer_sv_lowSpeedColor, this.lowSpeedColor);
        this.mediumSpeedColor = a.getColor(R.styleable.Speedometer_sv_mediumSpeedColor, this.mediumSpeedColor);
        this.highSpeedColor = a.getColor(R.styleable.Speedometer_sv_highSpeedColor, this.highSpeedColor);
        this.backgroundCircleColor = a.getColor(R.styleable.Speedometer_sv_backgroundCircleColor, this.backgroundCircleColor);
        this.speedometerWidth = a.getDimension(R.styleable.Speedometer_sv_speedometerWidth, this.speedometerWidth);
        this.startDegree = a.getInt(R.styleable.Speedometer_sv_startDegree, this.startDegree);
        this.endDegree = a.getInt(R.styleable.Speedometer_sv_endDegree, this.endDegree);
        this.setIndicatorWidth(a.getDimension(R.styleable.Speedometer_sv_indicatorWidth, this.indicator.getIndicatorWidth()));
        this.cutPadding = (int)a.getDimension(R.styleable.Speedometer_sv_cutPadding, (float)this.cutPadding);
        int ind = a.getInt(R.styleable.Speedometer_sv_indicator, -1);
        if (ind != -1) {
            this.setIndicator(Indicator.Indicators.values()[ind]);
        }
        this.setIndicatorColor(a.getColor(R.styleable.Speedometer_sv_indicatorColor, this.indicator.getIndicatorColor()));
        this.degree = this.startDegree;
        a.recycle();
        this.checkStartAndEndDegree();
    }

    private void initAttributeValue() {
        this.circleBackPaint.setColor(this.backgroundCircleColor);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int size = Math.min(this.getMeasuredWidth(), this.getMeasuredHeight());
        int newW = size / this.speedometerMode.divWidth;
        int newH = size / this.speedometerMode.divHeight;
        if (this.speedometerMode.isHalf) {
            if (this.speedometerMode.divWidth == 2) {
                newW += this.cutPadding;
            } else {
                newH += this.cutPadding;
            }
        }
        this.setMeasuredDimension(newW, newH);
    }

    @Override
    protected void onSizeChanged(int w, int h, int oldW, int oldH) {
        super.onSizeChanged(w, h, oldW, oldH);
        this.indicator.onSizeChange(this);
    }

    private void checkStartAndEndDegree() {
        if (this.startDegree < 0) {
            throw new IllegalArgumentException("StartDegree can't be Negative");
        }
        if (this.endDegree < 0) {
            throw new IllegalArgumentException("EndDegree can't be Negative");
        }
        if (this.startDegree >= this.endDegree) {
            throw new IllegalArgumentException("EndDegree must be bigger than StartDegree !");
        }
        if (this.endDegree - this.startDegree > 360) {
            throw new IllegalArgumentException("(EndDegree - StartDegree) must be smaller than 360 !");
        }
        if (this.startDegree < this.speedometerMode.minDegree) {
            throw new IllegalArgumentException("StartDegree must be bigger than " + this.speedometerMode.minDegree + " in " + (Object)((Object)this.speedometerMode) + " Mode !");
        }
        if (this.endDegree > this.speedometerMode.maxDegree) {
            throw new IllegalArgumentException("EndDegree must be smaller than " + this.speedometerMode.maxDegree + " in " + (Object)((Object)this.speedometerMode) + " Mode !");
        }
    }

    protected abstract SpeedometerDefault getSpeedometerDefault();

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.degree = this.getDegreeAtSpeed(this.getCorrectSpeed());
    }

    protected void drawIndicator(Canvas canvas) {
        this.indicator.draw(canvas, this.degree);
    }

    protected void drawNotes(Canvas canvas) {
        for (Note note : this.notes) {
            if (note.getPosition() == Note.Position.CenterSpeedometer) {
                note.draw(canvas, (float)this.getWidth() * 0.5f, (float)this.getHeight() * 0.5f);
                continue;
            }
            float y = 0.0f;
            if (note.getPosition() == Note.Position.CenterIndicator) {
                y = (float)this.getHeightPa() * 0.25f + (float)this.getPadding();
            } else if (note.getPosition() == Note.Position.TopIndicator) {
                y = this.getPadding();
            }
            canvas.save();
            canvas.rotate(90.0f + this.getDegree(), (float)this.getWidth() * 0.5f, (float)this.getHeight() * 0.5f);
            canvas.rotate(-(90.0f + this.getDegree()), (float)this.getWidth() * 0.5f, y);
            note.draw(canvas, (float)this.getWidth() * 0.5f, y);
            canvas.restore();
        }
    }

    @Override
    protected final Canvas createBackgroundBitmapCanvas() {
        if (this.getWidth() == 0 || this.getHeight() == 0) {
            return new Canvas();
        }
        this.backgroundBitmap = Bitmap.createBitmap((int)this.getSize(), (int)this.getSize(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(this.backgroundBitmap);
        canvas.drawCircle((float)this.getSize() * 0.5f, (float)this.getSize() * 0.5f, (float)this.getSize() * 0.5f - (float)this.getPadding(), this.circleBackPaint);
        return canvas;
    }

    protected float getDegree() {
        return this.degree;
    }

    protected float getDegreeAtSpeed(float speed) {
        return (speed - (float)this.getMinSpeed()) * (float)(this.endDegree - this.startDegree) / (float)(this.getMaxSpeed() - this.getMinSpeed()) + (float)this.startDegree;
    }

    protected float getSpeedAtDegree(float degree) {
        return (degree - (float)this.startDegree) * (float)(this.getMaxSpeed() - this.getMinSpeed()) / (float)(this.endDegree - this.startDegree) + (float)this.getMinSpeed();
    }

    public int getIndicatorColor() {
        return this.indicator.getIndicatorColor();
    }

    public void setIndicatorColor(int indicatorColor) {
        this.indicator.noticeIndicatorColorChange(indicatorColor);
        if (!this.isAttachedToWindow()) {
            return;
        }
        this.invalidate();
    }

    public int getMarkColor() {
        return this.markColor;
    }

    public void setMarkColor(int markColor) {
        this.markColor = markColor;
        if (!this.isAttachedToWindow()) {
            return;
        }
        this.invalidate();
    }

    public int getLowSpeedColor() {
        return this.lowSpeedColor;
    }

    public void setLowSpeedColor(int lowSpeedColor) {
        this.lowSpeedColor = lowSpeedColor;
        if (!this.isAttachedToWindow()) {
            return;
        }
        this.updateBackgroundBitmap();
        this.invalidate();
    }

    public int getMediumSpeedColor() {
        return this.mediumSpeedColor;
    }

    public void setMediumSpeedColor(int mediumSpeedColor) {
        this.mediumSpeedColor = mediumSpeedColor;
        if (!this.isAttachedToWindow()) {
            return;
        }
        this.updateBackgroundBitmap();
        this.invalidate();
    }

    public int getHighSpeedColor() {
        return this.highSpeedColor;
    }

    public void setHighSpeedColor(int highSpeedColor) {
        this.highSpeedColor = highSpeedColor;
        if (!this.isAttachedToWindow()) {
            return;
        }
        this.updateBackgroundBitmap();
        this.invalidate();
    }

    public int getBackgroundCircleColor() {
        return this.backgroundCircleColor;
    }

    public void setBackgroundCircleColor(int backgroundCircleColor) {
        this.backgroundCircleColor = backgroundCircleColor;
        this.circleBackPaint.setColor(backgroundCircleColor);
        if (!this.isAttachedToWindow()) {
            return;
        }
        this.updateBackgroundBitmap();
        this.invalidate();
    }

    public float getSpeedometerWidth() {
        return this.speedometerWidth;
    }

    public void setSpeedometerWidth(float speedometerWidth) {
        this.speedometerWidth = speedometerWidth;
        if (!this.isAttachedToWindow()) {
            return;
        }
        this.indicator.noticeSpeedometerWidthChange(speedometerWidth);
        this.updateBackgroundBitmap();
        this.invalidate();
    }

    protected int getStartDegree() {
        return this.startDegree;
    }

    public void setStartDegree(int startDegree) {
        this.setStartEndDegree(startDegree, this.endDegree);
    }

    protected int getEndDegree() {
        return this.endDegree;
    }

    public void setEndDegree(int endDegree) {
        this.setStartEndDegree(this.startDegree, endDegree);
    }

    public void setStartEndDegree(int startDegree, int endDegree) {
        this.startDegree = startDegree;
        this.endDegree = endDegree;
        this.checkStartAndEndDegree();
        this.cancelSpeedAnimator();
        this.degree = this.getDegreeAtSpeed(this.getSpeed());
        if (!this.isAttachedToWindow()) {
            return;
        }
        this.updateBackgroundBitmap();
        this.tremble();
        this.invalidate();
    }

    public int getSize() {
        if (this.speedometerMode == Mode.NORMAL) {
            return this.getWidth();
        }
        if (this.speedometerMode.isHalf) {
            return Math.max(this.getWidth(), this.getHeight());
        }
        return Math.max(this.getWidth(), this.getHeight()) * 2 - this.cutPadding * 2;
    }

    public int getSizePa() {
        return this.getSize() - this.getPadding() * 2;
    }

    public void addNote(Note note) {
        this.addNote(note, 3000L);
    }

    public void addNote(final Note note, long showTimeMillisecond) {
        note.build(this.getWidth());
        this.notes.add(note);
        if (showTimeMillisecond == -1L) {
            return;
        }
        this.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (Speedometer.this.isAttachedToWindow()) {
                    Speedometer.this.notes.remove(note);
                    Speedometer.this.postInvalidate();
                }
            }
        }, showTimeMillisecond);
        this.invalidate();
    }

    public void removeAllNotes() {
        this.notes.clear();
        this.invalidate();
    }

    protected void drawDefMinMaxSpeedPosition(Canvas c) {
        if (this.getStartDegree() % 360 <= 90) {
            this.textPaint.setTextAlign(Paint.Align.RIGHT);
        } else if (this.getStartDegree() % 360 <= 180) {
            this.textPaint.setTextAlign(Paint.Align.LEFT);
        } else if (this.getStartDegree() % 360 <= 270) {
            this.textPaint.setTextAlign(Paint.Align.CENTER);
        } else {
            this.textPaint.setTextAlign(Paint.Align.RIGHT);
        }
        c.save();
        c.rotate((float)this.getStartDegree() + 90.0f, (float)this.getSize() * 0.5f, (float)this.getSize() * 0.5f);
        c.rotate(-((float)this.getStartDegree() + 90.0f), (float)this.getSizePa() * 0.5f - this.textPaint.getTextSize() + (float)this.getPadding(), this.textPaint.getTextSize() + (float)this.getPadding());
        c.drawText(this.getMinSpeedText(), (float)this.getSizePa() * 0.5f - this.textPaint.getTextSize() + (float)this.getPadding(), this.textPaint.getTextSize() + (float)this.getPadding(), (Paint)this.textPaint);
        c.restore();
        if (this.getEndDegree() % 360 <= 90) {
            this.textPaint.setTextAlign(Paint.Align.RIGHT);
        } else if (this.getEndDegree() % 360 <= 180) {
            this.textPaint.setTextAlign(Paint.Align.LEFT);
        } else if (this.getEndDegree() % 360 <= 270) {
            this.textPaint.setTextAlign(Paint.Align.CENTER);
        } else {
            this.textPaint.setTextAlign(Paint.Align.RIGHT);
        }
        c.save();
        c.rotate((float)this.getEndDegree() + 90.0f, (float)this.getSize() * 0.5f, (float)this.getSize() * 0.5f);
        c.rotate(-((float)this.getEndDegree() + 90.0f), (float)this.getSizePa() * 0.5f + this.textPaint.getTextSize() + (float)this.getPadding(), this.textPaint.getTextSize() + (float)this.getPadding());
        c.drawText(this.getMaxSpeedText(), (float)this.getSizePa() * 0.5f + this.textPaint.getTextSize() + (float)this.getPadding(), this.textPaint.getTextSize() + (float)this.getPadding(), (Paint)this.textPaint);
        c.restore();
    }

    public float getIndicatorWidth() {
        return this.indicator.getIndicatorWidth();
    }

    public void setIndicatorWidth(float indicatorWidth) {
        this.indicator.noticeIndicatorWidthChange(indicatorWidth);
        if (!this.isAttachedToWindow()) {
            return;
        }
        this.invalidate();
    }

    protected void indicatorEffects(boolean withEffects) {
        this.indicator.withEffects(withEffects);
    }

    public void setIndicator(Indicator.Indicators indicator) {
        this.indicator = Indicator.createIndicator(this.getContext(), indicator);
        if (!this.isAttachedToWindow()) {
            return;
        }
        this.indicator.setTargetSpeedometer(this);
        this.invalidate();
    }

    public void setIndicator(Indicator indicator) {
        this.indicator = indicator;
        if (!this.isAttachedToWindow()) {
            return;
        }
        this.indicator.setTargetSpeedometer(this);
        this.invalidate();
    }

    protected final float getViewCenterX() {
        switch (this.speedometerMode) {
            case LEFT: 
            case TOP_LEFT: 
            case BOTTOM_LEFT: {
                return (float)this.getSize() * 0.5f - (float)this.getWidth() * 0.5f;
            }
            case RIGHT: 
            case TOP_RIGHT: 
            case BOTTOM_RIGHT: {
                return (float)this.getSize() * 0.5f + (float)this.getWidth() * 0.5f;
            }
        }
        return (float)this.getSize() * 0.5f;
    }

    protected final float getViewCenterY() {
        switch (this.speedometerMode) {
            case TOP_LEFT: 
            case TOP_RIGHT: 
            case TOP: {
                return (float)this.getSize() * 0.5f - (float)this.getHeight() * 0.5f;
            }
            case BOTTOM_LEFT: 
            case BOTTOM_RIGHT: 
            case BOTTOM: {
                return (float)this.getSize() * 0.5f + (float)this.getHeight() * 0.5f;
            }
        }
        return (float)this.getSize() * 0.5f;
    }

    protected final float getViewLeft() {
        return this.getViewCenterX() - (float)this.getWidth() * 0.5f;
    }

    protected final float getViewTop() {
        return this.getViewCenterY() - (float)this.getHeight() * 0.5f;
    }

    protected final float getViewRight() {
        return this.getViewCenterX() + (float)this.getWidth() * 0.5f;
    }

    protected final float getViewBottom() {
        return this.getViewCenterY() + (float)this.getHeight() * 0.5f;
    }

    public void setSpeedometerMode(Mode speedometerMode) {
        this.speedometerMode = speedometerMode;
        if (speedometerMode != Mode.NORMAL) {
            this.startDegree = speedometerMode.minDegree;
            this.endDegree = speedometerMode.maxDegree;
        }
        this.translatedDx = speedometerMode.isRight() ? (float)(-this.getSize()) * 0.5f + (float)this.cutPadding : 0.0f;
        this.translatedDy = speedometerMode.isBottom() ? (float)(-this.getSize()) * 0.5f + (float)this.cutPadding : 0.0f;
        this.cancelSpeedAnimator();
        this.degree = this.getDegreeAtSpeed(this.getSpeed());
        this.indicator.onSizeChange(this);
        if (!this.isAttachedToWindow()) {
            return;
        }
        this.requestLayout();
        this.updateBackgroundBitmap();
        this.tremble();
        this.invalidate();
    }

    public static enum Mode {
        NORMAL(0, 720, false, 1, 1),
        LEFT(90, 270, true, 2, 1),
        TOP(180, 360, true, 1, 2),
        RIGHT(270, 450, true, 2, 1),
        BOTTOM(0, 180, true, 1, 2),
        TOP_LEFT(180, 270, false, 1, 1),
        TOP_RIGHT(270, 360, false, 1, 1),
        BOTTOM_RIGHT(0, 90, false, 1, 1),
        BOTTOM_LEFT(90, 180, false, 1, 1);

        final int minDegree;
        final int maxDegree;
        final boolean isHalf;
        final int divWidth;
        final int divHeight;

        private Mode(int minDegree, int maxDegree, boolean isHalf, int divWidth, int divHeight) {
            this.minDegree = minDegree;
            this.maxDegree = maxDegree;
            this.isHalf = isHalf;
            this.divWidth = divWidth;
            this.divHeight = divHeight;
        }

        public boolean isLeft() {
            return this == LEFT || this == TOP_LEFT || this == BOTTOM_LEFT;
        }

        public boolean isTop() {
            return this == TOP || this == TOP_LEFT || this == TOP_RIGHT;
        }

        public boolean isRight() {
            return this == RIGHT || this == TOP_RIGHT || this == BOTTOM_RIGHT;
        }

        public boolean isBottom() {
            return this == BOTTOM || this == BOTTOM_LEFT || this == BOTTOM_RIGHT;
        }
    }
}

