/*
 * Decompiled with CFR 0.152.
 */
package com.tools.speedlib.listener.impl;

import android.os.Handler;
import android.os.Message;
import com.tools.speedlib.listener.ProgressListener;
import com.tools.speedlib.listener.impl.handler.ProgressHandler;
import com.tools.speedlib.listener.impl.model.ProgressModel;

public abstract class UIProgressListener
implements ProgressListener {
    private int id;
    private boolean isFirst = false;
    private long updateTime = System.currentTimeMillis();
    private boolean isCancled = false;
    private Handler mHandler;

    public UIProgressListener() {
        this.id = this.id;
        this.mHandler = new UIHandler(this, this.id);
    }

    @Override
    public void onProgress(long bytesWrite, long contentLength, boolean done) {
        if (this.isCancled()) {
            return;
        }
        if (!this.isFirst) {
            this.isFirst = true;
            this.updateTime = System.currentTimeMillis();
            Message start = Message.obtain();
            start.obj = new ProgressModel(bytesWrite, contentLength, done);
            start.what = 2;
            this.mHandler.sendMessage(start);
        }
        if (System.currentTimeMillis() - this.updateTime >= 1000L) {
            this.updateTime = System.currentTimeMillis();
            Message message = Message.obtain();
            message.obj = new ProgressModel(bytesWrite, contentLength, done);
            message.what = 1;
            this.mHandler.sendMessage(message);
        }
        if (done) {
            Message finish = Message.obtain();
            finish.obj = new ProgressModel(bytesWrite, contentLength, done);
            finish.what = 3;
            this.mHandler.sendMessage(finish);
        }
    }

    @Override
    public boolean isCancled() {
        return this.isCancled;
    }

    @Override
    public void setCancled() {
        this.isCancled = true;
    }

    public abstract void onUIProgress(int var1, long var2, long var4, boolean var6);

    public void onUIStart(int taskId, long currentBytes, long contentLength, boolean done) {
    }

    public void onUIFinish(int taskId, long currentBytes, long contentLength, boolean done) {
    }

    private static class UIHandler
    extends ProgressHandler {
        private int id;

        public UIHandler(UIProgressListener uiProgressListener, int id) {
            super(uiProgressListener);
            this.id = id;
        }

        @Override
        public void start(UIProgressListener uiProgressListener, long currentBytes, long contentLength, boolean done) {
            if (uiProgressListener != null) {
                uiProgressListener.onUIStart(this.id, currentBytes, contentLength, done);
            }
        }

        @Override
        public void progress(UIProgressListener uiProgressListener, long currentBytes, long contentLength, boolean done) {
            if (uiProgressListener != null) {
                uiProgressListener.onUIProgress(this.id, currentBytes, contentLength, done);
            }
        }

        @Override
        public void finish(UIProgressListener uiProgressListener, long currentBytes, long contentLength, boolean done) {
            if (uiProgressListener != null) {
                uiProgressListener.onUIFinish(this.id, currentBytes, contentLength, done);
            }
        }
    }
}

