/*
 * Decompiled with CFR 0.152.
 */
package com.zhihu.matisse.internal.ui;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.graphics.Point;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.Toast;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import com.davemorrissey.labs.subscaleview.SubsamplingScaleImageView;
import com.zhihu.matisse.R;
import com.zhihu.matisse.internal.entity.Item;
import com.zhihu.matisse.internal.entity.SelectionSpec;
import com.zhihu.matisse.internal.utils.PhotoMetadataUtils;
import com.zhihu.matisse.listener.OnFragmentInteractionListener;
import it.sephiroth.android.library.imagezoom.ImageViewTouch;
import it.sephiroth.android.library.imagezoom.ImageViewTouchBase;

public class PreviewItemFragment
extends Fragment {
    private static final String ARGS_ITEM = "args_item";
    private OnFragmentInteractionListener mListener;

    public static PreviewItemFragment newInstance(Item item) {
        PreviewItemFragment fragment = new PreviewItemFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable(ARGS_ITEM, (Parcelable)item);
        fragment.setArguments(bundle);
        return fragment;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_preview_item, container, false);
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        final Item item = (Item)this.getArguments().getParcelable(ARGS_ITEM);
        if (item == null) {
            return;
        }
        View videoPlayButton = view.findViewById(R.id.video_play_button);
        if (item.isVideo()) {
            videoPlayButton.setVisibility(0);
            videoPlayButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    Intent intent = new Intent("android.intent.action.VIEW");
                    intent.setDataAndType(item.uri, "video/*");
                    try {
                        PreviewItemFragment.this.startActivity(intent);
                    }
                    catch (ActivityNotFoundException e) {
                        Toast.makeText((Context)PreviewItemFragment.this.getContext(), (int)R.string.error_no_video_activity, (int)0).show();
                    }
                }
            });
        } else {
            videoPlayButton.setVisibility(8);
        }
        SubsamplingScaleImageView imageLong = (SubsamplingScaleImageView)view.findViewById(R.id.image_view_long);
        ImageViewTouch image = (ImageViewTouch)view.findViewById(R.id.image_view);
        if (!item.isGif()) {
            imageLong.setExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
            imageLong.setVisibility(0);
            image.setVisibility(8);
            SelectionSpec.getInstance().imageEngine.loadLargeImage(this.getContext(), 0, 0, imageLong, item.getContentUri());
        } else {
            Point size = PhotoMetadataUtils.getBitmapSize(item.getContentUri(), (Activity)this.getActivity());
            image.setVisibility(0);
            imageLong.setVisibility(8);
            image.setDisplayType(ImageViewTouchBase.DisplayType.FIT_TO_SCREEN);
            image.setSingleTapListener(new ImageViewTouch.OnImageViewTouchSingleTapListener(){

                public void onSingleTapConfirmed() {
                    if (PreviewItemFragment.this.mListener != null) {
                        PreviewItemFragment.this.mListener.onClick();
                    }
                }
            });
            if (item.isGif()) {
                SelectionSpec.getInstance().imageEngine.loadGifImage(this.getContext(), size.x, size.y, (ImageView)image, item.getContentUri());
            } else {
                SelectionSpec.getInstance().imageEngine.loadImage(this.getContext(), size.x, size.y, (ImageView)image, item.getContentUri());
            }
        }
    }

    public void resetView() {
        if (this.getView() != null) {
            ((ImageViewTouch)this.getView().findViewById(R.id.image_view)).resetMatrix();
        }
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        if (!(context instanceof OnFragmentInteractionListener)) {
            throw new RuntimeException(context.toString() + " must implement OnFragmentInteractionListener");
        }
        this.mListener = (OnFragmentInteractionListener)context;
    }

    public void onDetach() {
        super.onDetach();
        this.mListener = null;
    }
}

