/*
 * Decompiled with CFR 0.152.
 */
package com.zhihu.matisse.internal.entity;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import com.zhihu.matisse.R;

public class Album
implements Parcelable {
    public static final Parcelable.Creator<Album> CREATOR = new Parcelable.Creator<Album>(){

        @Nullable
        public Album createFromParcel(Parcel source) {
            return new Album(source);
        }

        public Album[] newArray(int size) {
            return new Album[size];
        }
    };
    public static final String ALBUM_ID_ALL = String.valueOf(-1);
    public static final String ALBUM_NAME_ALL = "All";
    private final String mId;
    private final Uri mCoverUri;
    private final String mDisplayName;
    private long mCount;

    public Album(String id, Uri coverUri, String albumName, long count) {
        this.mId = id;
        this.mCoverUri = coverUri;
        this.mDisplayName = albumName;
        this.mCount = count;
    }

    private Album(Parcel source) {
        this.mId = source.readString();
        this.mCoverUri = (Uri)source.readParcelable(Uri.class.getClassLoader());
        this.mDisplayName = source.readString();
        this.mCount = source.readLong();
    }

    public static Album valueOf(Cursor cursor) {
        String clumn = cursor.getString(cursor.getColumnIndex("uri"));
        return new Album(cursor.getString(cursor.getColumnIndex("bucket_id")), Uri.parse((String)(clumn != null ? clumn : "")), cursor.getString(cursor.getColumnIndex("bucket_display_name")), cursor.getLong(cursor.getColumnIndex("count")));
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mId);
        dest.writeParcelable((Parcelable)this.mCoverUri, 0);
        dest.writeString(this.mDisplayName);
        dest.writeLong(this.mCount);
    }

    public String getId() {
        return this.mId;
    }

    public Uri getCoverUri() {
        return this.mCoverUri;
    }

    public long getCount() {
        return this.mCount;
    }

    public void addCaptureCount() {
        ++this.mCount;
    }

    public String getDisplayName(Context context) {
        if (this.isAll()) {
            return context.getString(R.string.album_name_all);
        }
        return this.mDisplayName;
    }

    public boolean isAll() {
        return ALBUM_ID_ALL.equals(this.mId);
    }

    public boolean isEmpty() {
        return this.mCount == 0L;
    }
}

