/*
 * Decompiled with CFR 0.152.
 */
package com.zhihu.matisse.ui;

import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import com.zhihu.matisse.R;
import com.zhihu.matisse.internal.entity.SelectionSpec;
import com.zhihu.matisse.internal.ui.adapter.AlbumMediaAdapter;
import com.zhihu.matisse.internal.utils.MediaStoreCompat;
import com.zhihu.matisse.internal.utils.SingleMediaScanner;
import java.util.ArrayList;

public class CaptureDelegateActivity
extends AppCompatActivity
implements AlbumMediaAdapter.OnPhotoCapture {
    private SelectionSpec mSpec;
    private MediaStoreCompat mMediaStoreCompat;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        if (this.mSpec == null) {
            this.mSpec = SelectionSpec.getInstance();
        }
        super.onCreate(savedInstanceState);
        if (!this.mSpec.hasInited) {
            this.setResult(0);
            this.finish();
            return;
        }
        if (!this.mSpec.capture) {
            throw new IllegalStateException("capture must set true!");
        }
        if (this.mSpec.captureStrategy == null) {
            throw new RuntimeException("Don't forget to set CaptureStrategy.");
        }
        this.mMediaStoreCompat = new MediaStoreCompat(this);
        this.mMediaStoreCompat.setCaptureStrategy(this.mSpec.captureStrategy);
        this.capture();
    }

    protected void onResume() {
        super.onResume();
        this.overridePendingTransition(R.anim.matisse_anim_empty, R.anim.matisse_anim_empty);
    }

    protected void onPause() {
        super.onPause();
        this.overridePendingTransition(R.anim.matisse_anim_empty, R.anim.matisse_anim_empty);
    }

    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode != -1) {
            this.finish();
            return;
        }
        if (requestCode == 24) {
            Uri contentUri = this.mMediaStoreCompat.getCurrentPhotoUri();
            String path = this.mMediaStoreCompat.getCurrentPhotoPath();
            ArrayList<Uri> selected = new ArrayList<Uri>();
            selected.add(contentUri);
            ArrayList<String> selectedPath = new ArrayList<String>();
            selectedPath.add(path);
            Intent result = new Intent();
            result.putParcelableArrayListExtra("extra_result_selection", selected);
            result.putStringArrayListExtra("extra_result_selection_path", selectedPath);
            this.setResult(-1, result);
            if (Build.VERSION.SDK_INT < 21) {
                this.revokeUriPermission(contentUri, 3);
            }
            new SingleMediaScanner(this.getApplicationContext(), path, new SingleMediaScanner.ScanListener(){

                @Override
                public void onScanFinish() {
                    Log.i((String)"SingleMediaScanner", (String)"scan finish!");
                }
            });
            this.finish();
        }
    }

    @Override
    public void capture() {
        if (this.mMediaStoreCompat != null) {
            this.mMediaStoreCompat.dispatchCaptureIntent(this, 24);
        }
    }
}

