/*
 * Decompiled with CFR 0.152.
 */
package com.zhihu.matisse.internal.ui;

import android.content.Context;
import android.database.Cursor;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.OnLifecycleEvent;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.zhihu.matisse.R;
import com.zhihu.matisse.internal.entity.Album;
import com.zhihu.matisse.internal.entity.Item;
import com.zhihu.matisse.internal.entity.SelectionSpec;
import com.zhihu.matisse.internal.model.AlbumMediaCollection;
import com.zhihu.matisse.internal.model.SelectedItemCollection;
import com.zhihu.matisse.internal.ui.adapter.AlbumMediaAdapter;
import com.zhihu.matisse.internal.ui.widget.MediaGridInset;
import com.zhihu.matisse.internal.utils.UIUtils;

public class MediaSelectionFragment
extends Fragment
implements AlbumMediaCollection.AlbumMediaCallbacks,
AlbumMediaAdapter.CheckStateListener,
AlbumMediaAdapter.OnMediaClickListener {
    public static final String EXTRA_ALBUM = "extra_album";
    private final AlbumMediaCollection mAlbumMediaCollection = new AlbumMediaCollection();
    private RecyclerView mRecyclerView;
    private AlbumMediaAdapter mAdapter;
    private SelectionProvider mSelectionProvider;
    private AlbumMediaAdapter.CheckStateListener mCheckStateListener;
    private AlbumMediaAdapter.OnMediaClickListener mOnMediaClickListener;

    public static MediaSelectionFragment newInstance(Album album) {
        MediaSelectionFragment fragment = new MediaSelectionFragment();
        Bundle args = new Bundle();
        args.putParcelable(EXTRA_ALBUM, (Parcelable)album);
        fragment.setArguments(args);
        return fragment;
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        if (!(context instanceof SelectionProvider)) {
            throw new IllegalStateException("Context must implement SelectionProvider.");
        }
        this.mSelectionProvider = (SelectionProvider)context;
        if (context instanceof AlbumMediaAdapter.CheckStateListener) {
            this.mCheckStateListener = (AlbumMediaAdapter.CheckStateListener)context;
        }
        if (context instanceof AlbumMediaAdapter.OnMediaClickListener) {
            this.mOnMediaClickListener = (AlbumMediaAdapter.OnMediaClickListener)context;
        }
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_media_selection, container, false);
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.mRecyclerView = (RecyclerView)view.findViewById(R.id.recyclerview);
        this.getActivity().getLifecycle().addObserver(new LifecycleObserver(){

            @OnLifecycleEvent(value=Lifecycle.Event.ON_CREATE)
            public void onCreated() {
                Album album = (Album)MediaSelectionFragment.this.getArguments().getParcelable(MediaSelectionFragment.EXTRA_ALBUM);
                MediaSelectionFragment.this.mAdapter = new AlbumMediaAdapter(MediaSelectionFragment.this.getContext(), MediaSelectionFragment.this.mSelectionProvider.provideSelectedItemCollection(), MediaSelectionFragment.this.mRecyclerView);
                MediaSelectionFragment.this.mAdapter.registerCheckStateListener(MediaSelectionFragment.this);
                MediaSelectionFragment.this.mAdapter.registerOnMediaClickListener(MediaSelectionFragment.this);
                MediaSelectionFragment.this.mRecyclerView.setHasFixedSize(true);
                SelectionSpec selectionSpec = SelectionSpec.getInstance();
                int spanCount = selectionSpec.gridExpectedSize > 0 ? UIUtils.spanCount(MediaSelectionFragment.this.getContext(), selectionSpec.gridExpectedSize) : selectionSpec.spanCount;
                MediaSelectionFragment.this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager(MediaSelectionFragment.this.getContext(), spanCount));
                int spacing = MediaSelectionFragment.this.getResources().getDimensionPixelSize(R.dimen.media_grid_spacing);
                MediaSelectionFragment.this.mRecyclerView.addItemDecoration((RecyclerView.ItemDecoration)new MediaGridInset(spanCount, spacing, false));
                MediaSelectionFragment.this.mRecyclerView.setAdapter((RecyclerView.Adapter)MediaSelectionFragment.this.mAdapter);
                MediaSelectionFragment.this.mAlbumMediaCollection.onCreate(MediaSelectionFragment.this.getActivity(), MediaSelectionFragment.this);
                MediaSelectionFragment.this.mAlbumMediaCollection.load(album, selectionSpec.capture, this.hashCode());
            }

            @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
            public void onDestroy() {
            }
        });
    }

    public void onDestroy() {
        super.onDestroy();
        this.mAlbumMediaCollection.onDestroy();
    }

    public void refreshMediaGrid() {
        this.mAdapter.notifyDataSetChanged();
    }

    public void refreshSelection() {
        this.mAdapter.refreshSelection();
    }

    @Override
    public void onAlbumMediaLoad(Cursor cursor) {
        this.mAdapter.swapCursor(cursor);
    }

    @Override
    public void onAlbumMediaReset() {
        this.mAdapter.swapCursor(null);
    }

    @Override
    public void onUpdate() {
        if (this.mCheckStateListener != null) {
            this.mCheckStateListener.onUpdate();
        }
    }

    @Override
    public void onMediaClick(Album album, Item item, int adapterPosition) {
        if (this.mOnMediaClickListener != null) {
            this.mOnMediaClickListener.onMediaClick((Album)this.getArguments().getParcelable(EXTRA_ALBUM), item, adapterPosition);
        }
    }

    public static interface SelectionProvider {
        public SelectedItemCollection provideSelectedItemCollection();
    }
}

