/*
 * Decompiled with CFR 0.152.
 */
package com.zhihu.matisse;

import android.app.Activity;
import android.content.Intent;
import android.net.Uri;
import androidx.activity.result.ActivityResult;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import com.zhihu.matisse.MimeType;
import com.zhihu.matisse.SelectionCreator;
import com.zhihu.matisse.internal.entity.CaptureStrategy;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Set;

public final class Matisse {
    private final WeakReference<Activity> mContext;
    private final WeakReference<Fragment> mFragment;
    private final ActivityResultContract<Intent, ActivityResult> activityResultContract = new ActivityResultContracts.StartActivityForResult();

    private Matisse(Activity activity) {
        this(activity, null);
    }

    private Matisse(Fragment fragment) {
        this((Activity)fragment.getActivity(), fragment);
    }

    private Matisse(Activity activity, Fragment fragment) {
        this.mContext = new WeakReference<Activity>(activity);
        this.mFragment = new WeakReference<Fragment>(fragment);
    }

    public static Matisse from(Activity activity) {
        return new Matisse(activity);
    }

    public static Matisse from(Fragment fragment) {
        return new Matisse(fragment);
    }

    public static List<Uri> obtainResult(Intent data) {
        return data.getParcelableArrayListExtra("extra_result_selection");
    }

    public static List<String> obtainPathResult(Intent data) {
        return data.getStringArrayListExtra("extra_result_selection_path");
    }

    public static boolean obtainOriginalState(Intent data) {
        return data.getBooleanExtra("extra_result_original_enable", false);
    }

    public SelectionCreator choose(Set<MimeType> mimeTypes) {
        return this.choose(mimeTypes, true);
    }

    public SelectionCreator choose(Set<MimeType> mimeTypes, boolean mediaTypeExclusive) {
        return new SelectionCreator(this, mimeTypes, mediaTypeExclusive);
    }

    @Nullable
    Activity getActivity() {
        return (Activity)this.mContext.get();
    }

    @Nullable
    Fragment getFragment() {
        return this.mFragment != null ? (Fragment)this.mFragment.get() : null;
    }

    @Deprecated
    public void performCapture(CaptureStrategy captureStrategy, int requestCode) {
        this.choose(MimeType.ofImage(), false).capture(true).captureStrategy(captureStrategy).forCapture(requestCode);
    }

    public void performCapture(CaptureStrategy captureStrategy, ActivityResultLauncher<Intent> launcher) {
        this.choose(MimeType.ofImage(), false).capture(true).captureStrategy(captureStrategy).forCapture(launcher);
    }
}

