/*
 * Decompiled with CFR 0.152.
 */
package io.github.luizgrp.sectionedrecyclerviewadapter;

import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import io.github.luizgrp.sectionedrecyclerviewadapter.SectionParameters;
import java.util.List;

public abstract class Section {
    private State state = State.LOADED;
    private boolean visible = true;
    private boolean hasHeader;
    private boolean hasFooter;
    @LayoutRes
    private final Integer itemResourceId;
    @LayoutRes
    private final Integer headerResourceId;
    @LayoutRes
    private final Integer footerResourceId;
    @LayoutRes
    private final Integer loadingResourceId;
    @LayoutRes
    private final Integer failedResourceId;
    @LayoutRes
    private final Integer emptyResourceId;
    private final boolean itemViewWillBeProvided;
    private final boolean headerViewWillBeProvided;
    private final boolean footerViewWillBeProvided;
    private final boolean loadingViewWillBeProvided;
    private final boolean failedViewWillBeProvided;
    private final boolean emptyViewWillBeProvided;

    public Section(@NonNull SectionParameters sectionParameters) {
        this.itemResourceId = sectionParameters.itemResourceId;
        this.headerResourceId = sectionParameters.headerResourceId;
        this.footerResourceId = sectionParameters.footerResourceId;
        this.loadingResourceId = sectionParameters.loadingResourceId;
        this.failedResourceId = sectionParameters.failedResourceId;
        this.emptyResourceId = sectionParameters.emptyResourceId;
        this.itemViewWillBeProvided = sectionParameters.itemViewWillBeProvided;
        this.headerViewWillBeProvided = sectionParameters.headerViewWillBeProvided;
        this.footerViewWillBeProvided = sectionParameters.footerViewWillBeProvided;
        this.loadingViewWillBeProvided = sectionParameters.loadingViewWillBeProvided;
        this.failedViewWillBeProvided = sectionParameters.failedViewWillBeProvided;
        this.emptyViewWillBeProvided = sectionParameters.emptyViewWillBeProvided;
        this.hasHeader = this.headerResourceId != null || this.headerViewWillBeProvided;
        this.hasFooter = this.footerResourceId != null || this.footerViewWillBeProvided;
    }

    public final void setState(State state) {
        switch (state) {
            case LOADING: {
                if (this.loadingResourceId != null || this.loadingViewWillBeProvided) break;
                throw new IllegalStateException("Resource id for 'loading state' should be provided or 'loadingViewWillBeProvided' should be set");
            }
            case FAILED: {
                if (this.failedResourceId != null || this.failedViewWillBeProvided) break;
                throw new IllegalStateException("Resource id for 'failed state' should be provided or 'failedViewWillBeProvided' should be set");
            }
            case EMPTY: {
                if (this.emptyResourceId != null || this.emptyViewWillBeProvided) break;
                throw new IllegalStateException("Resource id for 'empty state' should be provided or 'emptyViewWillBeProvided' should be set");
            }
        }
        this.state = state;
    }

    public final State getState() {
        return this.state;
    }

    public final boolean isVisible() {
        return this.visible;
    }

    public final void setVisible(boolean visible) {
        this.visible = visible;
    }

    public final boolean hasHeader() {
        return this.hasHeader;
    }

    public final void setHasHeader(boolean hasHeader) {
        this.hasHeader = hasHeader;
    }

    public final boolean hasFooter() {
        return this.hasFooter;
    }

    public final void setHasFooter(boolean hasFooter) {
        this.hasFooter = hasFooter;
    }

    public final boolean isItemViewWillBeProvided() {
        return this.itemViewWillBeProvided;
    }

    public final Integer getItemResourceId() {
        return this.itemResourceId;
    }

    public final boolean isHeaderViewWillBeProvided() {
        return this.headerViewWillBeProvided;
    }

    public final Integer getHeaderResourceId() {
        return this.headerResourceId;
    }

    public final boolean isFooterViewWillBeProvided() {
        return this.footerViewWillBeProvided;
    }

    public final Integer getFooterResourceId() {
        return this.footerResourceId;
    }

    public final boolean isLoadingViewWillBeProvided() {
        return this.loadingViewWillBeProvided;
    }

    public final Integer getLoadingResourceId() {
        return this.loadingResourceId;
    }

    public final boolean isFailedViewWillBeProvided() {
        return this.failedViewWillBeProvided;
    }

    public final Integer getFailedResourceId() {
        return this.failedResourceId;
    }

    public final boolean isEmptyViewWillBeProvided() {
        return this.emptyViewWillBeProvided;
    }

    public final Integer getEmptyResourceId() {
        return this.emptyResourceId;
    }

    public final int getSectionItemsTotal() {
        int contentItemsTotal;
        switch (this.state) {
            case LOADED: {
                contentItemsTotal = this.getContentItemsTotal();
                break;
            }
            case LOADING: 
            case FAILED: 
            case EMPTY: {
                contentItemsTotal = 1;
                break;
            }
            default: {
                throw new IllegalStateException("Invalid state");
            }
        }
        return contentItemsTotal + (this.hasHeader ? 1 : 0) + (this.hasFooter ? 1 : 0);
    }

    public abstract int getContentItemsTotal();

    public View getItemView(ViewGroup parent) {
        throw new UnsupportedOperationException("You need to implement getItemView() if you set itemViewWillBeProvided");
    }

    public abstract RecyclerView.ViewHolder getItemViewHolder(View var1);

    public abstract void onBindItemViewHolder(RecyclerView.ViewHolder var1, int var2);

    public void onBindItemViewHolder(RecyclerView.ViewHolder holder, int position, List<Object> payloads) {
        this.onBindItemViewHolder(holder, position);
    }

    public View getHeaderView(ViewGroup parent) {
        throw new UnsupportedOperationException("You need to implement getHeaderView() if you set headerViewWillBeProvided");
    }

    public RecyclerView.ViewHolder getHeaderViewHolder(View view) {
        throw new UnsupportedOperationException("You need to implement getHeaderViewHolder() if you set headerResourceId");
    }

    public void onBindHeaderViewHolder(RecyclerView.ViewHolder holder) {
    }

    public void onBindHeaderViewHolder(RecyclerView.ViewHolder holder, List<Object> payloads) {
        this.onBindHeaderViewHolder(holder);
    }

    public View getFooterView(ViewGroup parent) {
        throw new UnsupportedOperationException("You need to implement getFooterView() if you set footerViewWillBeProvided");
    }

    public RecyclerView.ViewHolder getFooterViewHolder(View view) {
        throw new UnsupportedOperationException("You need to implement getFooterViewHolder() if you set footerResourceId");
    }

    public void onBindFooterViewHolder(RecyclerView.ViewHolder holder) {
    }

    public void onBindFooterViewHolder(RecyclerView.ViewHolder holder, List<Object> payloads) {
        this.onBindFooterViewHolder(holder);
    }

    public View getLoadingView(ViewGroup parent) {
        throw new UnsupportedOperationException("You need to implement getLoadingView() if you set loadingViewWillBeProvided");
    }

    public RecyclerView.ViewHolder getLoadingViewHolder(View view) {
        throw new UnsupportedOperationException("You need to implement getLoadingViewHolder() if you set loadingResourceId");
    }

    public void onBindLoadingViewHolder(RecyclerView.ViewHolder holder) {
    }

    public void onBindLoadingViewHolder(RecyclerView.ViewHolder holder, List<Object> payloads) {
        this.onBindLoadingViewHolder(holder);
    }

    public View getFailedView(ViewGroup parent) {
        throw new UnsupportedOperationException("You need to implement getFailedView() if you set failedViewWillBeProvided");
    }

    public RecyclerView.ViewHolder getFailedViewHolder(View view) {
        throw new UnsupportedOperationException("You need to implement getFailedViewHolder() if you set failedResourceId");
    }

    public void onBindFailedViewHolder(RecyclerView.ViewHolder holder) {
    }

    public void onBindFailedViewHolder(RecyclerView.ViewHolder holder, List<Object> payloads) {
        this.onBindFailedViewHolder(holder);
    }

    public View getEmptyView(ViewGroup parent) {
        throw new UnsupportedOperationException("You need to implement getEmptyView() if you set emptyViewWillBeProvided");
    }

    public RecyclerView.ViewHolder getEmptyViewHolder(View view) {
        throw new UnsupportedOperationException("You need to implement getEmptyViewHolder() if you set emptyResourceId");
    }

    public void onBindEmptyViewHolder(RecyclerView.ViewHolder holder) {
    }

    public void onBindEmptyViewHolder(RecyclerView.ViewHolder holder, List<Object> payloads) {
        this.onBindEmptyViewHolder(holder);
    }

    public static enum State {
        LOADING,
        LOADED,
        FAILED,
        EMPTY;

    }
}

