/*
 * Decompiled with CFR 0.152.
 */
package io.github.luizgrp.sectionedrecyclerviewadapter;

import android.support.annotation.LayoutRes;

public final class SectionParameters {
    @LayoutRes
    public final Integer itemResourceId;
    @LayoutRes
    public final Integer headerResourceId;
    @LayoutRes
    public final Integer footerResourceId;
    @LayoutRes
    public final Integer loadingResourceId;
    @LayoutRes
    public final Integer failedResourceId;
    @LayoutRes
    public final Integer emptyResourceId;
    public final boolean itemViewWillBeProvided;
    public final boolean headerViewWillBeProvided;
    public final boolean footerViewWillBeProvided;
    public final boolean loadingViewWillBeProvided;
    public final boolean failedViewWillBeProvided;
    public final boolean emptyViewWillBeProvided;

    private SectionParameters(Builder builder) {
        this.itemResourceId = builder.itemResourceId;
        this.headerResourceId = builder.headerResourceId;
        this.footerResourceId = builder.footerResourceId;
        this.loadingResourceId = builder.loadingResourceId;
        this.failedResourceId = builder.failedResourceId;
        this.emptyResourceId = builder.emptyResourceId;
        this.itemViewWillBeProvided = builder.itemViewWillBeProvided;
        this.headerViewWillBeProvided = builder.headerViewWillBeProvided;
        this.footerViewWillBeProvided = builder.footerViewWillBeProvided;
        this.loadingViewWillBeProvided = builder.loadingViewWillBeProvided;
        this.failedViewWillBeProvided = builder.failedViewWillBeProvided;
        this.emptyViewWillBeProvided = builder.emptyViewWillBeProvided;
        if (this.itemResourceId != null && this.itemViewWillBeProvided) {
            throw new IllegalArgumentException("itemResourceId and itemViewWillBeProvided cannot both be set");
        }
        if (this.itemResourceId == null && !this.itemViewWillBeProvided) {
            throw new IllegalArgumentException("Either itemResourceId or itemViewWillBeProvided must be set");
        }
        if (this.headerResourceId != null && this.headerViewWillBeProvided) {
            throw new IllegalArgumentException("headerResourceId and headerViewWillBeProvided cannot both be set");
        }
        if (this.footerResourceId != null && this.footerViewWillBeProvided) {
            throw new IllegalArgumentException("footerResourceId and footerViewWillBeProvided cannot both be set");
        }
        if (this.loadingResourceId != null && this.loadingViewWillBeProvided) {
            throw new IllegalArgumentException("loadingResourceId and loadingViewWillBeProvided cannot both be set");
        }
        if (this.failedResourceId != null && this.failedViewWillBeProvided) {
            throw new IllegalArgumentException("failedResourceId and failedViewWillBeProvided cannot both be set");
        }
        if (this.emptyResourceId != null && this.emptyViewWillBeProvided) {
            throw new IllegalArgumentException("emptyResourceId and emptyViewWillBeProvided cannot both be set");
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        @LayoutRes
        private Integer itemResourceId;
        @LayoutRes
        private Integer headerResourceId;
        @LayoutRes
        private Integer footerResourceId;
        @LayoutRes
        private Integer loadingResourceId;
        @LayoutRes
        private Integer failedResourceId;
        @LayoutRes
        private Integer emptyResourceId;
        private boolean itemViewWillBeProvided;
        private boolean headerViewWillBeProvided;
        private boolean footerViewWillBeProvided;
        private boolean loadingViewWillBeProvided;
        private boolean failedViewWillBeProvided;
        private boolean emptyViewWillBeProvided;

        private Builder() {
        }

        @Deprecated
        public Builder(@LayoutRes int itemResourceId) {
            this.itemResourceId = itemResourceId;
        }

        public Builder itemResourceId(@LayoutRes int itemResourceId) {
            this.itemResourceId = itemResourceId;
            return this;
        }

        public Builder itemViewWillBeProvided() {
            this.itemViewWillBeProvided = true;
            return this;
        }

        public Builder headerResourceId(@LayoutRes int headerResourceId) {
            this.headerResourceId = headerResourceId;
            return this;
        }

        public Builder headerViewWillBeProvided() {
            this.headerViewWillBeProvided = true;
            return this;
        }

        public Builder footerResourceId(@LayoutRes int footerResourceId) {
            this.footerResourceId = footerResourceId;
            return this;
        }

        public Builder footerViewWillBeProvided() {
            this.footerViewWillBeProvided = true;
            return this;
        }

        public Builder loadingResourceId(@LayoutRes int loadingResourceId) {
            this.loadingResourceId = loadingResourceId;
            return this;
        }

        public Builder loadingViewWillBeProvided() {
            this.loadingViewWillBeProvided = true;
            return this;
        }

        public Builder failedResourceId(@LayoutRes int failedResourceId) {
            this.failedResourceId = failedResourceId;
            return this;
        }

        public Builder failedViewWillBeProvided() {
            this.failedViewWillBeProvided = true;
            return this;
        }

        public Builder emptyResourceId(@LayoutRes int emptyResourceId) {
            this.emptyResourceId = emptyResourceId;
            return this;
        }

        public Builder emptyViewWillBeProvided() {
            this.emptyViewWillBeProvided = true;
            return this;
        }

        public SectionParameters build() {
            return new SectionParameters(this);
        }
    }
}

