/*
 * Decompiled with CFR 0.152.
 */
package com.github.luben.zstd;

import java.lang.ref.SoftReference;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;

class BufferPool {
    private static final Map<Integer, SoftReference<BufferPool>> pools = new HashMap<Integer, SoftReference<BufferPool>>();
    private final int length;
    private final Deque<byte[]> queue;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static BufferPool get(int n) {
        Map<Integer, SoftReference<BufferPool>> map = pools;
        synchronized (map) {
            BufferPool bufferPool;
            SoftReference<BufferPool> softReference = pools.get(n);
            if (softReference == null || (bufferPool = softReference.get()) == null) {
                bufferPool = new BufferPool(n);
                softReference = new SoftReference<BufferPool>(bufferPool);
                pools.put(n, softReference);
            }
            return bufferPool;
        }
    }

    BufferPool(int n) {
        this.length = n;
        this.queue = new ArrayDeque<byte[]>();
    }

    synchronized byte[] checkOut() {
        byte[] byArray = this.queue.pollFirst();
        if (byArray == null) {
            byArray = new byte[this.length];
        }
        return byArray;
    }

    synchronized void checkIn(byte[] byArray) {
        if (this.length != byArray.length) {
            throw new IllegalStateException("buffer size mismatch");
        }
        this.queue.addLast(byArray);
    }
}

