/*
 * Decompiled with CFR 0.152.
 */
package fr.w3blog.zpl.model.element;

import fr.w3blog.zpl.constant.ZebraFont;
import fr.w3blog.zpl.constant.ZebraRotation;
import fr.w3blog.zpl.model.PrinterOptions;
import fr.w3blog.zpl.model.ZebraElement;
import fr.w3blog.zpl.utils.ZplUtils;

public class ZebraText
extends ZebraElement {
    ZebraFont zebraFont = null;
    Integer fontSize = null;
    ZebraRotation zebraRotation = ZebraRotation.NORMAL;
    String text;

    public ZebraText(String text) {
        this.text = text;
    }

    public ZebraText(String text, int fontSize) {
        this.fontSize = fontSize;
        this.text = text;
    }

    public ZebraText(String text, ZebraFont zebraFont, int fontSize) {
        this.zebraFont = zebraFont;
        this.fontSize = fontSize;
        this.text = text;
    }

    public ZebraText(String text, ZebraFont zebraFont, int fontSize, ZebraRotation zebraRotation) {
        this.zebraFont = zebraFont;
        this.zebraRotation = zebraRotation;
        this.fontSize = fontSize;
        this.text = text;
    }

    public ZebraText(int positionX, int positionY, String text) {
        this.text = text;
        this.positionX = positionX;
        this.positionY = positionY;
    }

    public ZebraText(int positionX, int positionY, String text, int fontSize) {
        this.fontSize = fontSize;
        this.text = text;
        this.positionX = positionX;
        this.positionY = positionY;
    }

    public ZebraText(int positionX, int positionY, String text, ZebraFont zebraFont, int fontSize, ZebraRotation zebraRotation) {
        this.zebraFont = zebraFont;
        this.fontSize = fontSize;
        this.zebraRotation = zebraRotation;
        this.text = text;
        this.positionX = positionX;
        this.positionY = positionY;
    }

    public ZebraText(int positionX, int positionY, String text, ZebraFont zebraFont, int fontSize) {
        this.zebraFont = zebraFont;
        this.fontSize = fontSize;
        this.text = text;
        this.positionX = positionX;
        this.positionY = positionY;
    }

    @Override
    public String getZplCode(PrinterOptions printerOptions) {
        StringBuffer zpl = new StringBuffer();
        zpl.append(this.getZplCodePosition());
        if (this.fontSize != null && this.zebraFont != null) {
            Integer[] dimension = ZplUtils.extractDotsFromFont(this.zebraFont, this.fontSize, printerOptions.getZebraPPP());
            zpl.append((CharSequence)ZplUtils.zplCommand("A", this.zebraFont.getLetter() + this.zebraRotation.getLetter(), dimension[0], dimension[1]));
        } else if (this.fontSize != null && printerOptions.getDefaultZebraFont() != null) {
            Integer[] dimension = ZplUtils.extractDotsFromFont(printerOptions.getDefaultZebraFont(), this.fontSize, printerOptions.getZebraPPP());
            zpl.append((CharSequence)ZplUtils.zplCommand("A", printerOptions.getDefaultZebraFont().getLetter() + this.zebraRotation.getLetter(), dimension[0], dimension[1]));
        }
        zpl.append("^FH\\^FD");
        zpl.append(ZplUtils.convertAccentToZplAsciiHexa(this.text));
        zpl.append((CharSequence)ZplUtils.zplCommandSautLigne("FS"));
        return zpl.toString();
    }
}

