/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.printconnectintentswrapper;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.ResultReceiver;
import android.util.Log;
import com.zebra.printconnectintentswrapper.PCConstants;
import com.zebra.printconnectintentswrapper.PCIntentsBase;
import com.zebra.printconnectintentswrapper.PCIntentsBaseSettings;

public class PCUnselectPrinter
extends PCIntentsBase {
    private onUnselectPrinterResult mUnselectPrinterCallback = null;

    public PCUnselectPrinter(Context aContext) {
        super(aContext);
    }

    public void execute(PCIntentsBaseSettings settings, onUnselectPrinterResult callback) {
        if (callback == null) {
            Log.e((String)TAG, (String)"Error: callback member is null.");
            return;
        }
        this.mUnselectPrinterCallback = callback;
        super.execute(settings);
        this.UnselectPrinter(settings);
    }

    private void UnselectPrinter(final PCIntentsBaseSettings settings) {
        Intent intent = new Intent();
        intent.setComponent(new ComponentName("com.zebra.printconnect", "com.zebra.printconnect.print.UnselectPrinterService"));
        ResultReceiver receiver = this.buildIPCSafeReceiver(new ResultReceiver(null){

            protected void onReceiveResult(int resultCode, Bundle resultData) {
                PCUnselectPrinter.this.cleanAll();
                if (resultCode == 0) {
                    if (PCUnselectPrinter.this.mUnselectPrinterCallback != null) {
                        PCUnselectPrinter.this.mUnselectPrinterCallback.success(settings);
                    }
                } else {
                    String errorMessage = resultData.getString("com.zebra.printconnect.PrintService.ERROR_MESSAGE");
                    if (errorMessage == null) {
                        errorMessage = PCConstants.getErrorMessage(resultCode);
                    }
                    if (PCUnselectPrinter.this.mUnselectPrinterCallback != null) {
                        PCUnselectPrinter.this.mUnselectPrinterCallback.error(errorMessage, resultCode, resultData, settings);
                    }
                }
            }
        });
        intent.putExtra("com.zebra.printconnect.PrintService.RESULT_RECEIVER", (Parcelable)receiver);
        this.mContext.startService(intent);
    }

    @Override
    protected void onTimeOut(PCIntentsBaseSettings settings) {
        if (this.mUnselectPrinterCallback != null) {
            this.mUnselectPrinterCallback.timeOut(settings);
        }
    }

    public static interface onUnselectPrinterResult {
        public void success(PCIntentsBaseSettings var1);

        public void error(String var1, int var2, Bundle var3, PCIntentsBaseSettings var4);

        public void timeOut(PCIntentsBaseSettings var1);
    }
}

