/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.printconnectintentswrapper;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.nfc.NdefMessage;
import android.nfc.NdefRecord;
import android.os.Parcelable;
import android.util.Log;
import com.zebra.printconnectintentswrapper.PCConnectPrinterSettings;
import com.zebra.printconnectintentswrapper.PCIntentsBase;
import com.zebra.printconnectintentswrapper.PCIntentsBaseSettings;

public class PCConnectPrinter
extends PCIntentsBase {
    private onConnectPrinterResult mConnectPrinterCallback = null;

    public PCConnectPrinter(Context aContext) {
        super(aContext);
    }

    public void execute(PCConnectPrinterSettings settings, onConnectPrinterResult callback) {
        if (callback == null) {
            Log.e((String)TAG, (String)"Error: callback member is null.");
            return;
        }
        this.mConnectPrinterCallback = callback;
        super.execute(settings);
        if (this.ConnectPrinter(settings)) {
            this.cleanAll();
            if (this.mConnectPrinterCallback != null) {
                this.mConnectPrinterCallback.success(settings);
            }
        } else {
            this.cleanAll();
            if (this.mConnectPrinterCallback != null) {
                this.mConnectPrinterCallback.error("At least one mac address must be specified.", settings);
            }
        }
    }

    private boolean ConnectPrinter(PCConnectPrinterSettings settings) {
        if (settings.mEthernetMacAddress != null && !settings.mEthernetMacAddress.isEmpty() || settings.mWifiMacAddress != null && !settings.mWifiMacAddress.isEmpty() || settings.mBluetoothMacAddress != null && !settings.mBluetoothMacAddress.isEmpty()) {
            if (settings.mEthernetMacAddress == null || settings.mEthernetMacAddress.isEmpty()) {
                settings.mEthernetMacAddress = "000000000000";
            }
            if (settings.mWifiMacAddress == null || settings.mWifiMacAddress.isEmpty()) {
                settings.mWifiMacAddress = "000000000000";
            }
            if (settings.mBluetoothMacAddress == null || settings.mBluetoothMacAddress.isEmpty()) {
                settings.mBluetoothMacAddress = "000000000000";
            }
            Intent simulateNFCIntent = new Intent();
            simulateNFCIntent.setAction("android.nfc.action.NDEF_DISCOVERED");
            Uri connectionURI = Uri.parse((String)("http://www.zebra.com/apps/r/nfc?mE=" + settings.mEthernetMacAddress + "&mW=" + settings.mWifiMacAddress + "&mB=" + settings.mBluetoothMacAddress + "&c=XXXX-XXXXXXX-XX&s=XXXXXXXXXXXXXX&v=0"));
            simulateNFCIntent.setData(connectionURI);
            Parcelable[] ndefMessages = new Parcelable[1];
            NdefRecord[] records = new NdefRecord[1];
            String payloadString = "\u0001zebra.com/apps/r/nfc?mE=" + settings.mEthernetMacAddress + "&mW=" + settings.mWifiMacAddress + "&mB=" + settings.mBluetoothMacAddress + "&c=XXXX-XXXXXXX-XX&s=XXXXXXXXXXXXXX&v=0";
            byte[] payload = payloadString.getBytes();
            byte[] type = NdefRecord.RTD_URI;
            byte[] id = new byte[1];
            records[0] = new NdefRecord(1, type, id, payload);
            ndefMessages[0] = new NdefMessage(records);
            simulateNFCIntent.putExtra("android.nfc.extra.NDEF_MESSAGES", ndefMessages);
            this.mContext.startActivity(simulateNFCIntent);
            return true;
        }
        return false;
    }

    @Override
    protected void onTimeOut(PCIntentsBaseSettings settings) {
        if (this.mConnectPrinterCallback != null && this.mConnectPrinterCallback != null) {
            this.mConnectPrinterCallback.timeOut((PCConnectPrinterSettings)settings);
        }
    }

    public static interface onConnectPrinterResult {
        public void success(PCConnectPrinterSettings var1);

        public void error(String var1, PCConnectPrinterSettings var2);

        public void timeOut(PCConnectPrinterSettings var1);
    }
}

