/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.deviceidentifierswrapper;

import android.content.Context;
import android.os.Handler;
import com.zebra.deviceidentifierswrapper.DICommandBaseSettings;

abstract class DICommandBase {
    protected static String TAG = "DIWrapperMX";
    protected Context mContext = null;
    protected DICommandBaseSettings mSettings = null;
    protected Handler mTimeOutHandler;
    protected Runnable mTimeOutRunnable = new Runnable(){

        @Override
        public void run() {
            DICommandBase.this.onTimeOut(DICommandBase.this.mSettings);
        }
    };

    public DICommandBase(Context aContext) {
        this.mContext = aContext;
        this.mTimeOutHandler = new Handler(this.mContext.getMainLooper());
    }

    protected void execute(DICommandBaseSettings settings) {
        this.mSettings = settings;
        if (settings.mEnableTimeOutMechanism) {
            this.mTimeOutHandler.postDelayed(this.mTimeOutRunnable, this.mSettings.mTimeOutMS);
        }
    }

    protected void onTimeOut(DICommandBaseSettings settings) {
        this.cleanAll();
    }

    protected void cleanAll() {
        if (this.mTimeOutHandler != null) {
            this.mTimeOutHandler.removeCallbacks(this.mTimeOutRunnable);
        }
    }
}

