/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.deviceidentifierswrapper;

import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public abstract class ExecutorTask<Params, Progress, Result> {
    public static final String TAG = "ExecutorTask";
    private static final Executor THREAD_POOL_EXECUTOR = new ThreadPoolExecutor(5, 128, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    private final Handler mHandler = new Handler(Looper.getMainLooper());
    private boolean mIsInterrupted = false;

    protected void onPreExecute() {
    }

    protected abstract Result doInBackground(Params ... var1);

    protected void onPostExecute(Result result) {
    }

    protected void onProgressUpdate(Progress ... values) {
    }

    protected void onCancelled() {
    }

    @SafeVarargs
    public final void executeAsync(Params ... params) {
        THREAD_POOL_EXECUTOR.execute(() -> {
            try {
                this.checkInterrupted();
                this.mHandler.post(this::onPreExecute);
                this.checkInterrupted();
                final Result results = this.doInBackground(params);
                this.checkInterrupted();
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        ExecutorTask.this.onPostExecute(results);
                    }
                });
            }
            catch (InterruptedException ex) {
                this.mHandler.post(this::onCancelled);
            }
            catch (Exception ex) {
                Log.e((String)TAG, (String)("executeAsync: " + ex.getMessage() + "\n" + ex.getStackTrace()));
            }
        });
    }

    private void checkInterrupted() throws InterruptedException {
        if (this.isInterrupted()) {
            throw new InterruptedException();
        }
    }

    public void cancel(boolean mayInterruptIfRunning) {
        this.setInterrupted(mayInterruptIfRunning);
    }

    public boolean isInterrupted() {
        return this.mIsInterrupted;
    }

    public void setInterrupted(boolean interrupted) {
        this.mIsInterrupted = interrupted;
    }
}

