/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.datawedgeprofileintents.SettingsPlugins;

import android.os.Bundle;
import android.util.Log;
import com.zebra.datawedgeprofileenums.SC_E_1D_MARGINLESS_DECODE_EFFORT_LEVEL;
import com.zebra.datawedgeprofileenums.SC_E_AIM_MODE;
import com.zebra.datawedgeprofileenums.SC_E_AIM_TYPE;
import com.zebra.datawedgeprofileenums.SC_E_CHARSET_NAME;
import com.zebra.datawedgeprofileenums.SC_E_CODE11_VERIFY_CHECK_DIGIT;
import com.zebra.datawedgeprofileenums.SC_E_CODE_ID_TYPE;
import com.zebra.datawedgeprofileenums.SC_E_CONCAT_MODE;
import com.zebra.datawedgeprofileenums.SC_E_I2OF5_CHECK_DIGIT;
import com.zebra.datawedgeprofileenums.SC_E_ILLUMINATION_MODE;
import com.zebra.datawedgeprofileenums.SC_E_INVERSE;
import com.zebra.datawedgeprofileenums.SC_E_INVERSE1DMODE_MODE;
import com.zebra.datawedgeprofileenums.SC_E_LCD_MODE;
import com.zebra.datawedgeprofileenums.SC_E_LINEAR_SECURITY_LEVEL;
import com.zebra.datawedgeprofileenums.SC_E_LINK_MODE;
import com.zebra.datawedgeprofileenums.SC_E_MSI_CHECK_DIGIT;
import com.zebra.datawedgeprofileenums.SC_E_MSI_CHECK_DIGIT_SCHEME;
import com.zebra.datawedgeprofileenums.SC_E_PICKLIST_MODE;
import com.zebra.datawedgeprofileenums.SC_E_POOR_QUALITY_DECODE_LEVEL;
import com.zebra.datawedgeprofileenums.SC_E_PREAMBLE;
import com.zebra.datawedgeprofileenums.SC_E_PRESENTATION_MODE_SENSITIVITY;
import com.zebra.datawedgeprofileenums.SC_E_READER_MODE;
import com.zebra.datawedgeprofileenums.SC_E_SCANNER_IDENTIFIER;
import com.zebra.datawedgeprofileenums.SC_E_SCANNINGMODE;
import com.zebra.datawedgeprofileenums.SC_E_SCENE_DETECT_QUALIFIER;
import com.zebra.datawedgeprofileenums.SC_E_SECURITY_LEVEL;
import com.zebra.datawedgeprofileenums.SC_E_UPCEAN_BOOKLAND_FORMAT;
import com.zebra.datawedgeprofileenums.SC_E_UPCEAN_COUPON_REPORT;
import com.zebra.datawedgeprofileenums.SC_E_UPCEAN_SECURITY_LEVEL;
import com.zebra.datawedgeprofileenums.SC_E_UPCEAN_SUPPLEMENTAL_MODE;
import com.zebra.datawedgeprofileenums.SC_E_VOLUME_SLIDER_TYPE;

public class PluginScanner {
    public Boolean scanner_input_enabled = null;
    public SC_E_SCANNER_IDENTIFIER scanner_selection_by_identifier = null;
    public Decoders Decoders = new Decoders();
    public DecodersParams DecodersParams = new DecodersParams();
    public UpcEan UpcEan = new UpcEan();
    public ReaderParams ReaderParams = new ReaderParams();
    public ScanParams ScanParams = new ScanParams();
    public MultiBarcode MultiBarcode = new MultiBarcode();
    public MarginLess MarginLess = new MarginLess();
    public Boolean trigger_wakeup = null;

    public Bundle getBarcodePluginBundleForSetConfig(boolean resetConfig) throws Exception {
        Bundle barcodePluginConfig = new Bundle();
        barcodePluginConfig.putString("PLUGIN_NAME", "BARCODE");
        barcodePluginConfig.putString("RESET_CONFIG", resetConfig ? "true" : "false");
        Bundle barcodeProps = new Bundle();
        this.setupScannerPlugin(barcodeProps);
        barcodePluginConfig.putBundle("PARAM_LIST", barcodeProps);
        return barcodePluginConfig;
    }

    private void setupScannerPlugin(Bundle barcodeProps) throws Exception {
        if (this.scanner_input_enabled != null) {
            barcodeProps.putString("scanner_input_enabled", this.scanner_input_enabled != false ? "true" : "false");
        } else {
            barcodeProps.putString("scanner_input_enabled", "true");
        }
        if (this.scanner_selection_by_identifier != null) {
            barcodeProps.putString("scanner_selection_by_identifier", this.scanner_selection_by_identifier.toString());
        } else {
            barcodeProps.putString("scanner_selection_by_identifier", SC_E_SCANNER_IDENTIFIER.AUTO.toString());
        }
        this.setupDecoders(barcodeProps);
        this.setupDecodersParams(barcodeProps);
        this.setupUPC_EANParams(barcodeProps);
        this.setupReaderParams(barcodeProps, false);
        this.setupScanParams(barcodeProps);
        this.setupMultiBarcode(barcodeProps);
    }

    private void setupDecoders(Bundle barcodeProps) {
        if (this.Decoders.decoder_australian_postal != null) {
            barcodeProps.putString("decoder_australian_postal", this.Decoders.decoder_australian_postal != false ? "true" : "false");
        }
        if (this.Decoders.decoder_aztec != null) {
            barcodeProps.putString("decoder_aztec", this.Decoders.decoder_aztec != false ? "true" : "false");
        }
        if (this.Decoders.decoder_canadian_postal != null) {
            barcodeProps.putString("decoder_canadian_postal", this.Decoders.decoder_canadian_postal != false ? "true" : "false");
        }
        if (this.Decoders.decoder_chinese_2of5 != null) {
            barcodeProps.putString("decoder_chinese_2of5", this.Decoders.decoder_chinese_2of5 != false ? "true" : "false");
        }
        if (this.Decoders.decoder_codabar != null) {
            barcodeProps.putString("decoder_codabar", this.Decoders.decoder_codabar != false ? "true" : "false");
        }
        if (this.Decoders.decoder_code11 != null) {
            barcodeProps.putString("decoder_code11", this.Decoders.decoder_code11 != false ? "true" : "false");
        }
        if (this.Decoders.decoder_code128 != null) {
            barcodeProps.putString("decoder_code128", this.Decoders.decoder_code128 != false ? "true" : "false");
        }
        if (this.Decoders.decoder_code39 != null) {
            barcodeProps.putString("decoder_code39", this.Decoders.decoder_code39 != false ? "true" : "false");
        }
        if (this.Decoders.decoder_code93 != null) {
            barcodeProps.putString("decoder_code93", this.Decoders.decoder_code93 != false ? "true" : "false");
        }
        if (this.Decoders.decoder_composite_ab != null) {
            barcodeProps.putString("decoder_composite_ab", this.Decoders.decoder_composite_ab != false ? "true" : "false");
        }
        if (this.Decoders.decoder_composite_c != null) {
            barcodeProps.putString("decoder_composite_c", this.Decoders.decoder_composite_c != false ? "true" : "false");
        }
        if (this.Decoders.decoder_d2of5 != null) {
            barcodeProps.putString("decoder_d2of5", this.Decoders.decoder_d2of5 != false ? "true" : "false");
        }
        if (this.Decoders.decoder_datamatrix != null) {
            barcodeProps.putString("decoder_datamatrix", this.Decoders.decoder_datamatrix != false ? "true" : "false");
        }
        if (this.Decoders.decoder_dutch_postal != null) {
            barcodeProps.putString("decoder_dutch_postal", this.Decoders.decoder_dutch_postal != false ? "true" : "false");
        }
        if (this.Decoders.decoder_ean13 != null) {
            barcodeProps.putString("decoder_ean13", this.Decoders.decoder_ean13 != false ? "true" : "false");
        }
        if (this.Decoders.decoder_ean8 != null) {
            barcodeProps.putString("decoder_ean8", this.Decoders.decoder_ean8 != false ? "true" : "false");
        }
        if (this.Decoders.decoder_gs1_databar != null) {
            barcodeProps.putString("decoder_gs1_databar", this.Decoders.decoder_gs1_databar != false ? "true" : "false");
        }
        if (this.Decoders.decoder_gs1_qrcode != null) {
            barcodeProps.putString("decoder_gs1_qrcode", this.Decoders.decoder_gs1_qrcode != false ? "true" : "false");
        }
        if (this.Decoders.decoder_hanxin != null) {
            barcodeProps.putString("decoder_hanxin", this.Decoders.decoder_hanxin != false ? "true" : "false");
        }
        if (this.Decoders.decoder_i2of5 != null) {
            barcodeProps.putString("decoder_i2of5", this.Decoders.decoder_i2of5 != false ? "true" : "false");
        }
        if (this.Decoders.decoder_japanese_postal != null) {
            barcodeProps.putString("decoder_japanese_postal", this.Decoders.decoder_japanese_postal != false ? "true" : "false");
        }
        if (this.Decoders.decoder_korean_3of5 != null) {
            barcodeProps.putString("decoder_korean_3of5", this.Decoders.decoder_korean_3of5 != false ? "true" : "false");
        }
        if (this.Decoders.decoder_mailmark != null) {
            barcodeProps.putString("decoder_mailmark", this.Decoders.decoder_mailmark != false ? "true" : "false");
        }
        if (this.Decoders.decoder_matrix_2of5 != null) {
            barcodeProps.putString("decoder_matrix_2of5", this.Decoders.decoder_matrix_2of5 != false ? "true" : "false");
        }
        if (this.Decoders.decoder_maxicode != null) {
            barcodeProps.putString("decoder_maxicode", this.Decoders.decoder_maxicode != false ? "true" : "false");
        }
        if (this.Decoders.decoder_micropdf != null) {
            barcodeProps.putString("decoder_micropdf", this.Decoders.decoder_micropdf != false ? "true" : "false");
        }
        if (this.Decoders.decoder_microqr != null) {
            barcodeProps.putString("decoder_microqr", this.Decoders.decoder_microqr != false ? "true" : "false");
        }
        if (this.Decoders.decoder_msi != null) {
            barcodeProps.putString("decoder_msi", this.Decoders.decoder_msi != false ? "true" : "false");
        }
        if (this.Decoders.decoder_pdf417 != null) {
            barcodeProps.putString("decoder_pdf417", this.Decoders.decoder_pdf417 != false ? "true" : "false");
        }
        if (this.Decoders.decoder_qrcode != null) {
            barcodeProps.putString("decoder_qrcode", this.Decoders.decoder_qrcode != false ? "true" : "false");
        }
        if (this.Decoders.decoder_signature != null) {
            barcodeProps.putString("decoder_signature", this.Decoders.decoder_signature != false ? "true" : "false");
        }
        if (this.Decoders.decoder_tlc39 != null) {
            barcodeProps.putString("decoder_tlc39", this.Decoders.decoder_tlc39 != false ? "true" : "false");
        }
        if (this.Decoders.decoder_trioptic39 != null) {
            barcodeProps.putString("decoder_trioptic39", this.Decoders.decoder_trioptic39 != false ? "true" : "false");
        }
        if (this.Decoders.decoder_uk_postal != null) {
            barcodeProps.putString("decoder_uk_postal", this.Decoders.decoder_uk_postal != false ? "true" : "false");
        }
        if (this.Decoders.decoder_upca != null) {
            barcodeProps.putString("decoder_upca", this.Decoders.decoder_upca != false ? "true" : "false");
        }
        if (this.Decoders.decoder_upce0 != null) {
            barcodeProps.putString("decoder_upce0", this.Decoders.decoder_upce0 != false ? "true" : "false");
        }
        if (this.Decoders.decoder_upce1 != null) {
            barcodeProps.putString("decoder_upce1", this.Decoders.decoder_upce1 != false ? "true" : "false");
        }
        if (this.Decoders.decoder_us4state != null) {
            barcodeProps.putString("decoder_us4state", this.Decoders.decoder_us4state != false ? "true" : "false");
        }
        if (this.Decoders.decoder_usplanet != null) {
            barcodeProps.putString("decoder_usplanet", this.Decoders.decoder_usplanet != false ? "true" : "false");
        }
        if (this.Decoders.decoder_uspostnet != null) {
            barcodeProps.putString("decoder_uspostnet", this.Decoders.decoder_uspostnet != false ? "true" : "false");
        }
        if (this.Decoders.decoder_webcode != null) {
            barcodeProps.putString("decoder_webcode", this.Decoders.decoder_webcode != false ? "true" : "false");
        }
    }

    private void setupDecodersParams(Bundle barcodeProps) throws Exception {
        if (this.DecodersParams.decoder_codabar_clsi_editing != null) {
            barcodeProps.putString("decoder_codabar_clsi_editing", this.DecodersParams.decoder_codabar_clsi_editing != false ? "true" : "false");
        }
        if (this.DecodersParams.decoder_codabar_length1 != null) {
            barcodeProps.putString("decoder_codabar_length1", this.DecodersParams.decoder_codabar_length1.toString());
        }
        if (this.DecodersParams.decoder_codabar_length2 != null) {
            barcodeProps.putString("decoder_codabar_length2", this.DecodersParams.decoder_codabar_length2.toString());
        }
        if (this.DecodersParams.decoder_codabar_notis_editing != null) {
            barcodeProps.putString("decoder_codabar_notis_editing", this.DecodersParams.decoder_codabar_notis_editing != false ? "true" : "false");
        }
        if (this.DecodersParams.decoder_codabar_redundancy != null) {
            barcodeProps.putString("decoder_codabar_redundancy", this.DecodersParams.decoder_codabar_redundancy != false ? "true" : "false");
        }
        if (this.DecodersParams.decoder_code11_length1 != null) {
            barcodeProps.putString("decoder_code11_length1", this.DecodersParams.decoder_code11_length1.toString());
        }
        if (this.DecodersParams.decoder_code11_length2 != null) {
            barcodeProps.putString("decoder_code11_length2", this.DecodersParams.decoder_code11_length2.toString());
        }
        if (this.DecodersParams.decoder_code11_redundancy != null) {
            barcodeProps.putString("decoder_code11_redundancy", this.DecodersParams.decoder_code11_redundancy != false ? "true" : "false");
        }
        if (this.DecodersParams.decoder_code11_report_check_digit != null) {
            barcodeProps.putString("decoder_code11_report_check_digit", this.DecodersParams.decoder_code11_report_check_digit != false ? "true" : "false");
        }
        if (this.DecodersParams.decoder_code11_verify_check_digit != null) {
            barcodeProps.putString("decoder_code11_verify_check_digit", this.DecodersParams.decoder_code11_verify_check_digit.toString());
        }
        if (this.DecodersParams.decoder_code128_check_isbt_table != null) {
            barcodeProps.putString("decoder_code128_check_isbt_table", this.DecodersParams.decoder_code128_check_isbt_table != false ? "true" : "false");
        }
        if (this.DecodersParams.decoder_code128_enable_ean128 != null) {
            barcodeProps.putString("decoder_code128_enable_ean128", this.DecodersParams.decoder_code128_enable_ean128 != false ? "true" : "false");
        }
        if (this.DecodersParams.decoder_code128_enable_isbt128 != null) {
            barcodeProps.putString("decoder_code128_enable_isbt128", this.DecodersParams.decoder_code128_enable_isbt128 != false ? "true" : "false");
        }
        if (this.DecodersParams.decoder_code128_enable_plain != null) {
            barcodeProps.putString("decoder_code128_enable_plain", this.DecodersParams.decoder_code128_enable_plain != false ? "true" : "false");
        }
        if (this.DecodersParams.decoder_code128_isbt128_concat_mode != null) {
            barcodeProps.putString("decoder_code128_isbt128_concat_mode", this.DecodersParams.decoder_code128_isbt128_concat_mode.toString());
        }
        if (this.DecodersParams.decoder_code128_length1 != null) {
            barcodeProps.putString("decoder_code128_length1", this.DecodersParams.decoder_code128_length1.toString());
        }
        if (this.DecodersParams.decoder_code128_length2 != null) {
            barcodeProps.putString("decoder_code128_length2", this.DecodersParams.decoder_code128_length2.toString());
        }
        if (this.DecodersParams.decoder_code128_redundancy != null) {
            barcodeProps.putString("decoder_code128_redundancy", this.DecodersParams.decoder_code128_redundancy != false ? "true" : "false");
        }
        if (this.DecodersParams.decoder_code128_security_level != null) {
            barcodeProps.putString("decoder_code128_security_level", this.DecodersParams.decoder_code128_security_level.toString());
        }
        if (this.DecodersParams.code128_ignore_fnc4 != null) {
            barcodeProps.putString("code128_ignore_fnc4", this.DecodersParams.code128_ignore_fnc4 != false ? "true" : "false");
        }
        if (this.DecodersParams.decoder_code39_convert_to_code32 != null) {
            barcodeProps.putString("decoder_code39_convert_to_code32", this.DecodersParams.decoder_code39_convert_to_code32 != false ? "true" : "false");
        }
        if (this.DecodersParams.decoder_code39_full_ascii != null) {
            barcodeProps.putString("decoder_code39_full_ascii", this.DecodersParams.decoder_code39_full_ascii != false ? "true" : "false");
        }
        if (this.DecodersParams.decoder_code39_length1 != null) {
            barcodeProps.putString("decoder_code39_length1", this.DecodersParams.decoder_code39_length1.toString());
        }
        if (this.DecodersParams.decoder_code39_length2 != null) {
            barcodeProps.putString("decoder_code39_length2", this.DecodersParams.decoder_code39_length2.toString());
        }
        if (this.DecodersParams.decoder_code39_redundancy != null) {
            barcodeProps.putString("decoder_code39_redundancy", this.DecodersParams.decoder_code39_redundancy != false ? "true" : "false");
        }
        if (this.DecodersParams.decoder_code39_report_check_digit != null) {
            barcodeProps.putString("decoder_code39_report_check_digit", this.DecodersParams.decoder_code39_report_check_digit != false ? "true" : "false");
        }
        if (this.DecodersParams.decoder_code39_report_code32_prefix != null) {
            barcodeProps.putString("decoder_code39_report_code32_prefix", this.DecodersParams.decoder_code39_report_code32_prefix != false ? "true" : "false");
        }
        if (this.DecodersParams.decoder_code39_security_level != null) {
            barcodeProps.putString("decoder_code39_security_level", this.DecodersParams.decoder_code39_security_level.toString());
        }
        if (this.DecodersParams.decoder_code39_verify_check_digit != null) {
            barcodeProps.putString("decoder_code39_verify_check_digit", this.DecodersParams.decoder_code39_verify_check_digit != false ? "true" : "false");
        }
        if (this.DecodersParams.decoder_code93_length1 != null) {
            barcodeProps.putString("decoder_code93_length1", this.DecodersParams.decoder_code93_length1.toString());
        }
        if (this.DecodersParams.decoder_code93_length2 != null) {
            barcodeProps.putString("decoder_code93_length2", this.DecodersParams.decoder_code93_length2.toString());
        }
        if (this.DecodersParams.decoder_code93_redundancy != null) {
            barcodeProps.putString("decoder_code93_redundancy", this.DecodersParams.decoder_code93_redundancy != false ? "true" : "false");
        }
        if (this.DecodersParams.decoder_composite_ab_ucc_link_mode != null) {
            barcodeProps.putString("decoder_composite_ab_ucc_link_mode", this.DecodersParams.decoder_composite_ab_ucc_link_mode.toString());
        }
        if (this.DecodersParams.decoder_d2of5_length1 != null) {
            barcodeProps.putString("decoder_d2of5_length1", this.DecodersParams.decoder_d2of5_length1.toString());
        }
        if (this.DecodersParams.decoder_d2of5_length2 != null) {
            barcodeProps.putString("decoder_d2of5_length2", this.DecodersParams.decoder_d2of5_length2.toString());
        }
        if (this.DecodersParams.decoder_d2of5_redundancy != null) {
            barcodeProps.putString("decoder_d2of5_redundancy", this.DecodersParams.decoder_d2of5_redundancy != false ? "true" : "false");
        }
        if (this.DecodersParams.decoder_ean8_convert_to_ean13 != null) {
            barcodeProps.putString("decoder_ean8_convert_to_ean13", this.DecodersParams.decoder_ean8_convert_to_ean13 != false ? "true" : "false");
        }
        if (this.DecodersParams.decoder_gs1_databar_exp != null) {
            barcodeProps.putString("decoder_gs1_databar_exp", this.DecodersParams.decoder_gs1_databar_exp != false ? "true" : "false");
        }
        if (this.DecodersParams.decoder_gs1_databar_lim != null) {
            barcodeProps.putString("decoder_gs1_databar_lim", this.DecodersParams.decoder_gs1_databar_lim != false ? "true" : "false");
        }
        if (this.DecodersParams.decoder_gs1_lim_security_level != null) {
            barcodeProps.putString("decoder_gs1_lim_security_level", this.DecodersParams.decoder_gs1_lim_security_level.toString());
        }
        if (this.DecodersParams.decoder_hanxin_inverse != null) {
            barcodeProps.putString("decoder_hanxin_inverse", this.DecodersParams.decoder_hanxin_inverse.toString());
        }
        if (this.DecodersParams.decoder_i2of5_check_digit != null) {
            barcodeProps.putString("decoder_i2of5_check_digit", this.DecodersParams.decoder_i2of5_check_digit.toString());
        }
        if (this.DecodersParams.decoder_i2of5_length1 != null) {
            barcodeProps.putString("decoder_i2of5_length1", this.DecodersParams.decoder_i2of5_length1.toString());
        }
        if (this.DecodersParams.decoder_i2of5_length2 != null) {
            barcodeProps.putString("decoder_i2of5_length2", this.DecodersParams.decoder_i2of5_length2.toString());
        }
        if (this.DecodersParams.decoder_i2of5_redundancy != null) {
            barcodeProps.putString("decoder_i2of5_redundancy", this.DecodersParams.decoder_i2of5_redundancy != false ? "true" : "false");
        }
        if (this.DecodersParams.decoder_i2of5_report_check_digit != null) {
            barcodeProps.putString("decoder_i2of5_report_check_digit", this.DecodersParams.decoder_i2of5_report_check_digit != false ? "true" : "false");
        }
        if (this.DecodersParams.decoder_i2of5_security_level != null) {
            barcodeProps.putString("decoder_i2of5_security_level", this.DecodersParams.decoder_i2of5_security_level.toString());
        }
        if (this.DecodersParams.decoder_i2of5_convert_to_ean13 != null) {
            Log.e((String)"DWIWrap", (String)"decoder_i2of5_convert_to_ean13 is deprecated. Contact your developer for code update. It has been replaced by decoder_itf14_convert_to_ean13");
            throw new Exception("decoder_i2of5_convert_to_ean13 is deprecated. Contact your developer for code update. It has been replaced by decoder_itf14_convert_to_ean13");
        }
        if (this.DecodersParams.decoder_itf14_convert_to_ean13 != null) {
            barcodeProps.putString("decoder_itf14_convert_to_ean13", this.DecodersParams.decoder_itf14_convert_to_ean13 != false ? "true" : "false");
        }
        if (this.DecodersParams.decoder_matrix_2of5_length1 != null) {
            barcodeProps.putString("decoder_matrix_2of5_length1", this.DecodersParams.decoder_matrix_2of5_length1.toString());
        }
        if (this.DecodersParams.decoder_matrix_2of5_length2 != null) {
            barcodeProps.putString("decoder_matrix_2of5_length2", this.DecodersParams.decoder_matrix_2of5_length2.toString());
        }
        if (this.DecodersParams.decoder_matrix_2of5_redundancy != null) {
            barcodeProps.putString("decoder_matrix_2of5_redundancy", this.DecodersParams.decoder_matrix_2of5_redundancy != false ? "true" : "false");
        }
        if (this.DecodersParams.decoder_matrix_2of5_report_check_digit != null) {
            barcodeProps.putString("decoder_matrix_2of5_report_check_digit", this.DecodersParams.decoder_matrix_2of5_report_check_digit != false ? "true" : "false");
        }
        if (this.DecodersParams.decoder_matrix_2of5_verify_check_digit != null) {
            barcodeProps.putString("decoder_matrix_2of5_verify_check_digit", this.DecodersParams.decoder_matrix_2of5_verify_check_digit != false ? "true" : "false");
        }
        if (this.DecodersParams.decoder_msi_check_digit != null) {
            barcodeProps.putString("decoder_msi_check_digit", this.DecodersParams.decoder_msi_check_digit.toString());
        }
        if (this.DecodersParams.decoder_msi_check_digit_scheme != null) {
            barcodeProps.putString("decoder_msi_check_digit_scheme", this.DecodersParams.decoder_msi_check_digit_scheme.toString());
        }
        if (this.DecodersParams.decoder_msi_length1 != null) {
            barcodeProps.putString("decoder_msi_length1", this.DecodersParams.decoder_msi_length1.toString());
        }
        if (this.DecodersParams.decoder_msi_length2 != null) {
            barcodeProps.putString("decoder_msi_length2", this.DecodersParams.decoder_msi_length2.toString());
        }
        if (this.DecodersParams.decoder_msi_redundancy != null) {
            barcodeProps.putString("decoder_msi_redundancy", this.DecodersParams.decoder_msi_redundancy != false ? "true" : "false");
        }
        if (this.DecodersParams.decoder_msi_report_check_digit != null) {
            barcodeProps.putString("decoder_msi_report_check_digit", this.DecodersParams.decoder_msi_report_check_digit != false ? "true" : "false");
        }
        if (this.DecodersParams.decoder_trioptic39_redundancy != null) {
            barcodeProps.putString("decoder_trioptic39_redundancy", this.DecodersParams.decoder_trioptic39_redundancy != false ? "true" : "false");
        }
        if (this.DecodersParams.decoder_uk_postal_report_check_digit != null) {
            barcodeProps.putString("decoder_uk_postal_report_check_digit", this.DecodersParams.decoder_uk_postal_report_check_digit != false ? "true" : "false");
        }
        if (this.DecodersParams.decoder_upca_preamble != null) {
            barcodeProps.putString("decoder_upca_preamble", this.DecodersParams.decoder_upca_preamble.toString());
        }
        if (this.DecodersParams.decoder_upca_report_check_digit != null) {
            barcodeProps.putString("decoder_upca_report_check_digit", this.DecodersParams.decoder_upca_report_check_digit != false ? "true" : "false");
        }
        if (this.DecodersParams.decoder_upce0_convert_to_upca != null) {
            barcodeProps.putString("decoder_upce0_convert_to_upca", this.DecodersParams.decoder_upce0_convert_to_upca != false ? "true" : "false");
        }
        if (this.DecodersParams.decoder_upce0_preamble != null) {
            barcodeProps.putString("decoder_upce0_preamble", this.DecodersParams.decoder_upce0_preamble.toString());
        }
        if (this.DecodersParams.decoder_upce0_report_check_digit != null) {
            barcodeProps.putString("decoder_upce0_report_check_digit", this.DecodersParams.decoder_upce0_report_check_digit != false ? "true" : "false");
        }
        if (this.DecodersParams.decoder_upce1_convert_to_upca != null) {
            barcodeProps.putString("decoder_upce1_convert_to_upca", this.DecodersParams.decoder_upce1_convert_to_upca != false ? "true" : "false");
        }
        if (this.DecodersParams.decoder_upce1_preamble != null) {
            barcodeProps.putString("decoder_upce1_preamble", this.DecodersParams.decoder_upce1_preamble.toString());
        }
        if (this.DecodersParams.decoder_upce1_report_check_digit != null) {
            barcodeProps.putString("decoder_upce1_report_check_digit", this.DecodersParams.decoder_upce1_report_check_digit != false ? "true" : "false");
        }
        if (this.DecodersParams.decoder_us4state_fics != null) {
            barcodeProps.putString("decoder_us4state_fics", this.DecodersParams.decoder_us4state_fics != false ? "true" : "false");
        }
        if (this.DecodersParams.decoder_usplanet_report_check_digit != null) {
            barcodeProps.putString("decoder_usplanet_report_check_digit", this.DecodersParams.decoder_usplanet_report_check_digit != false ? "true" : "false");
        }
    }

    private void setupUPC_EANParams(Bundle barcodeProps) {
        if (this.UpcEan.databar_to_upc_ean != null) {
            barcodeProps.putString("databar_to_upc_ean", this.UpcEan.databar_to_upc_ean != false ? "true" : "false");
        }
        if (this.UpcEan.upcean_bookland != null) {
            barcodeProps.putString("upcean_bookland", this.UpcEan.upcean_bookland != false ? "true" : "false");
        }
        if (this.UpcEan.upcean_bookland_format != null) {
            barcodeProps.putString("upcean_bookland_format", this.UpcEan.upcean_bookland_format.toString());
        }
        if (this.UpcEan.upcean_coupon != null) {
            barcodeProps.putString("upcean_coupon", this.UpcEan.upcean_coupon != false ? "true" : "false");
        }
        if (this.UpcEan.upcean_coupon_report != null) {
            barcodeProps.putString("upcean_coupon_report", this.UpcEan.upcean_coupon_report.toString());
        }
        if (this.UpcEan.upcean_ean_zero_extend != null) {
            barcodeProps.putString("upcean_ean_zero_extend", this.UpcEan.upcean_ean_zero_extend != false ? "true" : "false");
        }
        if (this.UpcEan.upcean_retry_count != null) {
            barcodeProps.putString("upcean_retry_count", this.UpcEan.upcean_retry_count.toString());
        }
        if (this.UpcEan.upcean_security_level != null) {
            barcodeProps.putString("upcean_security_level", this.UpcEan.upcean_security_level.toString());
        }
        if (this.UpcEan.upcean_supplemental2 != null) {
            barcodeProps.putString("upcean_supplemental2", this.UpcEan.upcean_supplemental2 != false ? "true" : "false");
        }
        if (this.UpcEan.upcean_supplemental5 != null) {
            barcodeProps.putString("upcean_supplemental5", this.UpcEan.upcean_supplemental5 != false ? "true" : "false");
        }
        if (this.UpcEan.upcean_supplemental_mode != null) {
            barcodeProps.putString("upcean_supplemental_mode", this.UpcEan.upcean_supplemental_mode.toString());
        }
        if (this.UpcEan.upcean_linear_decode != null) {
            barcodeProps.putString("upcean_linear_decode", this.UpcEan.upcean_linear_decode != false ? "true" : "false");
        }
        if (this.UpcEan.upcean_random_weight_check_digit != null) {
            barcodeProps.putString("upcean_random_weight_check_digit", this.UpcEan.upcean_random_weight_check_digit != false ? "true" : "false");
        }
    }

    private void setupReaderParams(Bundle barcodeProps, boolean switchParams) {
        int remainder;
        if (this.ReaderParams.presentation_mode_sensitivity != null) {
            barcodeProps.putString("presentation_mode_sensitivity", this.ReaderParams.presentation_mode_sensitivity.toString());
        }
        if (this.ReaderParams.reader_mode != null) {
            barcodeProps.putString("reader_mode", this.ReaderParams.reader_mode.toString());
        }
        if (this.ReaderParams.scene_detect_qualifier != null) {
            barcodeProps.putString("presentation_mode_sensitivity", this.ReaderParams.scene_detect_qualifier.toString());
        }
        if (this.ReaderParams.aim_mode != null) {
            barcodeProps.putString("aim_mode", this.ReaderParams.aim_mode.toString());
        }
        if (this.ReaderParams.charset_name != null) {
            barcodeProps.putString("charset_name", this.ReaderParams.charset_name.toString());
        }
        if (this.ReaderParams.illumination_mode != null) {
            barcodeProps.putString("illumination_mode", this.ReaderParams.illumination_mode.toString());
        }
        if (this.ReaderParams.inverse_1d_mode != null) {
            barcodeProps.putString("inverse_1d_mode", this.ReaderParams.inverse_1d_mode.toString());
        }
        if (this.ReaderParams.lcd_mode != null) {
            barcodeProps.putString("lcd_mode", this.ReaderParams.lcd_mode.toString());
        }
        if (this.ReaderParams.linear_security_level != null) {
            barcodeProps.putString("linear_security_level", this.ReaderParams.linear_security_level.toString());
        }
        if (this.ReaderParams.low_power_timeout != null) {
            barcodeProps.putString("low_power_timeout", Integer.toString(this.ReaderParams.low_power_timeout));
        }
        if (this.ReaderParams.picklist != null) {
            barcodeProps.putString("picklist", this.ReaderParams.picklist.toString());
        }
        if (this.ReaderParams.poor_quality_bcdecode_effort_level != null) {
            barcodeProps.putString("poor_quality_bcdecode_effort_level", this.ReaderParams.poor_quality_bcdecode_effort_level.toString());
        }
        if (this.ReaderParams.aim_timer != null) {
            barcodeProps.putString("aim_timer", Integer.toString(this.ReaderParams.aim_timer));
        }
        if (this.ReaderParams.aim_type != null) {
            barcodeProps.putString("aim_type", this.ReaderParams.aim_type.toString());
        }
        if (this.ReaderParams.beam_timer != null) {
            barcodeProps.putString("beam_timer", Integer.toString(this.ReaderParams.beam_timer));
        }
        if (this.ReaderParams.different_barcode_timeout != null) {
            remainder = this.ReaderParams.different_barcode_timeout % 500;
            int different_barcode_timeout = this.ReaderParams.different_barcode_timeout / 500 * 500 + (remainder > 250 ? 500 : 0);
            barcodeProps.putString("different_barcode_timeout", Integer.toString(different_barcode_timeout));
        }
        if (this.ReaderParams.same_barcode_timeout != null) {
            remainder = this.ReaderParams.same_barcode_timeout % 500;
            int same_barcode_timeout = this.ReaderParams.same_barcode_timeout / 500 * 500 + (remainder > 250 ? 500 : 0);
            barcodeProps.putString("same_barcode_timeout", Integer.toString(same_barcode_timeout));
        }
        if (this.ReaderParams.scanning_mode != null) {
            barcodeProps.putString("scanning_mode", this.ReaderParams.scanning_mode.toString());
        }
        if (this.ReaderParams.oneD_marginless_decode_effort_level != null) {
            barcodeProps.putString("1d_marginless_decode_effort_level", this.ReaderParams.oneD_marginless_decode_effort_level.toString());
        }
    }

    private void setupScanParams(Bundle barcodeProps) {
        if (this.ScanParams.code_id_type != null) {
            barcodeProps.putString("code_id_type", this.ScanParams.code_id_type.toString());
        }
        if (this.ScanParams.decode_haptic_feedback != null) {
            barcodeProps.putString("decode_haptic_feedback", this.ScanParams.decode_haptic_feedback != false ? "true" : "false");
        }
        if (this.ScanParams.decode_audio_feedback_uri != null) {
            barcodeProps.putString("decode_audio_feedback_uri", this.ScanParams.decode_audio_feedback_uri.toString());
        }
        if (this.ScanParams.decoding_led_feedback != null) {
            barcodeProps.putString("decoding_led_feedback", this.ScanParams.decoding_led_feedback != false ? "true" : "false");
        }
        if (this.ScanParams.good_decode_led_timer != null) {
            barcodeProps.putString("good_decode_led_timer", this.ScanParams.good_decode_led_timer.toString());
        }
        if (this.ScanParams.volume_slider_type != null) {
            barcodeProps.putString("volume_slider_type", this.ScanParams.volume_slider_type.toString());
        }
    }

    private void setupMultiBarcode(Bundle barcodeProps) {
        if (this.MultiBarcode.multi_barcode_count != null) {
            barcodeProps.putString("multi_barcode_count", this.MultiBarcode.multi_barcode_count.toString());
        }
    }

    private void setupOtherParameters(Bundle barcodeProps) {
        if (this.trigger_wakeup != null) {
            barcodeProps.putString("trigger-wakeup", this.trigger_wakeup != false ? "true" : "false");
        }
        if (this.MarginLess.code128_enable_marginless_decode != null) {
            barcodeProps.putString("decoding_led_feedback", this.MarginLess.code128_enable_marginless_decode != false ? "true" : "false");
        }
        if (this.MarginLess.code39_enable_marginless_decode != null) {
            barcodeProps.putString("code39_enable_marginless_decode", this.MarginLess.code39_enable_marginless_decode != false ? "true" : "false");
        }
        if (this.MarginLess.upc_enable_marginless_decode != null) {
            barcodeProps.putString("upc_enable_marginless_decode", this.MarginLess.upc_enable_marginless_decode != false ? "true" : "false");
        }
        if (this.MarginLess.i20f5_enable_marginless_decode != null) {
            barcodeProps.putString("i20f5_enable_marginless_decode", this.MarginLess.i20f5_enable_marginless_decode != false ? "true" : "false");
        }
    }

    public Bundle getBarcodePluginBundleForSwitchParams() throws Exception {
        Bundle barcodeProps = new Bundle();
        if (this.scanner_input_enabled != null) {
            barcodeProps.putString("scanner_input_enabled", this.scanner_input_enabled != false ? "true" : "false");
        }
        if (this.scanner_selection_by_identifier != null) {
            barcodeProps.putString("scanner_selection_by_identifier", this.scanner_selection_by_identifier.toString());
        }
        this.setupDecoders(barcodeProps);
        this.setupDecodersParams(barcodeProps);
        this.setupUPC_EANParams(barcodeProps);
        this.setupReaderParams(barcodeProps, true);
        this.setupScanParams(barcodeProps);
        this.setupMultiBarcode(barcodeProps);
        this.setupOtherParameters(barcodeProps);
        return barcodeProps;
    }

    public class MarginLess {
        public Boolean code128_enable_marginless_decode = null;
        public Boolean code39_enable_marginless_decode = null;
        public Boolean upc_enable_marginless_decode = null;
        public Boolean i20f5_enable_marginless_decode = null;
    }

    public class MultiBarcode {
        public Integer multi_barcode_count = null;
    }

    public class ScanParams {
        public SC_E_CODE_ID_TYPE code_id_type = null;
        public Boolean decode_haptic_feedback = null;
        public String decode_audio_feedback_uri = null;
        public Boolean decoding_led_feedback = null;
        public Integer good_decode_led_timer = null;
        public SC_E_VOLUME_SLIDER_TYPE volume_slider_type = null;
    }

    public class ReaderParams {
        public SC_E_PRESENTATION_MODE_SENSITIVITY presentation_mode_sensitivity = null;
        public SC_E_READER_MODE reader_mode = null;
        public SC_E_SCENE_DETECT_QUALIFIER scene_detect_qualifier = null;
        public SC_E_AIM_MODE aim_mode = null;
        public SC_E_CHARSET_NAME charset_name = null;
        public SC_E_ILLUMINATION_MODE illumination_mode = null;
        public SC_E_INVERSE1DMODE_MODE inverse_1d_mode = null;
        public SC_E_LCD_MODE lcd_mode = null;
        public SC_E_LINEAR_SECURITY_LEVEL linear_security_level = null;
        public Integer low_power_timeout = null;
        public SC_E_PICKLIST_MODE picklist = null;
        public SC_E_POOR_QUALITY_DECODE_LEVEL poor_quality_bcdecode_effort_level = null;
        public Integer aim_timer = null;
        public SC_E_AIM_TYPE aim_type = null;
        public Integer beam_timer = null;
        public Integer different_barcode_timeout = null;
        public Integer same_barcode_timeout = null;
        public SC_E_SCANNINGMODE scanning_mode = null;
        public SC_E_1D_MARGINLESS_DECODE_EFFORT_LEVEL oneD_marginless_decode_effort_level = null;
    }

    public class UpcEan {
        public Boolean databar_to_upc_ean = null;
        public Boolean upcean_bookland = null;
        public SC_E_UPCEAN_BOOKLAND_FORMAT upcean_bookland_format = null;
        public Boolean upcean_coupon = null;
        public SC_E_UPCEAN_COUPON_REPORT upcean_coupon_report = null;
        public Boolean upcean_ean_zero_extend = null;
        public Integer upcean_retry_count = null;
        public SC_E_UPCEAN_SECURITY_LEVEL upcean_security_level = null;
        public Boolean upcean_supplemental2 = null;
        public Boolean upcean_supplemental5 = null;
        public SC_E_UPCEAN_SUPPLEMENTAL_MODE upcean_supplemental_mode = null;
        public Boolean upcean_linear_decode = null;
        public Boolean upcean_random_weight_check_digit = null;
    }

    public class DecodersParams {
        public Boolean decoder_codabar_clsi_editing = null;
        public Integer decoder_codabar_length1 = null;
        public Integer decoder_codabar_length2 = null;
        public Boolean decoder_codabar_notis_editing = null;
        public Boolean decoder_codabar_redundancy = null;
        public Integer decoder_code11_length1 = null;
        public Integer decoder_code11_length2 = null;
        public Boolean decoder_code11_redundancy = null;
        public Boolean decoder_code11_report_check_digit = null;
        public SC_E_CODE11_VERIFY_CHECK_DIGIT decoder_code11_verify_check_digit = null;
        public Boolean decoder_code128_check_isbt_table = null;
        public Boolean decoder_code128_enable_ean128 = null;
        public Boolean decoder_code128_enable_isbt128 = null;
        public Boolean decoder_code128_enable_plain = null;
        public SC_E_CONCAT_MODE decoder_code128_isbt128_concat_mode = null;
        public Integer decoder_code128_length1 = null;
        public Integer decoder_code128_length2 = null;
        public Boolean decoder_code128_redundancy = null;
        public SC_E_SECURITY_LEVEL decoder_code128_security_level = null;
        public Boolean code128_ignore_fnc4 = null;
        public Boolean decoder_code39_convert_to_code32 = null;
        public Boolean decoder_code39_full_ascii = null;
        public Integer decoder_code39_length1 = null;
        public Integer decoder_code39_length2 = null;
        public Boolean decoder_code39_redundancy = null;
        public Boolean decoder_code39_report_check_digit = null;
        public Boolean decoder_code39_report_code32_prefix = null;
        public SC_E_SECURITY_LEVEL decoder_code39_security_level = null;
        public Boolean decoder_code39_verify_check_digit = null;
        public Integer decoder_code93_length1 = null;
        public Integer decoder_code93_length2 = null;
        public Boolean decoder_code93_redundancy = null;
        public SC_E_LINK_MODE decoder_composite_ab_ucc_link_mode = null;
        public Integer decoder_d2of5_length1 = null;
        public Integer decoder_d2of5_length2 = null;
        public Boolean decoder_d2of5_redundancy = null;
        public Boolean decoder_ean8_convert_to_ean13 = null;
        public Boolean decoder_gs1_databar_exp = null;
        public Boolean decoder_gs1_databar_lim = null;
        public SC_E_SECURITY_LEVEL decoder_gs1_lim_security_level = null;
        public SC_E_INVERSE decoder_hanxin_inverse = null;
        public SC_E_I2OF5_CHECK_DIGIT decoder_i2of5_check_digit = null;
        public Integer decoder_i2of5_length1 = null;
        public Integer decoder_i2of5_length2 = null;
        public Boolean decoder_i2of5_redundancy = null;
        public Boolean decoder_i2of5_report_check_digit = null;
        public SC_E_SECURITY_LEVEL decoder_i2of5_security_level = null;
        @Deprecated
        public Boolean decoder_i2of5_convert_to_ean13 = null;
        public Boolean decoder_itf14_convert_to_ean13 = null;
        public Integer decoder_matrix_2of5_length1 = null;
        public Integer decoder_matrix_2of5_length2 = null;
        public Boolean decoder_matrix_2of5_redundancy = null;
        public Boolean decoder_matrix_2of5_report_check_digit = null;
        public Boolean decoder_matrix_2of5_verify_check_digit = null;
        public SC_E_MSI_CHECK_DIGIT decoder_msi_check_digit = null;
        public SC_E_MSI_CHECK_DIGIT_SCHEME decoder_msi_check_digit_scheme = null;
        public Integer decoder_msi_length1 = null;
        public Integer decoder_msi_length2 = null;
        public Boolean decoder_msi_redundancy = null;
        public Boolean decoder_msi_report_check_digit = null;
        public Boolean decoder_trioptic39_redundancy = null;
        public Boolean decoder_uk_postal_report_check_digit = null;
        public SC_E_PREAMBLE decoder_upca_preamble = null;
        public Boolean decoder_upca_report_check_digit = null;
        public Boolean decoder_upce0_convert_to_upca = null;
        public SC_E_PREAMBLE decoder_upce0_preamble = null;
        public Boolean decoder_upce0_report_check_digit = null;
        public Boolean decoder_upce1_convert_to_upca = null;
        public SC_E_PREAMBLE decoder_upce1_preamble = null;
        public Boolean decoder_upce1_report_check_digit = null;
        public Boolean decoder_us4state_fics = null;
        public Boolean decoder_usplanet_report_check_digit = null;
    }

    public class Decoders {
        public Boolean decoder_australian_postal = null;
        public Boolean decoder_aztec = null;
        public Boolean decoder_canadian_postal = null;
        public Boolean decoder_chinese_2of5 = null;
        public Boolean decoder_codabar = null;
        public Boolean decoder_code11 = null;
        public Boolean decoder_code128 = null;
        public Boolean decoder_code39 = null;
        public Boolean decoder_code93 = null;
        public Boolean decoder_composite_ab = null;
        public Boolean decoder_composite_c = null;
        public Boolean decoder_d2of5 = null;
        public Boolean decoder_datamatrix = null;
        public Boolean decoder_dutch_postal = null;
        public Boolean decoder_ean13 = null;
        public Boolean decoder_ean8 = null;
        public Boolean decoder_gs1_databar = null;
        public Boolean decoder_gs1_qrcode = null;
        public Boolean decoder_hanxin = null;
        public Boolean decoder_i2of5 = null;
        public Boolean decoder_japanese_postal = null;
        public Boolean decoder_korean_3of5 = null;
        public Boolean decoder_mailmark = null;
        public Boolean decoder_matrix_2of5 = null;
        public Boolean decoder_maxicode = null;
        public Boolean decoder_micropdf = null;
        public Boolean decoder_microqr = null;
        public Boolean decoder_msi = null;
        public Boolean decoder_pdf417 = null;
        public Boolean decoder_qrcode = null;
        public Boolean decoder_signature = null;
        public Boolean decoder_tlc39 = null;
        public Boolean decoder_trioptic39 = null;
        public Boolean decoder_uk_postal = null;
        public Boolean decoder_upca = null;
        public Boolean decoder_upce0 = null;
        public Boolean decoder_upce1 = null;
        public Boolean decoder_us4state = null;
        public Boolean decoder_usplanet = null;
        public Boolean decoder_uspostnet = null;
        public Boolean decoder_webcode = null;
    }
}

