/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.datawedgeprofileintents;

import android.content.Context;
import android.os.Looper;
import android.util.Pair;
import com.zebra.datawedgeprofileintents.DWEnumerateScanners;
import com.zebra.datawedgeprofileintents.DWEnumerateScannersSettings;
import com.zebra.datawedgeprofileintents.DWProfileBaseSettings;
import com.zebra.datawedgeprofileintents.DWProfileChecker;
import com.zebra.datawedgeprofileintents.DWProfileCheckerSettings;
import com.zebra.datawedgeprofileintents.DWProfileCommandBase;
import com.zebra.datawedgeprofileintents.DWProfileDelete;
import com.zebra.datawedgeprofileintents.DWProfileDeleteSettings;
import com.zebra.datawedgeprofileintents.DWProfileSetConfig;
import com.zebra.datawedgeprofileintents.DWProfileSetConfigSettings;
import com.zebra.datawedgeprofileintents.DWProfileSwitchBarcodeParams;
import com.zebra.datawedgeprofileintents.DWProfileSwitchBarcodeParamsSettings;
import com.zebra.datawedgeprofileintents.DWScannerPluginDisable;
import com.zebra.datawedgeprofileintents.DWScannerPluginEnable;
import com.zebra.datawedgeprofileintents.DWScannerPluginStatus;
import com.zebra.datawedgeprofileintents.DWScannerStartScan;
import com.zebra.datawedgeprofileintents.DWScannerStopScan;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;

public class DWSynchronousMethods {
    private String mLastMessage = "";
    private EResults mLastResult = EResults.NONE;
    private boolean mIsDWPluginEnabledResult = false;
    private List<DWEnumerateScanners.Scanner> mEnumerateScannersReturnList = null;
    private CountDownLatch mJobDoneLatch = null;
    private Context mContext = null;

    public DWSynchronousMethods(Context context) {
        this.mContext = context;
    }

    public String getLastMessage() {
        return this.mLastMessage;
    }

    public Pair<EResults, String> setupDWProfile(final DWProfileSetConfigSettings settings) {
        settings.mProfileName = this.mContext.getPackageName();
        this.deleteProfile(settings.mProfileName);
        if (this.mJobDoneLatch != null) {
            this.mLastMessage = "DataWedge Service: Error, a job is already running in background. Please wait for it to finish or timeout.";
            return new Pair((Object)EResults.FAILED, (Object)"DataWedge Service: Error, a job is already running in background. Please wait for it to finish or timeout.");
        }
        this.mJobDoneLatch = new CountDownLatch(1);
        if (settings.mEnableTimeOutMechanism) {
            try {
                Looper.prepare();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        DWProfileSetConfig setConfig = new DWProfileSetConfig(this.mContext);
        DWProfileCommandBase.onProfileCommandResult onSetConfigCommandResult = new DWProfileCommandBase.onProfileCommandResult(){

            @Override
            public void result(String profileName, String action, String command, String result, String resultInfo, String commandidentifier) {
                if (result.equalsIgnoreCase("SUCCESS")) {
                    DWSynchronousMethods.this.mLastMessage = "Setup DataWedge: succeeded for profile:" + settings.mProfileName;
                    DWSynchronousMethods.this.mLastResult = EResults.SUCCEEDED;
                    DWSynchronousMethods.this.mJobDoneLatch.countDown();
                } else {
                    DWSynchronousMethods.this.mLastMessage = "Setup Scanner: error on profile(" + settings.mProfileName + "):" + resultInfo;
                    DWSynchronousMethods.this.mLastResult = EResults.FAILED;
                    DWSynchronousMethods.this.mJobDoneLatch.countDown();
                }
            }

            @Override
            public void timeout(String profileName) {
                DWSynchronousMethods.this.mLastMessage = "Setup Scanner: timeout while trying to setup profile: " + settings.mProfileName;
                DWSynchronousMethods.this.mLastResult = EResults.TIMEOUT;
                DWSynchronousMethods.this.mJobDoneLatch.countDown();
            }
        };
        setConfig.execute(settings, onSetConfigCommandResult);
        try {
            this.mJobDoneLatch.await();
            this.mJobDoneLatch = null;
            return new Pair((Object)this.mLastResult, (Object)this.mLastMessage);
        }
        catch (InterruptedException e) {
            if (this.mJobDoneLatch != null) {
                while (this.mJobDoneLatch.getCount() > 0L) {
                    this.mJobDoneLatch.countDown();
                }
                this.mJobDoneLatch = null;
            }
            return new Pair((Object)EResults.FAILED, (Object)("Setup Scanner: Exception while waiting for CountDownLatch : " + e.getMessage()));
        }
    }

    public Pair<EResults, String> enablePlugin() {
        return this.enablePlugin(this.mContext.getPackageName());
    }

    public Pair<EResults, String> enablePlugin(final String profileName) {
        if (this.mJobDoneLatch != null) {
            return new Pair((Object)EResults.FAILED, (Object)"DataWedge Service: Error, a job is already running in background. Please wait for it to finish or timeout.");
        }
        this.mJobDoneLatch = new CountDownLatch(1);
        DWProfileBaseSettings settings = new DWProfileBaseSettings(){
            {
                this.mProfileName = profileName;
            }
        };
        try {
            Looper.prepare();
        }
        catch (Exception exception) {
            // empty catch block
        }
        DWScannerPluginEnable dwpluginenable = new DWScannerPluginEnable(this.mContext);
        dwpluginenable.execute(settings, new DWProfileCommandBase.onProfileCommandResult(){

            @Override
            public void result(String profileName, String action, String command, String result, String resultInfo, String commandidentifier) {
                if (result.equalsIgnoreCase("SUCCESS")) {
                    DWSynchronousMethods.this.mLastMessage = "Enable Scanner: succeeded for profile:" + profileName;
                    DWSynchronousMethods.this.mLastResult = EResults.SUCCEEDED;
                    DWSynchronousMethods.this.mJobDoneLatch.countDown();
                } else {
                    DWSynchronousMethods.this.mLastMessage = "Enable Scanner: error on profile(" + profileName + "):" + resultInfo;
                    DWSynchronousMethods.this.mLastResult = EResults.FAILED;
                    DWSynchronousMethods.this.mJobDoneLatch.countDown();
                }
            }

            @Override
            public void timeout(String profileName) {
                DWSynchronousMethods.this.mLastMessage = "Enable Scanner: timeout while trying to enable scanner on profile: " + profileName;
                DWSynchronousMethods.this.mLastResult = EResults.TIMEOUT;
                DWSynchronousMethods.this.mJobDoneLatch.countDown();
            }
        });
        try {
            this.mJobDoneLatch.await();
            this.mJobDoneLatch = null;
            return new Pair((Object)this.mLastResult, (Object)this.mLastMessage);
        }
        catch (InterruptedException e) {
            if (this.mJobDoneLatch != null) {
                while (this.mJobDoneLatch.getCount() > 0L) {
                    this.mJobDoneLatch.countDown();
                }
                this.mJobDoneLatch = null;
            }
            return new Pair((Object)EResults.FAILED, (Object)("Enable Scanner: Exception while waiting for CountDownLatch : " + e.getMessage()));
        }
    }

    public Pair<EResults, String> disablePlugin() {
        return this.disablePlugin(this.mContext.getPackageName());
    }

    public Pair<EResults, String> disablePlugin(final String profileName) {
        if (this.mJobDoneLatch != null) {
            return new Pair((Object)EResults.FAILED, (Object)"DataWedge Service: Error, a job is already running in background. Please wait for it to finish or timeout.");
        }
        this.mJobDoneLatch = new CountDownLatch(1);
        DWProfileBaseSettings settings = new DWProfileBaseSettings(){
            {
                this.mProfileName = profileName;
            }
        };
        try {
            Looper.prepare();
        }
        catch (Exception exception) {
            // empty catch block
        }
        DWScannerPluginDisable dwplugindisable = new DWScannerPluginDisable(this.mContext);
        dwplugindisable.execute(settings, new DWProfileCommandBase.onProfileCommandResult(){

            @Override
            public void result(String profileName, String action, String command, String result, String resultInfo, String commandidentifier) {
                if (result.equalsIgnoreCase("SUCCESS")) {
                    DWSynchronousMethods.this.mLastMessage = "Disable Scanner: succeeded for profile:" + profileName;
                    DWSynchronousMethods.this.mLastResult = EResults.SUCCEEDED;
                    DWSynchronousMethods.this.mJobDoneLatch.countDown();
                } else {
                    DWSynchronousMethods.this.mLastMessage = "Disable Scanner: error on profile(" + profileName + "):" + resultInfo;
                    DWSynchronousMethods.this.mLastResult = EResults.FAILED;
                    DWSynchronousMethods.this.mJobDoneLatch.countDown();
                }
            }

            @Override
            public void timeout(String profileName) {
                DWSynchronousMethods.this.mLastMessage = "Disable Scanner: timeout while trying to enable scanner on profile: " + profileName;
                DWSynchronousMethods.this.mLastResult = EResults.TIMEOUT;
                DWSynchronousMethods.this.mJobDoneLatch.countDown();
            }
        });
        try {
            this.mJobDoneLatch.await();
            this.mJobDoneLatch = null;
            return new Pair((Object)this.mLastResult, (Object)this.mLastMessage);
        }
        catch (InterruptedException e) {
            if (this.mJobDoneLatch != null) {
                while (this.mJobDoneLatch.getCount() > 0L) {
                    this.mJobDoneLatch.countDown();
                }
                this.mJobDoneLatch = null;
            }
            return new Pair((Object)EResults.FAILED, (Object)("Disable Scanner: Exception while waiting for CountDownLatch : " + e.getMessage()));
        }
    }

    public Pair<EResults, String> startScan() {
        return this.startScan(this.mContext.getPackageName());
    }

    public Pair<EResults, String> startScan(final String profileName) {
        if (this.mJobDoneLatch != null) {
            return new Pair((Object)EResults.FAILED, (Object)"Start Scan: Error, a job is already running in background. Please wait for it to finish or timeout.");
        }
        this.mJobDoneLatch = new CountDownLatch(1);
        DWProfileBaseSettings settings = new DWProfileBaseSettings(){
            {
                this.mProfileName = profileName;
            }
        };
        try {
            Looper.prepare();
        }
        catch (Exception exception) {
            // empty catch block
        }
        DWScannerStartScan dwstartscan = new DWScannerStartScan(this.mContext);
        dwstartscan.execute(settings, new DWProfileCommandBase.onProfileCommandResult(){

            @Override
            public void result(String profileName, String action, String command, String result, String resultInfo, String commandidentifier) {
                if (result.equalsIgnoreCase("SUCCESS")) {
                    DWSynchronousMethods.this.mLastMessage = "Start Scanner: succeeded for profile:" + profileName;
                    DWSynchronousMethods.this.mLastResult = EResults.SUCCEEDED;
                    DWSynchronousMethods.this.mJobDoneLatch.countDown();
                } else {
                    DWSynchronousMethods.this.mLastMessage = "Start Scanner: error on profile(" + profileName + "):" + resultInfo;
                    DWSynchronousMethods.this.mLastResult = EResults.FAILED;
                    DWSynchronousMethods.this.mJobDoneLatch.countDown();
                }
            }

            @Override
            public void timeout(String profileName) {
                DWSynchronousMethods.this.mLastMessage = "Start Scanner: timeout while trying to enable scanner on profile: " + profileName;
                DWSynchronousMethods.this.mLastResult = EResults.TIMEOUT;
                DWSynchronousMethods.this.mJobDoneLatch.countDown();
            }
        });
        try {
            this.mJobDoneLatch.await();
            this.mJobDoneLatch = null;
            return new Pair((Object)this.mLastResult, (Object)this.mLastMessage);
        }
        catch (InterruptedException e) {
            if (this.mJobDoneLatch != null) {
                while (this.mJobDoneLatch.getCount() > 0L) {
                    this.mJobDoneLatch.countDown();
                }
                this.mJobDoneLatch = null;
            }
            return new Pair((Object)EResults.FAILED, (Object)("Start Scan: Exception while waiting for CountDownLatch : " + e.getMessage()));
        }
    }

    public Pair<EResults, String> stopScan() {
        return this.stopScan(this.mContext.getPackageName());
    }

    public Pair<EResults, String> stopScan(final String profileName) {
        if (this.mJobDoneLatch != null) {
            return new Pair((Object)EResults.FAILED, (Object)"Stop Scan: Error, a job is already running in background. Please wait for it to finish or timeout.");
        }
        this.mJobDoneLatch = new CountDownLatch(1);
        DWProfileBaseSettings settings = new DWProfileBaseSettings(){
            {
                this.mProfileName = profileName;
            }
        };
        try {
            Looper.prepare();
        }
        catch (Exception exception) {
            // empty catch block
        }
        DWScannerStopScan dwstopscan = new DWScannerStopScan(this.mContext);
        dwstopscan.execute(settings, new DWProfileCommandBase.onProfileCommandResult(){

            @Override
            public void result(String profileName, String action, String command, String result, String resultInfo, String commandidentifier) {
                if (result.equalsIgnoreCase("SUCCESS")) {
                    DWSynchronousMethods.this.mLastMessage = "Stop Scanner: succeeded for profile:" + profileName;
                    DWSynchronousMethods.this.mLastResult = EResults.SUCCEEDED;
                    DWSynchronousMethods.this.mJobDoneLatch.countDown();
                } else {
                    DWSynchronousMethods.this.mLastMessage = "Stop Scanner: error on profile(" + profileName + "):" + resultInfo;
                    DWSynchronousMethods.this.mLastResult = EResults.FAILED;
                    DWSynchronousMethods.this.mJobDoneLatch.countDown();
                }
            }

            @Override
            public void timeout(String profileName) {
                DWSynchronousMethods.this.mLastMessage = "Stop Scanner: timeout while trying to enable scanner on profile: " + profileName;
                DWSynchronousMethods.this.mLastResult = EResults.TIMEOUT;
                DWSynchronousMethods.this.mJobDoneLatch.countDown();
            }
        });
        try {
            this.mJobDoneLatch.await();
            this.mJobDoneLatch = null;
            return new Pair((Object)this.mLastResult, (Object)this.mLastMessage);
        }
        catch (InterruptedException e) {
            if (this.mJobDoneLatch != null) {
                while (this.mJobDoneLatch.getCount() > 0L) {
                    this.mJobDoneLatch.countDown();
                }
                this.mJobDoneLatch = null;
            }
            return new Pair((Object)EResults.FAILED, (Object)("Stop Scan: Exception while waiting for CountDownLatch : " + e.getMessage()));
        }
    }

    public Pair<EResults, String> profileExists() {
        return this.profileExists(this.mContext.getPackageName());
    }

    public Pair<EResults, String> profileExists(final String profileName) {
        if (this.mJobDoneLatch != null) {
            return new Pair((Object)EResults.FAILED, (Object)"profileExists: Error, a job is already running in background. Please wait for it to finish or timeout.");
        }
        this.mJobDoneLatch = new CountDownLatch(1);
        DWProfileCheckerSettings settings = new DWProfileCheckerSettings(){
            {
                this.mProfileName = profileName;
            }
        };
        try {
            Looper.prepare();
        }
        catch (Exception exception) {
            // empty catch block
        }
        DWProfileChecker dwprofilechecker = new DWProfileChecker(this.mContext);
        dwprofilechecker.execute(settings, new DWProfileChecker.onProfileExistResult(){

            @Override
            public void result(String profileName, boolean exists) {
                if (exists) {
                    DWSynchronousMethods.this.mLastMessage = profileName + " exists.";
                    DWSynchronousMethods.this.mLastResult = EResults.SUCCEEDED;
                } else {
                    DWSynchronousMethods.this.mLastMessage = profileName + " does not exists.";
                    DWSynchronousMethods.this.mLastResult = EResults.FAILED;
                }
                DWSynchronousMethods.this.mJobDoneLatch.countDown();
            }

            @Override
            public void timeOut(String profileName) {
                DWSynchronousMethods.this.mLastMessage = "profileExists: timeout while trying to enable check if profile exists: " + profileName;
                DWSynchronousMethods.this.mLastResult = EResults.TIMEOUT;
                DWSynchronousMethods.this.mJobDoneLatch.countDown();
            }
        });
        try {
            this.mJobDoneLatch.await();
            this.mJobDoneLatch = null;
            return new Pair((Object)this.mLastResult, (Object)this.mLastMessage);
        }
        catch (InterruptedException e) {
            if (this.mJobDoneLatch != null) {
                while (this.mJobDoneLatch.getCount() > 0L) {
                    this.mJobDoneLatch.countDown();
                }
                this.mJobDoneLatch = null;
            }
            return new Pair((Object)EResults.FAILED, (Object)("profileExists: Exception while waiting for CountDownLatch : " + e.getMessage()));
        }
    }

    public Pair<EResults, String> isDWPluginEnabled() {
        return this.isDWPluginEnabled(this.mContext.getPackageName());
    }

    public Pair<EResults, String> isDWPluginEnabled(final String profileName) {
        if (this.mJobDoneLatch != null) {
            return new Pair((Object)EResults.FAILED, (Object)"isDWPluginEnabled: Error, a job is already running in background. Please wait for it to finish or timeout.");
        }
        this.mJobDoneLatch = new CountDownLatch(1);
        DWProfileBaseSettings settings = new DWProfileBaseSettings(){
            {
                this.mProfileName = profileName;
            }
        };
        try {
            Looper.prepare();
        }
        catch (Exception exception) {
            // empty catch block
        }
        DWScannerPluginStatus dwScannerPluginStatus = new DWScannerPluginStatus(this.mContext);
        dwScannerPluginStatus.execute(settings, new DWScannerPluginStatus.onScannerPluginStatus(){

            @Override
            public void result(String profileName, boolean isEnabled) {
                if (isEnabled) {
                    DWSynchronousMethods.this.mLastMessage = "true";
                    DWSynchronousMethods.this.mLastResult = EResults.SUCCEEDED;
                } else {
                    DWSynchronousMethods.this.mLastMessage = "false";
                    DWSynchronousMethods.this.mLastResult = EResults.FAILED;
                }
                DWSynchronousMethods.this.mJobDoneLatch.countDown();
            }

            @Override
            public void timeOut(String profileName) {
                DWSynchronousMethods.this.mLastMessage = "isDWPluginEnabled: timeout while trying to enable check if profile exists: " + profileName;
                DWSynchronousMethods.this.mLastResult = EResults.TIMEOUT;
                DWSynchronousMethods.this.mJobDoneLatch.countDown();
            }
        });
        try {
            this.mJobDoneLatch.await();
            this.mJobDoneLatch = null;
            return new Pair((Object)this.mLastResult, (Object)this.mLastMessage);
        }
        catch (InterruptedException e) {
            if (this.mJobDoneLatch != null) {
                while (this.mJobDoneLatch.getCount() > 0L) {
                    this.mJobDoneLatch.countDown();
                }
                this.mJobDoneLatch = null;
            }
            return new Pair((Object)EResults.FAILED, (Object)("isDWPluginEnabled: Exception while waiting for CountDownLatch : " + e.getMessage()));
        }
    }

    public Pair<EResults, String> deleteProfile() {
        return this.deleteProfile(this.mContext.getPackageName());
    }

    public Pair<EResults, String> deleteProfile(final String profileName) {
        if (this.mJobDoneLatch != null) {
            return new Pair((Object)EResults.FAILED, (Object)"deleteProfile: Error, a job is already running in background. Please wait for it to finish or timeout.");
        }
        this.mJobDoneLatch = new CountDownLatch(1);
        DWProfileDeleteSettings settings = new DWProfileDeleteSettings(){
            {
                this.mProfileName = profileName;
            }
        };
        try {
            Looper.prepare();
        }
        catch (Exception exception) {
            // empty catch block
        }
        DWProfileDelete dwprofileDelete = new DWProfileDelete(this.mContext);
        dwprofileDelete.execute(settings, new DWProfileCommandBase.onProfileCommandResult(){

            @Override
            public void result(String profileName, String action, String command, String result, String resultInfo, String commandidentifier) {
                if (result.equalsIgnoreCase("SUCCESS")) {
                    DWSynchronousMethods.this.mLastMessage = "Profile: " + profileName + " delete succeeded";
                    DWSynchronousMethods.this.mLastResult = EResults.SUCCEEDED;
                    DWSynchronousMethods.this.mJobDoneLatch.countDown();
                } else {
                    DWSynchronousMethods.this.mLastMessage = "Error while trying to delete profile: " + profileName + "\n" + resultInfo;
                    DWSynchronousMethods.this.mLastResult = EResults.FAILED;
                    DWSynchronousMethods.this.mJobDoneLatch.countDown();
                }
            }

            @Override
            public void timeout(String profileName) {
                DWSynchronousMethods.this.mLastMessage = "deleteProfile: timeout while trying to delete profile: " + profileName;
                DWSynchronousMethods.this.mLastResult = EResults.TIMEOUT;
                DWSynchronousMethods.this.mJobDoneLatch.countDown();
            }
        });
        try {
            this.mJobDoneLatch.await();
            this.mJobDoneLatch = null;
            return new Pair((Object)this.mLastResult, (Object)this.mLastMessage);
        }
        catch (InterruptedException e) {
            if (this.mJobDoneLatch != null) {
                while (this.mJobDoneLatch.getCount() > 0L) {
                    this.mJobDoneLatch.countDown();
                }
                this.mJobDoneLatch = null;
            }
            return new Pair((Object)EResults.FAILED, (Object)("deleteProfile: Exception while waiting for CountDownLatch : " + e.getMessage()));
        }
    }

    public Pair<EResults, String> switchBarcodeParams(DWProfileSwitchBarcodeParamsSettings settings) {
        if (this.mJobDoneLatch != null) {
            return new Pair((Object)EResults.FAILED, (Object)"switchBarcodeParams: Error, a job is already running in background. Please wait for it to finish or timeout.");
        }
        this.mJobDoneLatch = new CountDownLatch(1);
        settings.mProfileName = this.mContext.getPackageName();
        try {
            Looper.prepare();
        }
        catch (Exception exception) {
            // empty catch block
        }
        DWProfileSwitchBarcodeParams dwProfileSwitchBarcodeParams = new DWProfileSwitchBarcodeParams(this.mContext);
        dwProfileSwitchBarcodeParams.execute(settings, new DWProfileCommandBase.onProfileCommandResult(){

            @Override
            public void result(String profileName, String action, String command, String result, String resultInfo, String commandidentifier) {
                if (result.equalsIgnoreCase("SUCCESS")) {
                    DWSynchronousMethods.this.mLastMessage = "Profile: " + profileName + " barcode parameters updated successfully";
                    DWSynchronousMethods.this.mLastResult = EResults.SUCCEEDED;
                    DWSynchronousMethods.this.mJobDoneLatch.countDown();
                } else {
                    DWSynchronousMethods.this.mLastMessage = "Error while trying to update barcode parameters on profile: " + profileName + "\n" + resultInfo;
                    DWSynchronousMethods.this.mLastResult = EResults.FAILED;
                    DWSynchronousMethods.this.mJobDoneLatch.countDown();
                }
            }

            @Override
            public void timeout(String profileName) {
                DWSynchronousMethods.this.mLastMessage = "deleteProfile: timeout while trying to delete profile: " + profileName;
                DWSynchronousMethods.this.mLastResult = EResults.TIMEOUT;
                DWSynchronousMethods.this.mJobDoneLatch.countDown();
            }
        });
        try {
            this.mJobDoneLatch.await();
            this.mJobDoneLatch = null;
            return new Pair((Object)this.mLastResult, (Object)this.mLastMessage);
        }
        catch (InterruptedException e) {
            if (this.mJobDoneLatch != null) {
                while (this.mJobDoneLatch.getCount() > 0L) {
                    this.mJobDoneLatch.countDown();
                }
                this.mJobDoneLatch = null;
            }
            return new Pair((Object)EResults.FAILED, (Object)("switchBarcodeParams: Exception while waiting for CountDownLatch : " + e.getMessage()));
        }
    }

    public Pair<EResults, Pair<String, List<DWEnumerateScanners.Scanner>>> enumerateScanners(DWEnumerateScannersSettings settings) {
        if (this.mJobDoneLatch != null) {
            return new Pair((Object)EResults.FAILED, (Object)new Pair((Object)"enumerateScanners: Error, a job is already running in background. Please wait for it to finish or timeout.", (Object)null));
        }
        this.mEnumerateScannersReturnList = null;
        this.mJobDoneLatch = new CountDownLatch(1);
        settings.mProfileName = this.mContext.getPackageName();
        try {
            Looper.prepare();
        }
        catch (Exception exception) {
            // empty catch block
        }
        DWEnumerateScanners dwEnumerateScanners = new DWEnumerateScanners(this.mContext);
        dwEnumerateScanners.execute(settings, new DWEnumerateScanners.onEnumerateScannerResult(){

            @Override
            public void result(String profileName, List<DWEnumerateScanners.Scanner> scannerList) {
                if (scannerList != null && scannerList.size() != 0) {
                    DWSynchronousMethods.this.mLastMessage = "enumerateScanners: Scanners enumerated successfully.";
                    DWSynchronousMethods.this.mLastResult = EResults.SUCCEEDED;
                    DWSynchronousMethods.this.mEnumerateScannersReturnList = new ArrayList<DWEnumerateScanners.Scanner>(scannerList);
                    DWSynchronousMethods.this.mJobDoneLatch.countDown();
                } else {
                    DWSynchronousMethods.this.mLastMessage = "enumerateScanners: Error while trying to enumerate scanners, returned list is empty.";
                    DWSynchronousMethods.this.mLastResult = EResults.FAILED;
                    DWSynchronousMethods.this.mEnumerateScannersReturnList = null;
                    DWSynchronousMethods.this.mJobDoneLatch.countDown();
                }
            }

            @Override
            public void timeOut(String profileName) {
                DWSynchronousMethods.this.mLastMessage = "enumerateScanners: timeout while trying to enumerate scanners.";
                DWSynchronousMethods.this.mLastResult = EResults.TIMEOUT;
                DWSynchronousMethods.this.mEnumerateScannersReturnList = null;
                DWSynchronousMethods.this.mJobDoneLatch.countDown();
            }
        });
        try {
            this.mJobDoneLatch.await();
            this.mJobDoneLatch = null;
            return new Pair((Object)this.mLastResult, (Object)new Pair((Object)this.mLastMessage, this.mEnumerateScannersReturnList));
        }
        catch (InterruptedException e) {
            if (this.mJobDoneLatch != null) {
                while (this.mJobDoneLatch.getCount() > 0L) {
                    this.mJobDoneLatch.countDown();
                }
                this.mJobDoneLatch = null;
            }
            this.mEnumerateScannersReturnList = null;
            return new Pair((Object)EResults.FAILED, (Object)new Pair((Object)("switchBarcodeParams: Exception while waiting for CountDownLatch : " + e.getMessage()), this.mEnumerateScannersReturnList));
        }
    }

    public static enum EResults {
        SUCCEEDED,
        FAILED,
        TIMEOUT,
        NONE;

    }
}

