/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server;

import io.undertow.io.AsyncSenderImpl;
import io.undertow.io.BlockingSenderImpl;
import io.undertow.io.Sender;
import io.undertow.server.BlockingHttpExchange;
import io.undertow.server.handlers.Cookie;
import io.undertow.util.HeaderMap;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import scala.Array$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.StringContext$;
import scala.collection.ArrayOps$;
import scala.collection.Map;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.scalanative.unsafe.Ptr;
import snunit.Headers$package$;
import snunit.Request$package$;
import snunit.StatusCode;

public final class HttpServerExchange {
    private final Ptr<?> req;
    private int state;
    private final HeaderMap responseHeaders;
    private BlockingHttpExchange blockingHttpExchange;
    private Sender sender;

    public HttpServerExchange(Ptr<?> req) {
        this.req = req;
        this.state = 200;
        this.responseHeaders = new HeaderMap();
        this.blockingHttpExchange = null;
        this.sender = null;
    }

    public Ptr<?> req() {
        return this.req;
    }

    public int io$undertow$server$HttpServerExchange$$state() {
        return this.state;
    }

    private void state_$eq(int x$0) {
        this.state = x$0;
    }

    public HeaderMap io$undertow$server$HttpServerExchange$$responseHeaders() {
        return this.responseHeaders;
    }

    public HeaderMap getRequestHeaders() {
        return new HeaderMap((Map<String, String>)Headers$package$.MODULE$.toMap(Request$package$.MODULE$.headers(this.req())));
    }

    public HeaderMap getResponseHeaders() {
        return this.io$undertow$server$HttpServerExchange$$responseHeaders();
    }

    public String getRequestMethod() {
        return Request$package$.MODULE$.method(this.req());
    }

    public InputStream getInputStream() {
        return this.blockingHttpExchange.getInputStream();
    }

    public java.util.Map<String, Cookie> getRequestCookies() {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public HttpServerExchange setResponseCookie(Cookie cookie) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public int getStatusCode() {
        return this.io$undertow$server$HttpServerExchange$$state();
    }

    public HttpServerExchange setStatusCode(int statusCode) {
        this.state_$eq(statusCode);
        return this;
    }

    public Sender getResponseSender() {
        if (this.blockingHttpExchange != null) {
            return this.blockingHttpExchange.getSender();
        }
        if (this.sender != null) {
            return this.sender;
        }
        this.sender = new AsyncSenderImpl(this);
        return this.sender;
    }

    public java.util.Map<String, Deque<String>> getQueryParameters() {
        HashMap<String, Deque<String>> result = new HashMap<String, Deque<String>>();
        Object object = Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(Request$package$.MODULE$.query(this.req())), '&'));
        ArrayOps$.MODULE$.foreach$extension(object, (Function1 & Serializable)x$1 -> {
            Seq seq;
            Option option;
            String string = x$1;
            if (string != null && !(option = StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", "=", ""})).s().unapplySeq(string)).isEmpty() && (seq = (Seq)option.get()).lengthCompare(2) == 0) {
                String string2 = (String)seq.apply(0);
                String string3 = (String)seq.apply(1);
                String key = string2;
                String value = string3;
                return HttpServerExchange.add$1(result, key, value);
            }
            if ("".equals(string)) {
                return BoxedUnit.UNIT;
            }
            String key = string;
            return HttpServerExchange.add$1(result, key, "");
        });
        return result;
    }

    public OutputStream getOutputStream() {
        return this.blockingHttpExchange.getOutputStream();
    }

    public boolean isComplete() {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public String getRequestURI() {
        return StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(Request$package$.MODULE$.target(this.req())), '?')[0];
    }

    public String getRequestPath() {
        return Request$package$.MODULE$.path(this.req());
    }

    public BlockingHttpExchange startBlocking() {
        BlockingHttpExchange old = this.blockingHttpExchange;
        this.blockingHttpExchange = new DefaultBlockingHttpExchange(this);
        return old;
    }

    public HttpServerExchange endExchange() {
        if (this.blockingHttpExchange != null) {
            this.blockingHttpExchange.close();
        }
        return this;
    }

    private static final Object add$1(HashMap result$1, String key, String value) {
        Deque deque = (Deque)result$1.get(key);
        if (deque == null) {
            LinkedList<String> list = new LinkedList<String>();
            list.add(value);
            return result$1.put(key, list);
        }
        Deque list = deque;
        return BoxesRunTime.boxToBoolean((boolean)list.add(value));
    }

    public static class DefaultBlockingHttpExchange
    implements BlockingHttpExchange {
        public final HttpServerExchange io$undertow$server$HttpServerExchange$DefaultBlockingHttpExchange$$exchange;
        private InputStream inputStream;
        private OutputStream outputStream;
        private Sender sender;

        public DefaultBlockingHttpExchange(HttpServerExchange exchange) {
            this.io$undertow$server$HttpServerExchange$DefaultBlockingHttpExchange$$exchange = exchange;
            this.inputStream = null;
            this.outputStream = null;
            this.sender = null;
        }

        @Override
        public InputStream getInputStream() {
            if (this.inputStream == null) {
                this.inputStream = new ByteArrayInputStream(Request$package$.MODULE$.contentRaw(this.io$undertow$server$HttpServerExchange$DefaultBlockingHttpExchange$$exchange.req()));
            }
            return this.inputStream;
        }

        @Override
        public OutputStream getOutputStream() {
            if (this.outputStream == null) {
                this.outputStream = new OutputStream(this){
                    private byte[] responseData;
                    private final /* synthetic */ DefaultBlockingHttpExchange $outer;
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.responseData = Array$.MODULE$.emptyByteArray();
                    }

                    public void write(int b) {
                        throw Predef$.MODULE$.$qmark$qmark$qmark();
                    }

                    public void write(byte[] b) {
                        this.responseData = b;
                    }

                    public void write(byte[] b, int off, int len) {
                        throw Predef$.MODULE$.$qmark$qmark$qmark();
                    }

                    public void flush() {
                        throw Predef$.MODULE$.$qmark$qmark$qmark();
                    }

                    public void close() {
                        Request$package$.MODULE$.send_array(this.$outer.io$undertow$server$HttpServerExchange$DefaultBlockingHttpExchange$$exchange.req(), StatusCode.package.StatusCode$.MODULE$.apply(this.$outer.io$undertow$server$HttpServerExchange$DefaultBlockingHttpExchange$$exchange.io$undertow$server$HttpServerExchange$$state()), this.responseData, this.$outer.io$undertow$server$HttpServerExchange$DefaultBlockingHttpExchange$$exchange.io$undertow$server$HttpServerExchange$$responseHeaders().toSNUnitHeaders());
                    }
                };
            }
            return this.outputStream;
        }

        @Override
        public Sender getSender() {
            if (this.sender == null) {
                this.sender = new BlockingSenderImpl(this.io$undertow$server$HttpServerExchange$DefaultBlockingHttpExchange$$exchange, this.getOutputStream());
            }
            return this.sender;
        }

        @Override
        public void close() {
            try {
                this.getInputStream().close();
            }
            finally {
                this.getOutputStream().close();
            }
        }
    }
}

